/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.toast;

import android.app.Activity;
import android.app.Application;
import android.os.Build;
import android.os.Bundle;
import com.hjq.toast.ToastImpl;

final class WindowLifecycle
implements Application.ActivityLifecycleCallbacks {
    private Activity mActivity;
    private ToastImpl mToastImpl;

    WindowLifecycle(Activity activity) {
        this.mActivity = activity;
    }

    Activity getActivity() {
        return this.mActivity;
    }

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
    }

    public void onActivityStarted(Activity activity) {
    }

    public void onActivityResumed(Activity activity) {
    }

    public void onActivityPaused(Activity activity) {
        if (this.mActivity != activity) {
            return;
        }
        if (this.mToastImpl == null || !this.mToastImpl.isShow()) {
            return;
        }
        this.mToastImpl.cancel();
    }

    public void onActivityStopped(Activity activity) {
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
    }

    public void onActivityDestroyed(Activity activity) {
        if (this.mActivity != activity) {
            return;
        }
        this.unregister();
        this.mActivity = null;
    }

    void register(ToastImpl impl) {
        this.mToastImpl = impl;
        if (Build.VERSION.SDK_INT >= 29) {
            this.mActivity.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
        } else {
            this.mActivity.getApplication().registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
        }
    }

    void unregister() {
        this.mToastImpl = null;
        if (Build.VERSION.SDK_INT >= 29) {
            this.mActivity.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
        } else {
            this.mActivity.getApplication().unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
        }
    }
}

