/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.toast;

import android.app.AppOpsManager;
import android.app.Application;
import android.app.NotificationManager;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import android.widget.Toast;
import com.hjq.toast.BaseToast;
import com.hjq.toast.IToastInterceptor;
import com.hjq.toast.IToastStrategy;
import com.hjq.toast.IToastStyle;
import com.hjq.toast.SafeToast;
import com.hjq.toast.SupportToast;
import com.hjq.toast.ToastInterceptor;
import com.hjq.toast.ToastStrategy;
import com.hjq.toast.style.ToastBlackStyle;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public final class ToastUtils {
    private static IToastInterceptor sInterceptor;
    private static IToastStrategy sStrategy;
    private static IToastStyle sStyle;
    private static Toast sToast;

    private ToastUtils() {
    }

    public static void init(Application application, IToastStyle style2) {
        ToastUtils.initStyle(style2);
        ToastUtils.init(application);
    }

    public static void init(Application application) {
        ToastUtils.checkNullPointer(application);
        if (sInterceptor == null) {
            ToastUtils.setToastInterceptor(new ToastInterceptor());
        }
        if (sStrategy == null) {
            ToastUtils.setToastHandler(new ToastStrategy());
        }
        if (sStyle == null) {
            ToastUtils.initStyle(new ToastBlackStyle((Context)application));
        }
        if (ToastUtils.isNotificationEnabled((Context)application)) {
            if (Build.VERSION.SDK_INT == 25) {
                ToastUtils.setToast(new SafeToast(application));
            } else {
                ToastUtils.setToast(new BaseToast(application));
            }
        } else {
            ToastUtils.setToast(new SupportToast(application));
        }
        ToastUtils.setView((View)ToastUtils.createTextView(application.getApplicationContext()));
        ToastUtils.setGravity(sStyle.getGravity(), sStyle.getXOffset(), sStyle.getYOffset());
    }

    public static void show(Object object) {
        ToastUtils.show(object != null ? object.toString() : "null");
    }

    public static void show(int id2) {
        ToastUtils.checkToastState();
        try {
            ToastUtils.show(sToast.getView().getContext().getResources().getText(id2));
        }
        catch (Resources.NotFoundException ignored) {
            ToastUtils.show(String.valueOf(id2));
        }
    }

    public static synchronized void show(CharSequence text) {
        ToastUtils.checkToastState();
        if (sInterceptor.intercept(sToast, text)) {
            return;
        }
        sStrategy.show(text);
    }

    public static synchronized void cancel() {
        ToastUtils.checkToastState();
        sStrategy.cancel();
    }

    public static void setGravity(int gravity, int xOffset, int yOffset) {
        ToastUtils.checkToastState();
        if (Build.VERSION.SDK_INT >= 17) {
            gravity = Gravity.getAbsoluteGravity((int)gravity, (int)sToast.getView().getResources().getConfiguration().getLayoutDirection());
        }
        sToast.setGravity(gravity, xOffset, yOffset);
    }

    public static void setView(int layoutId) {
        ToastUtils.checkToastState();
        ToastUtils.setView(View.inflate((Context)sToast.getView().getContext().getApplicationContext(), (int)layoutId, null));
    }

    public static void setView(View view) {
        ToastUtils.checkToastState();
        ToastUtils.checkNullPointer(view);
        Context context = view.getContext();
        if (!(context instanceof Application)) {
            throw new IllegalArgumentException("The view must be initialized using the context of the application");
        }
        if (sToast != null) {
            sToast.cancel();
            sToast.setView(view);
        }
    }

    public static <V extends View> V getView() {
        ToastUtils.checkToastState();
        return (V)sToast.getView();
    }

    public static void initStyle(IToastStyle style2) {
        ToastUtils.checkNullPointer(style2);
        sStyle = style2;
        if (sToast != null) {
            sToast.cancel();
            sToast.setView((View)ToastUtils.createTextView(sToast.getView().getContext().getApplicationContext()));
            sToast.setGravity(sStyle.getGravity(), sStyle.getXOffset(), sStyle.getYOffset());
        }
    }

    public static void setToast(Toast toast) {
        ToastUtils.checkNullPointer(toast);
        sToast = toast;
        if (sStrategy != null) {
            sStrategy.bind(sToast);
        }
    }

    public static void setToastHandler(IToastStrategy handler) {
        ToastUtils.checkNullPointer(handler);
        sStrategy = handler;
        if (sToast != null) {
            sStrategy.bind(sToast);
        }
    }

    public static void setToastInterceptor(IToastInterceptor interceptor) {
        ToastUtils.checkNullPointer(interceptor);
        sInterceptor = interceptor;
    }

    public static Toast getToast() {
        return sToast;
    }

    private static void checkToastState() {
        if (sToast == null) {
            throw new IllegalStateException("ToastUtils has not been initialized");
        }
    }

    private static void checkNullPointer(Object object) {
        if (object == null) {
            throw new NullPointerException("are you ok?");
        }
    }

    private static TextView createTextView(Context context) {
        GradientDrawable drawable = new GradientDrawable();
        drawable.setColor(sStyle.getBackgroundColor());
        drawable.setCornerRadius((float)sStyle.getCornerRadius());
        TextView textView = new TextView(context);
        textView.setId(16908299);
        textView.setTextColor(sStyle.getTextColor());
        textView.setTextSize(0, sStyle.getTextSize());
        if (Build.VERSION.SDK_INT >= 16) {
            textView.setPaddingRelative(sStyle.getPaddingStart(), sStyle.getPaddingTop(), sStyle.getPaddingEnd(), sStyle.getPaddingBottom());
        } else {
            textView.setPadding(sStyle.getPaddingStart(), sStyle.getPaddingTop(), sStyle.getPaddingEnd(), sStyle.getPaddingBottom());
        }
        textView.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
        if (Build.VERSION.SDK_INT >= 16) {
            textView.setBackground((Drawable)drawable);
        } else {
            textView.setBackgroundDrawable((Drawable)drawable);
        }
        if (Build.VERSION.SDK_INT >= 21) {
            textView.setZ((float)sStyle.getZ());
        }
        if (sStyle.getMaxLines() > 0) {
            textView.setMaxLines(sStyle.getMaxLines());
        }
        return textView;
    }

    private static boolean isNotificationEnabled(Context context) {
        if (Build.VERSION.SDK_INT >= 24) {
            return ((NotificationManager)context.getSystemService("notification")).areNotificationsEnabled();
        }
        if (Build.VERSION.SDK_INT >= 19) {
            AppOpsManager appOps = (AppOpsManager)context.getSystemService("appops");
            ApplicationInfo appInfo = context.getApplicationInfo();
            String pkg = context.getApplicationContext().getPackageName();
            int uid = appInfo.uid;
            try {
                Class<?> appOpsClass = Class.forName(AppOpsManager.class.getName());
                Method checkOpNoThrowMethod = appOpsClass.getMethod("checkOpNoThrow", Integer.TYPE, Integer.TYPE, String.class);
                Field opPostNotificationValue = appOpsClass.getDeclaredField("OP_POST_NOTIFICATION");
                int value = (Integer)opPostNotificationValue.get(Integer.class);
                return (Integer)checkOpNoThrowMethod.invoke((Object)appOps, value, uid, pkg) == 0;
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException | NoSuchMethodException | RuntimeException | InvocationTargetException ignored) {
                return true;
            }
        }
        return true;
    }
}

