/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.toast;

import android.app.Application;
import android.os.Handler;
import android.os.Message;
import android.view.WindowManager;
import android.widget.Toast;
import com.hjq.toast.BaseToast;
import java.lang.reflect.Field;

final class SafeToast
extends BaseToast {
    SafeToast(Application application) {
        super(application);
        try {
            Field mTNField = Toast.class.getDeclaredField("mTN");
            mTNField.setAccessible(true);
            Object mTN = mTNField.get((Object)this);
            Field mHandlerField = mTNField.getType().getDeclaredField("mHandler");
            mHandlerField.setAccessible(true);
            Handler mHandler = (Handler)mHandlerField.get(mTN);
            mHandlerField.set(mTN, (Object)new SafeHandler(mHandler));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static final class SafeHandler
    extends Handler {
        private Handler mHandler;

        private SafeHandler(Handler handler) {
            this.mHandler = handler;
        }

        public void handleMessage(Message msg) {
            try {
                this.mHandler.handleMessage(msg);
            }
            catch (WindowManager.BadTokenException badTokenException) {
                // empty catch block
            }
        }
    }
}

