/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.toast;

import android.app.AppOpsManager;
import android.app.Application;
import android.app.NotificationManager;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import android.widget.Toast;
import com.hjq.toast.BaseToast;
import com.hjq.toast.IToastStyle;
import com.hjq.toast.SafeToast;
import com.hjq.toast.SupportToast;
import com.hjq.toast.ToastHandler;
import com.hjq.toast.style.ToastBlackStyle;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public final class ToastUtils {
    private static ToastHandler sToastHandler;
    private static IToastStyle sDefaultStyle;
    private static Toast sToast;

    private ToastUtils() {
    }

    public static void init(Application application, IToastStyle style2) {
        ToastUtils.initStyle(style2);
        ToastUtils.init(application);
    }

    public static void init(Application application) {
        if (sDefaultStyle == null) {
            sDefaultStyle = new ToastBlackStyle();
        }
        sToast = ToastUtils.isNotificationEnabled((Context)application) ? (Build.VERSION.SDK_INT == 25 ? new SafeToast(application) : new BaseToast(application)) : new SupportToast(application);
        sToastHandler = new ToastHandler(sToast);
        ToastUtils.setView((View)ToastUtils.createTextView(application.getApplicationContext()));
        ToastUtils.setGravity(sDefaultStyle.getGravity(), sDefaultStyle.getXOffset(), sDefaultStyle.getYOffset());
    }

    public static void show(Object object) {
        ToastUtils.show(object != null ? object.toString() : "null");
    }

    public static void show(int id2) {
        ToastUtils.checkToastState();
        try {
            ToastUtils.show(sToast.getView().getContext().getResources().getText(id2));
        }
        catch (Resources.NotFoundException ignored) {
            ToastUtils.show(String.valueOf(id2));
        }
    }

    public static void show(CharSequence text) {
        ToastUtils.checkToastState();
        if (text == null || "".equals(text.toString())) {
            return;
        }
        sToastHandler.add(text);
        sToastHandler.show();
    }

    public static void cancel() {
        ToastUtils.checkToastState();
        sToastHandler.cancel();
    }

    public static void setGravity(int gravity, int xOffset, int yOffset) {
        ToastUtils.checkToastState();
        if (Build.VERSION.SDK_INT >= 17) {
            gravity = Gravity.getAbsoluteGravity((int)gravity, (int)sToast.getView().getResources().getConfiguration().getLayoutDirection());
        }
        sToast.setGravity(gravity, xOffset, yOffset);
    }

    public static void setView(int layoutId) {
        ToastUtils.checkToastState();
        ToastUtils.setView(View.inflate((Context)sToast.getView().getContext().getApplicationContext(), (int)layoutId, null));
    }

    public static void setView(View view) {
        ToastUtils.checkToastState();
        if (view == null) {
            throw new IllegalArgumentException("Views cannot be empty");
        }
        if (view.getContext() != view.getContext().getApplicationContext()) {
            throw new IllegalArgumentException("The view must be initialized using the context of the application");
        }
        if (sToast != null) {
            sToast.cancel();
            sToast.setView(view);
        }
    }

    public static void initStyle(IToastStyle style2) {
        sDefaultStyle = style2;
        if (sToast != null) {
            sToast.cancel();
            sToast.setView((View)ToastUtils.createTextView(sToast.getView().getContext().getApplicationContext()));
            sToast.setGravity(sDefaultStyle.getGravity(), sDefaultStyle.getXOffset(), sDefaultStyle.getYOffset());
        }
    }

    public static Toast getToast() {
        return sToast;
    }

    private static void checkToastState() {
        if (sToast == null) {
            throw new IllegalStateException("ToastUtils has not been initialized");
        }
    }

    private static TextView createTextView(Context context) {
        GradientDrawable drawable = new GradientDrawable();
        drawable.setColor(sDefaultStyle.getBackgroundColor());
        drawable.setCornerRadius(TypedValue.applyDimension((int)1, (float)sDefaultStyle.getCornerRadius(), (DisplayMetrics)context.getResources().getDisplayMetrics()));
        TextView textView = new TextView(context);
        textView.setId(16908299);
        textView.setTextColor(sDefaultStyle.getTextColor());
        textView.setTextSize(0, TypedValue.applyDimension((int)2, (float)sDefaultStyle.getTextSize(), (DisplayMetrics)context.getResources().getDisplayMetrics()));
        textView.setPadding((int)TypedValue.applyDimension((int)1, (float)sDefaultStyle.getPaddingLeft(), (DisplayMetrics)context.getResources().getDisplayMetrics()), (int)TypedValue.applyDimension((int)1, (float)sDefaultStyle.getPaddingTop(), (DisplayMetrics)context.getResources().getDisplayMetrics()), (int)TypedValue.applyDimension((int)1, (float)sDefaultStyle.getPaddingRight(), (DisplayMetrics)context.getResources().getDisplayMetrics()), (int)TypedValue.applyDimension((int)1, (float)sDefaultStyle.getPaddingBottom(), (DisplayMetrics)context.getResources().getDisplayMetrics()));
        textView.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
        if (Build.VERSION.SDK_INT >= 16) {
            textView.setBackground((Drawable)drawable);
        } else {
            textView.setBackgroundDrawable((Drawable)drawable);
        }
        if (Build.VERSION.SDK_INT >= 21) {
            textView.setZ((float)sDefaultStyle.getZ());
        }
        if (sDefaultStyle.getMaxLines() > 0) {
            textView.setMaxLines(sDefaultStyle.getMaxLines());
        }
        return textView;
    }

    private static boolean isNotificationEnabled(Context context) {
        if (Build.VERSION.SDK_INT >= 24) {
            return ((NotificationManager)context.getSystemService("notification")).areNotificationsEnabled();
        }
        if (Build.VERSION.SDK_INT >= 19) {
            AppOpsManager appOps = (AppOpsManager)context.getSystemService("appops");
            ApplicationInfo appInfo = context.getApplicationInfo();
            String pkg = context.getApplicationContext().getPackageName();
            int uid = appInfo.uid;
            try {
                Class<?> appOpsClass = Class.forName(AppOpsManager.class.getName());
                Method checkOpNoThrowMethod = appOpsClass.getMethod("checkOpNoThrow", Integer.TYPE, Integer.TYPE, String.class);
                Field opPostNotificationValue = appOpsClass.getDeclaredField("OP_POST_NOTIFICATION");
                int value = (Integer)opPostNotificationValue.get(Integer.class);
                return (Integer)checkOpNoThrowMethod.invoke((Object)appOps, value, uid, pkg) == 0;
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException | NoSuchMethodException | RuntimeException | InvocationTargetException ignored) {
                return true;
            }
        }
        return true;
    }
}

