/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.toast;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Looper;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import android.widget.Toast;
import com.hjq.toast.DimensUtils;
import com.hjq.toast.IToastStyle;
import com.hjq.toast.ToastBlackStyle;

public final class ToastUtils {
    private static IToastStyle sDefaultStyle;
    private static Toast sToast;

    public static void init(Context context) {
        if (sDefaultStyle == null) {
            sDefaultStyle = new ToastBlackStyle();
        }
        if (context != context.getApplicationContext()) {
            context = context.getApplicationContext();
        }
        GradientDrawable drawable = new GradientDrawable();
        drawable.setColor(sDefaultStyle.getBackgroundColor());
        drawable.setCornerRadius((float)DimensUtils.dp2px(context, sDefaultStyle.getCornerRadius()));
        TextView textView = new TextView(context);
        textView.setTextColor(sDefaultStyle.getTextColor());
        textView.setTextSize(0, (float)DimensUtils.sp2px(context, sDefaultStyle.getTextSize()));
        textView.setPadding(DimensUtils.dp2px(context, sDefaultStyle.getPaddingLeft()), DimensUtils.dp2px(context, sDefaultStyle.getPaddingTop()), DimensUtils.dp2px(context, sDefaultStyle.getPaddingRight()), DimensUtils.dp2px(context, sDefaultStyle.getPaddingBottom()));
        textView.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
        textView.setBackgroundDrawable((Drawable)drawable);
        if (sDefaultStyle.getMaxLines() > 0) {
            textView.setMaxLines(sDefaultStyle.getMaxLines());
        }
        sToast = new Toast(context);
        sToast.setGravity(sDefaultStyle.getGravity(), sDefaultStyle.getXOffset(), sDefaultStyle.getYOffset());
        sToast.setView((View)textView);
    }

    public static void show(Object object) {
        if (object != null) {
            ToastUtils.show(object.toString());
        } else {
            ToastUtils.show("null");
        }
    }

    public static void show(CharSequence text) {
        if (sToast == null || text == null || text.equals("")) {
            return;
        }
        if (text.length() > 20) {
            sToast.setDuration(1);
        } else {
            sToast.setDuration(0);
        }
        try {
            ((TextView)sToast.getView()).setText(text);
            sToast.show();
        }
        catch (RuntimeException e) {
            try {
                Looper.prepare();
                ((TextView)sToast.getView()).setText(text);
                sToast.show();
                Looper.loop();
            }
            catch (Exception exception) {}
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Toast getToast() {
        return sToast;
    }

    public static void initStyle(IToastStyle style) {
        sDefaultStyle = style;
        if (sToast != null) {
            ToastUtils.init(sToast.getView().getContext().getApplicationContext());
        }
    }
}

