/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.shape.span;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.hjq.shape.config.ITextViewAttribute;
import com.hjq.shape.span.AlignmentReplacementSpan;

public abstract class CommonFontSpan
extends AlignmentReplacementSpan {
    private float mMeasureTextWidth;

    public CommonFontSpan(ITextViewAttribute textViewAttribute) {
        super(textViewAttribute);
    }

    public int getSize(@NonNull Paint paint, CharSequence text, int start, int end, @Nullable Paint.FontMetricsInt fontMetricsInt) {
        this.mMeasureTextWidth = this.onMeasure(paint, fontMetricsInt, text, start, end);
        Paint.FontMetricsInt metrics = paint.getFontMetricsInt();
        if (fontMetricsInt != null) {
            fontMetricsInt.top = metrics.top;
            fontMetricsInt.ascent = metrics.ascent;
            fontMetricsInt.descent = metrics.descent;
            fontMetricsInt.bottom = metrics.bottom;
        }
        return (int)this.mMeasureTextWidth;
    }

    public void draw(@NonNull Canvas canvas, CharSequence text, int start, int end, float x, int top, int y, int bottom, @NonNull Paint paint) {
        boolean isRtl;
        int alpha = paint.getAlpha();
        if (alpha != 255) {
            paint.setAlpha(255);
        }
        float textWidth = paint.measureText(text, start, end);
        float drawX = x;
        ITextViewAttribute textAttribute = this.getTextAttribute();
        float canvasWidth = canvas.getWidth() - textAttribute.getPaddingLeft() - textAttribute.getPaddingRight();
        int gravity = textAttribute.getTextGravity();
        boolean bl = isRtl = textAttribute.getLayoutDirection() == 1;
        if (this.hasFlag(gravity, 3)) {
            drawX = x;
        } else if (this.hasFlag(gravity, 5)) {
            drawX = canvasWidth - textWidth;
        } else if (isRtl && this.hasFlag(gravity, 0x800005) || !isRtl && this.hasFlag(gravity, 0x800003)) {
            drawX = x;
        } else if (isRtl && this.hasFlag(gravity, 0x800003) || !isRtl && this.hasFlag(gravity, 0x800005)) {
            drawX = Math.max(canvasWidth - textWidth, 0.0f);
        } else if (this.hasFlag(gravity, 17) || this.hasFlag(gravity, 1)) {
            drawX = Math.max((canvasWidth - textWidth) / 2.0f, 0.0f);
        }
        this.onDraw(canvas, paint, text, textWidth, start, end, drawX, top, y, bottom);
        paint.setAlpha(alpha);
    }

    public float onMeasure(@NonNull Paint paint, @Nullable Paint.FontMetricsInt fontMetricsInt, CharSequence text, @IntRange(from=0L) int start, @IntRange(from=0L) int end) {
        return paint.measureText(text, start, end);
    }

    public abstract void onDraw(@NonNull Canvas var1, @NonNull Paint var2, CharSequence var3, float var4, @IntRange(from=0L) int var5, @IntRange(from=0L) int var6, float var7, int var8, int var9, int var10);
}

