/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.shape.builder;

import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.support.v4.widget.CompoundButtonCompat;
import android.widget.CompoundButton;
import com.hjq.shape.R;
import com.hjq.shape.config.ICompoundButtonStyleable;

public final class ButtonDrawableBuilder {
    private final CompoundButton mCompoundButton;
    private Drawable mButtonDrawable;
    private Drawable mButtonPressedDrawable;
    private Drawable mButtonCheckedDrawable;
    private Drawable mButtonDisabledDrawable;
    private Drawable mButtonFocusedDrawable;
    private Drawable mButtonSelectedDrawable;

    public ButtonDrawableBuilder(CompoundButton compoundButton, TypedArray typedArray, ICompoundButtonStyleable styleable2) {
        this.mCompoundButton = compoundButton;
        if (typedArray.hasValue(styleable2.getButtonDrawableStyleable())) {
            this.mButtonDrawable = typedArray.getResourceId(styleable2.getButtonDrawableStyleable(), 0) != R.drawable.shape_view_placeholder ? typedArray.getDrawable(styleable2.getButtonDrawableStyleable()) : CompoundButtonCompat.getButtonDrawable((CompoundButton)this.mCompoundButton);
        } else {
            this.mButtonDrawable = null;
            this.mCompoundButton.setButtonDrawable(null);
        }
        if (typedArray.hasValue(styleable2.getButtonPressedDrawableStyleable())) {
            this.mButtonPressedDrawable = typedArray.getDrawable(styleable2.getButtonPressedDrawableStyleable());
        }
        if (typedArray.hasValue(styleable2.getButtonCheckedDrawableStyleable())) {
            this.mButtonCheckedDrawable = typedArray.getDrawable(styleable2.getButtonCheckedDrawableStyleable());
        }
        if (typedArray.hasValue(styleable2.getButtonDisabledDrawableStyleable())) {
            this.mButtonDisabledDrawable = typedArray.getDrawable(styleable2.getButtonDisabledDrawableStyleable());
        }
        if (typedArray.hasValue(styleable2.getButtonFocusedDrawableStyleable())) {
            this.mButtonFocusedDrawable = typedArray.getDrawable(styleable2.getButtonFocusedDrawableStyleable());
        }
        if (typedArray.hasValue(styleable2.getButtonSelectedDrawableStyleable())) {
            this.mButtonSelectedDrawable = typedArray.getDrawable(styleable2.getButtonSelectedDrawableStyleable());
        }
    }

    public ButtonDrawableBuilder setButtonDrawable(Drawable drawable2) {
        if (this.mButtonPressedDrawable == this.mButtonDrawable) {
            this.mButtonPressedDrawable = drawable2;
        }
        if (this.mButtonCheckedDrawable == this.mButtonDrawable) {
            this.mButtonCheckedDrawable = drawable2;
        }
        if (this.mButtonDisabledDrawable == this.mButtonDrawable) {
            this.mButtonDisabledDrawable = drawable2;
        }
        if (this.mButtonFocusedDrawable == this.mButtonDrawable) {
            this.mButtonFocusedDrawable = drawable2;
        }
        if (this.mButtonSelectedDrawable == this.mButtonDrawable) {
            this.mButtonSelectedDrawable = drawable2;
        }
        this.mButtonDrawable = drawable2;
        return this;
    }

    public Drawable getButtonDrawable() {
        return this.mButtonDrawable;
    }

    public ButtonDrawableBuilder setButtonPressedDrawable(Drawable drawable2) {
        this.mButtonPressedDrawable = drawable2;
        return this;
    }

    public Drawable getButtonPressedDrawable() {
        return this.mButtonPressedDrawable;
    }

    public ButtonDrawableBuilder setButtonCheckedDrawable(Drawable drawable2) {
        this.mButtonCheckedDrawable = drawable2;
        return this;
    }

    public Drawable getButtonCheckedDrawable() {
        return this.mButtonCheckedDrawable;
    }

    public ButtonDrawableBuilder setButtonDisabledDrawable(Drawable drawable2) {
        this.mButtonDisabledDrawable = drawable2;
        return this;
    }

    public Drawable getButtonDisabledDrawable() {
        return this.mButtonDisabledDrawable;
    }

    public ButtonDrawableBuilder setButtonFocusedDrawable(Drawable drawable2) {
        this.mButtonFocusedDrawable = drawable2;
        return this;
    }

    public Drawable getButtonFocusedDrawable() {
        return this.mButtonFocusedDrawable;
    }

    public ButtonDrawableBuilder setButtonSelectedDrawable(Drawable drawable2) {
        this.mButtonSelectedDrawable = drawable2;
        return this;
    }

    public Drawable getButtonSelectedDrawable() {
        return this.mButtonSelectedDrawable;
    }

    public void intoButtonDrawable() {
        if (this.mButtonDrawable == null) {
            return;
        }
        if (this.mButtonPressedDrawable == null && this.mButtonCheckedDrawable == null && this.mButtonDisabledDrawable == null && this.mButtonFocusedDrawable == null && this.mButtonSelectedDrawable == null) {
            this.mCompoundButton.setButtonDrawable(this.mButtonDrawable);
            return;
        }
        StateListDrawable drawable2 = new StateListDrawable();
        if (this.mButtonPressedDrawable != null) {
            drawable2.addState(new int[]{16842919}, this.mButtonPressedDrawable);
        }
        if (this.mButtonCheckedDrawable != null) {
            drawable2.addState(new int[]{0x10100A0}, this.mButtonCheckedDrawable);
        }
        if (this.mButtonDisabledDrawable != null) {
            drawable2.addState(new int[]{-16842910}, this.mButtonDisabledDrawable);
        }
        if (this.mButtonFocusedDrawable != null) {
            drawable2.addState(new int[]{16842908}, this.mButtonFocusedDrawable);
        }
        if (this.mButtonSelectedDrawable != null) {
            drawable2.addState(new int[]{0x10100A1}, this.mButtonSelectedDrawable);
        }
        drawable2.addState(new int[0], this.mButtonDrawable);
        this.mCompoundButton.setButtonDrawable((Drawable)drawable2);
    }
}

