/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.shape.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.v7.widget.AppCompatEditText;
import android.util.AttributeSet;
import android.view.View;
import android.widget.TextView;
import com.hjq.shape.R;
import com.hjq.shape.builder.ShapeDrawableBuilder;
import com.hjq.shape.builder.TextColorBuilder;
import com.hjq.shape.config.IGetShapeDrawableBuilder;
import com.hjq.shape.config.IGetTextColorBuilder;
import com.hjq.shape.styleable.ShapeEditTextStyleable;

public class ShapeEditText
extends AppCompatEditText
implements IGetShapeDrawableBuilder,
IGetTextColorBuilder {
    private static final ShapeEditTextStyleable STYLEABLE = new ShapeEditTextStyleable();
    private final ShapeDrawableBuilder mShapeDrawableBuilder;
    private final TextColorBuilder mTextColorBuilder;

    public ShapeEditText(Context context) {
        this(context, null);
    }

    public ShapeEditText(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.editTextStyle);
    }

    public ShapeEditText(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.ShapeEditText);
        this.mShapeDrawableBuilder = new ShapeDrawableBuilder((View)this, typedArray, STYLEABLE);
        this.mTextColorBuilder = new TextColorBuilder((TextView)this, typedArray, STYLEABLE);
        typedArray.recycle();
        this.mShapeDrawableBuilder.intoBackground();
        if (this.mTextColorBuilder.isTextGradientColorsEnable() || this.mTextColorBuilder.isTextStrokeColorEnable()) {
            this.setText((CharSequence)this.getText());
        } else {
            this.mTextColorBuilder.intoTextColor();
        }
    }

    public void setTextColor(int color) {
        super.setTextColor(color);
        if (this.mTextColorBuilder == null) {
            return;
        }
        this.mTextColorBuilder.setTextColor(color);
    }

    public void setText(CharSequence text, TextView.BufferType type) {
        if (this.mTextColorBuilder != null && (this.mTextColorBuilder.isTextGradientColorsEnable() || this.mTextColorBuilder.isTextStrokeColorEnable())) {
            super.setText((CharSequence)this.mTextColorBuilder.buildTextSpannable(text), type);
        } else {
            super.setText(text, type);
        }
    }

    @Override
    public ShapeDrawableBuilder getShapeDrawableBuilder() {
        return this.mShapeDrawableBuilder;
    }

    @Override
    public TextColorBuilder getTextColorBuilder() {
        return this.mTextColorBuilder;
    }
}

