/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.shape.other;

import android.graphics.Canvas;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.Shader;
import android.text.SpannableStringBuilder;
import android.text.style.ReplacementSpan;

public class LinearGradientFontSpan
extends ReplacementSpan {
    public static final int GRADIENT_ORIENTATION_HORIZONTAL = 0;
    public static final int GRADIENT_ORIENTATION_VERTICAL = 1;
    private float mMeasureTextWidth;
    private int mTextGradientOrientation;
    private int[] mTextGradientColors;
    private float[] mTextGradientPositions;

    public static SpannableStringBuilder buildLinearGradientSpannable(CharSequence text, int[] colors, float[] positions, int orientation) {
        SpannableStringBuilder builder = new SpannableStringBuilder(text);
        LinearGradientFontSpan span = new LinearGradientFontSpan();
        span.setTextGradientColor(colors);
        span.setTextGradientOrientation(orientation);
        span.setTextGradientPositions(positions);
        builder.setSpan((Object)span, 0, builder.length(), 33);
        return builder;
    }

    public int getSize(Paint paint, CharSequence text, int start, int end, Paint.FontMetricsInt fontMetricsInt) {
        this.mMeasureTextWidth = paint.measureText(text, start, end);
        Paint.FontMetricsInt metrics = paint.getFontMetricsInt();
        if (fontMetricsInt != null) {
            fontMetricsInt.top = metrics.top;
            fontMetricsInt.ascent = metrics.ascent;
            fontMetricsInt.descent = metrics.descent;
            fontMetricsInt.bottom = metrics.bottom;
        }
        return (int)this.mMeasureTextWidth;
    }

    public void draw(Canvas canvas, CharSequence text, int start, int end, float x, int top, int y, int bottom, Paint paint) {
        LinearGradient linearGradient = this.mTextGradientOrientation == 1 ? new LinearGradient(0.0f, 0.0f, 0.0f, paint.descent() - paint.ascent(), this.mTextGradientColors, this.mTextGradientPositions, Shader.TileMode.REPEAT) : new LinearGradient(x, 0.0f, x + this.mMeasureTextWidth, 0.0f, this.mTextGradientColors, this.mTextGradientPositions, Shader.TileMode.REPEAT);
        paint.setShader((Shader)linearGradient);
        int alpha = paint.getAlpha();
        if (alpha != 255) {
            paint.setAlpha(255);
        }
        canvas.drawText(text, start, end, x, (float)y, paint);
        paint.setAlpha(alpha);
    }

    public LinearGradientFontSpan setTextGradientOrientation(int orientation) {
        this.mTextGradientOrientation = orientation;
        return this;
    }

    public LinearGradientFontSpan setTextGradientColor(int[] colors) {
        this.mTextGradientColors = colors;
        return this;
    }

    public LinearGradientFontSpan setTextGradientPositions(float[] positions) {
        this.mTextGradientPositions = positions;
        return this;
    }
}

