/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.shape.layout;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.widget.FrameLayout;
import com.hjq.shape.IShapeDrawable;
import com.hjq.shape.R;

public class ShapeFrameLayout
extends FrameLayout
implements IShapeDrawable<ShapeFrameLayout> {
    private int mShape;
    private int mShapeWidth;
    private int mShapeHeight;
    private int mSolidColor;
    private int mSolidPressedColor;
    private int mSolidDisabledColor;
    private int mSolidFocusedColor;
    private int mSolidSelectedColor;
    private int mTopLeftRadius;
    private int mTopRightRadius;
    private int mBottomLeftRadius;
    private int mBottomRightRadius;
    private int mStartColor;
    private int mCenterColor;
    private int mEndColor;
    private boolean mUseLevel;
    private int mAngle;
    private int mGradientType;
    private float mCenterX;
    private float mCenterY;
    private int mGradientRadius;
    private int mStrokeColor;
    private int mStrokePressedColor;
    private int mStrokeDisabledColor;
    private int mStrokeFocusedColor;
    private int mStrokeSelectedColor;
    private int mStrokeWidth;
    private int mDashWidth;
    private int mDashGap;

    public ShapeFrameLayout(Context context) {
        this(context, null);
    }

    public ShapeFrameLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ShapeFrameLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.ShapeFrameLayout);
        this.mShape = typedArray.getInt(R.styleable.ShapeFrameLayout_shape, 0);
        this.mShapeWidth = typedArray.getDimensionPixelSize(R.styleable.ShapeFrameLayout_shape_width, -1);
        this.mShapeHeight = typedArray.getDimensionPixelSize(R.styleable.ShapeFrameLayout_shape_height, -1);
        this.mSolidColor = typedArray.getColor(R.styleable.ShapeFrameLayout_shape_solidColor, 0);
        this.mSolidPressedColor = typedArray.getColor(R.styleable.ShapeFrameLayout_shape_solidPressedColor, this.mSolidColor);
        this.mSolidDisabledColor = typedArray.getColor(R.styleable.ShapeFrameLayout_shape_solidDisabledColor, this.mSolidColor);
        this.mSolidFocusedColor = typedArray.getColor(R.styleable.ShapeFrameLayout_shape_solidFocusedColor, this.mSolidColor);
        this.mSolidSelectedColor = typedArray.getColor(R.styleable.ShapeFrameLayout_shape_solidSelectedColor, this.mSolidColor);
        int radius = typedArray.getDimensionPixelSize(R.styleable.ShapeFrameLayout_shape_radius, 0);
        this.mTopLeftRadius = typedArray.getDimensionPixelSize(R.styleable.ShapeFrameLayout_shape_topLeftRadius, radius);
        this.mTopRightRadius = typedArray.getDimensionPixelSize(R.styleable.ShapeFrameLayout_shape_topRightRadius, radius);
        this.mBottomLeftRadius = typedArray.getDimensionPixelSize(R.styleable.ShapeFrameLayout_shape_bottomLeftRadius, radius);
        this.mBottomRightRadius = typedArray.getDimensionPixelSize(R.styleable.ShapeFrameLayout_shape_bottomRightRadius, radius);
        this.mStartColor = typedArray.getColor(R.styleable.ShapeFrameLayout_shape_startColor, 0);
        this.mCenterColor = typedArray.getColor(R.styleable.ShapeFrameLayout_shape_centerColor, 0);
        this.mEndColor = typedArray.getColor(R.styleable.ShapeFrameLayout_shape_endColor, 0);
        this.mUseLevel = typedArray.getBoolean(R.styleable.ShapeFrameLayout_shape_useLevel, false);
        this.mAngle = (int)typedArray.getFloat(R.styleable.ShapeFrameLayout_shape_angle, 0.0f);
        this.mGradientType = typedArray.getInt(R.styleable.ShapeFrameLayout_shape_gradientType, 0);
        this.mCenterX = typedArray.getFloat(R.styleable.ShapeFrameLayout_shape_centerX, 0.5f);
        this.mCenterY = typedArray.getFloat(R.styleable.ShapeFrameLayout_shape_centerY, 0.5f);
        this.mGradientRadius = typedArray.getDimensionPixelSize(R.styleable.ShapeFrameLayout_shape_gradientRadius, radius);
        this.mStrokeColor = typedArray.getColor(R.styleable.ShapeFrameLayout_shape_strokeColor, 0);
        this.mStrokePressedColor = typedArray.getColor(R.styleable.ShapeFrameLayout_shape_strokePressedColor, this.mStrokeColor);
        this.mStrokeDisabledColor = typedArray.getColor(R.styleable.ShapeFrameLayout_shape_strokeDisabledColor, this.mStrokeColor);
        this.mStrokeFocusedColor = typedArray.getColor(R.styleable.ShapeFrameLayout_shape_strokeFocusedColor, this.mStrokeColor);
        this.mStrokeSelectedColor = typedArray.getColor(R.styleable.ShapeFrameLayout_shape_strokeSelectedColor, this.mStrokeColor);
        this.mStrokeWidth = typedArray.getDimensionPixelSize(R.styleable.ShapeFrameLayout_shape_strokeWidth, 0);
        this.mDashWidth = (int)typedArray.getDimension(R.styleable.ShapeFrameLayout_shape_dashWidth, 0.0f);
        this.mDashGap = (int)typedArray.getDimension(R.styleable.ShapeFrameLayout_shape_dashGap, 0.0f);
        typedArray.recycle();
        this.intoBackground();
    }

    @Override
    public ShapeFrameLayout setShape(int shape) {
        this.mShape = shape;
        return this;
    }

    @Override
    public int getShape() {
        return this.mShape;
    }

    @Override
    public ShapeFrameLayout setShapeWidth(int width) {
        this.mShapeWidth = width;
        return this;
    }

    @Override
    public int getShapeWidth() {
        return this.mShapeWidth;
    }

    @Override
    public ShapeFrameLayout setShapeHeight(int height) {
        this.mShapeHeight = height;
        return this;
    }

    @Override
    public int getShapeHeight() {
        return this.mShapeHeight;
    }

    @Override
    public ShapeFrameLayout setSolidColor(int color) {
        this.mSolidColor = color;
        return this;
    }

    @Override
    public int getSolidColor() {
        return this.mSolidColor;
    }

    @Override
    public ShapeFrameLayout setSolidPressedColor(int color) {
        this.mSolidPressedColor = color;
        return this;
    }

    @Override
    public int getSolidPressedColor() {
        return this.mSolidPressedColor;
    }

    @Override
    public ShapeFrameLayout setSolidDisabledColor(int color) {
        this.mSolidDisabledColor = color;
        return this;
    }

    @Override
    public int getSolidDisabledColor() {
        return this.mSolidDisabledColor;
    }

    @Override
    public ShapeFrameLayout setSolidFocusedColor(int color) {
        this.mSolidFocusedColor = color;
        return this;
    }

    @Override
    public int getSolidFocusedColor() {
        return this.mSolidFocusedColor;
    }

    @Override
    public ShapeFrameLayout setSolidSelectedColor(int color) {
        this.mSolidSelectedColor = color;
        return this;
    }

    @Override
    public int getSolidSelectedColor() {
        return this.mSolidSelectedColor;
    }

    @Override
    public ShapeFrameLayout setTopLeftRadius(int radius) {
        this.mTopLeftRadius = radius;
        return this;
    }

    @Override
    public int getTopLeftRadius() {
        return this.mTopLeftRadius;
    }

    @Override
    public ShapeFrameLayout setTopRightRadius(int radius) {
        this.mTopRightRadius = radius;
        return this;
    }

    @Override
    public int getTopRightRadius() {
        return this.mTopRightRadius;
    }

    @Override
    public ShapeFrameLayout setBottomLeftRadius(int radius) {
        this.mBottomLeftRadius = radius;
        return this;
    }

    @Override
    public int getBottomLeftRadius() {
        return this.mBottomLeftRadius;
    }

    @Override
    public ShapeFrameLayout setBottomRightRadius(int radius) {
        this.mBottomRightRadius = radius;
        return this;
    }

    @Override
    public int getBottomRightRadius() {
        return this.mBottomRightRadius;
    }

    @Override
    public ShapeFrameLayout setStartColor(int color) {
        this.mStartColor = color;
        return this;
    }

    @Override
    public int getStartColor() {
        return this.mStartColor;
    }

    @Override
    public ShapeFrameLayout setCenterColor(int color) {
        this.mCenterColor = color;
        return this;
    }

    @Override
    public int getCenterColor() {
        return this.mCenterColor;
    }

    @Override
    public ShapeFrameLayout setEndColor(int color) {
        this.mEndColor = color;
        return this;
    }

    @Override
    public int getEndColor() {
        return this.mEndColor;
    }

    @Override
    public ShapeFrameLayout setUseLevel(boolean useLevel) {
        this.mUseLevel = useLevel;
        return this;
    }

    @Override
    public boolean isUseLevel() {
        return this.mUseLevel;
    }

    @Override
    public ShapeFrameLayout setAngle(int angle) {
        this.mAngle = angle;
        return this;
    }

    @Override
    public int getAngle() {
        return this.mAngle;
    }

    @Override
    public ShapeFrameLayout setGradientType(int type) {
        this.mGradientType = type;
        return this;
    }

    @Override
    public int getGradientType() {
        return this.mGradientType;
    }

    @Override
    public ShapeFrameLayout setCenterX(float x) {
        this.mCenterX = x;
        return this;
    }

    @Override
    public float getCenterX() {
        return this.mCenterX;
    }

    @Override
    public ShapeFrameLayout setCenterY(float y) {
        this.mCenterY = y;
        return this;
    }

    @Override
    public float getCenterY() {
        return this.mCenterY;
    }

    @Override
    public ShapeFrameLayout setGradientRadius(int radius) {
        this.mGradientRadius = radius;
        return this;
    }

    @Override
    public int getGradientRadius() {
        return this.mGradientRadius;
    }

    @Override
    public ShapeFrameLayout setStrokeColor(int color) {
        this.mStrokeColor = color;
        return this;
    }

    @Override
    public int getStrokeColor() {
        return this.mStrokeColor;
    }

    @Override
    public ShapeFrameLayout setStrokePressedColor(int color) {
        this.mStrokePressedColor = color;
        return this;
    }

    @Override
    public int getStrokePressedColor() {
        return this.mStrokePressedColor;
    }

    @Override
    public ShapeFrameLayout setStrokeDisabledColor(int color) {
        this.mStrokeDisabledColor = color;
        return this;
    }

    @Override
    public int getStrokeDisabledColor() {
        return this.mStrokeDisabledColor;
    }

    @Override
    public ShapeFrameLayout setStrokeFocusedColor(int color) {
        this.mStrokeFocusedColor = color;
        return this;
    }

    @Override
    public int getStrokeFocusedColor() {
        return this.mStrokeFocusedColor;
    }

    @Override
    public ShapeFrameLayout setStrokeSelectedColor(int color) {
        this.mStrokeSelectedColor = color;
        return this;
    }

    @Override
    public int getStrokeSelectedColor() {
        return this.mStrokeSelectedColor;
    }

    @Override
    public ShapeFrameLayout setStrokeWidth(int width) {
        this.mStrokeWidth = width;
        return this;
    }

    @Override
    public int getStrokeWidth() {
        return this.mStrokeWidth;
    }

    @Override
    public ShapeFrameLayout setDashWidth(int width) {
        this.mDashWidth = width;
        return this;
    }

    @Override
    public int getDashWidth() {
        return this.mDashWidth;
    }

    @Override
    public ShapeFrameLayout setDashGap(int gap) {
        this.mDashGap = gap;
        return this;
    }

    @Override
    public int getDashGap() {
        return this.mDashGap;
    }

    @Override
    public void intoBackground() {
        this.setBackground(this.buildDrawable());
    }
}

