/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.language;

import android.app.Application;
import android.content.ComponentCallbacks;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import com.hjq.language.LanguagesConfig;
import com.hjq.language.LanguagesUtils;
import com.hjq.language.MultiLanguages;
import com.hjq.language.OnLanguageListener;
import java.util.Locale;

final class LanguagesObserver
implements ComponentCallbacks {
    private static volatile Locale sSystemLanguage = LanguagesUtils.getLocale(Resources.getSystem().getConfiguration());

    LanguagesObserver() {
    }

    static Locale getSystemLanguage() {
        return sSystemLanguage;
    }

    static void register(Application application) {
        application.registerComponentCallbacks((ComponentCallbacks)new LanguagesObserver());
    }

    public void onConfigurationChanged(Configuration newConfig) {
        OnLanguageListener listener;
        Locale newLocale = LanguagesUtils.getLocale(newConfig);
        Locale oldLocale = sSystemLanguage;
        LanguagesUtils.updateConfigurationChanged((Context)MultiLanguages.getApplication(), newConfig);
        if (newLocale.equals(oldLocale)) {
            return;
        }
        sSystemLanguage = newLocale;
        if (LanguagesConfig.isSystemLanguage((Context)MultiLanguages.getApplication())) {
            LanguagesConfig.clearLanguage((Context)MultiLanguages.getApplication());
        }
        if ((listener = MultiLanguages.getOnLanguagesListener()) != null) {
            listener.onSystemLocaleChange(oldLocale, newLocale);
        }
    }

    public void onLowMemory() {
    }
}

