/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.logcat;

import android.app.Activity;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.os.Process;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.View;
import android.widget.AdapterView;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.EditText;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.hjq.logcat.ChooseWindow;
import com.hjq.logcat.LogcatAdapter;
import com.hjq.logcat.LogcatConfig;
import com.hjq.logcat.LogcatInfo;
import com.hjq.logcat.LogcatManager;
import com.hjq.logcat.R;
import com.hjq.xtoast.XToast;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public final class LogcatActivity
extends Activity
implements TextWatcher,
View.OnLongClickListener,
View.OnClickListener,
CompoundButton.OnCheckedChangeListener,
LogcatManager.Callback,
AdapterView.OnItemLongClickListener,
AdapterView.OnItemClickListener {
    private static final String[] ARRAY_LOG_LEVEL = new String[]{"Verbose", "Debug", "Info", "Warn", "Error"};
    private static final String FILE_TYPE = "Logcat";
    private static final String LOGCAT_TAG_FILTER_FILE = "logcat_tag_filter.txt";
    private final List<LogcatInfo> mLogData = new ArrayList<LogcatInfo>();
    private CheckBox mSwitchView;
    private View mSaveView;
    private TextView mLevelView;
    private EditText mSearchView;
    private View mEmptyView;
    private View mCleanView;
    private View mCloseView;
    private ListView mListView;
    private View mDownView;
    private LogcatAdapter mAdapter;
    private String mLogLevel = "V";
    private final List<String> mTagFilter = new ArrayList<String>();

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.getWindow().addFlags(1024);
        this.setContentView(R.layout.logcat_window_logcat);
        this.mSwitchView = (CheckBox)this.findViewById(R.id.iv_log_switch);
        this.mSaveView = this.findViewById(R.id.iv_log_save);
        this.mLevelView = (TextView)this.findViewById(R.id.tv_log_level);
        this.mSearchView = (EditText)this.findViewById(R.id.et_log_search);
        this.mEmptyView = this.findViewById(R.id.iv_log_empty);
        this.mCleanView = this.findViewById(R.id.iv_log_clean);
        this.mCloseView = this.findViewById(R.id.iv_log_close);
        this.mListView = (ListView)this.findViewById(R.id.lv_log_list);
        this.mDownView = this.findViewById(R.id.ib_log_down);
        this.mAdapter = new LogcatAdapter();
        this.mListView.setAdapter((ListAdapter)this.mAdapter);
        this.mListView.setOnItemClickListener((AdapterView.OnItemClickListener)this);
        this.mListView.setOnItemLongClickListener((AdapterView.OnItemLongClickListener)this);
        this.mSwitchView.setOnCheckedChangeListener((CompoundButton.OnCheckedChangeListener)this);
        this.mSearchView.addTextChangedListener((TextWatcher)this);
        this.mSearchView.setText((CharSequence)LogcatConfig.getLogcatText());
        this.setLogLevel(LogcatConfig.getLogcatLevel());
        this.mSaveView.setOnClickListener((View.OnClickListener)this);
        this.mLevelView.setOnClickListener((View.OnClickListener)this);
        this.mEmptyView.setOnClickListener((View.OnClickListener)this);
        this.mCleanView.setOnClickListener((View.OnClickListener)this);
        this.mCloseView.setOnClickListener((View.OnClickListener)this);
        this.mDownView.setOnClickListener((View.OnClickListener)this);
        this.mSaveView.setOnLongClickListener((View.OnLongClickListener)this);
        this.mSwitchView.setOnLongClickListener((View.OnLongClickListener)this);
        this.mLevelView.setOnLongClickListener((View.OnLongClickListener)this);
        this.mCleanView.setOnLongClickListener((View.OnLongClickListener)this);
        this.mCloseView.setOnLongClickListener((View.OnLongClickListener)this);
        LogcatManager.start(this);
        this.mListView.postDelayed(new Runnable(){

            @Override
            public void run() {
                LogcatActivity.this.mListView.setSelection(LogcatActivity.this.mAdapter.getCount() - 1);
            }
        }, 1000L);
        this.initFilter();
    }

    @Override
    public void onReceiveLog(LogcatInfo info) {
        if (Integer.parseInt(info.getPid()) != Process.myPid()) {
            return;
        }
        if (!this.mTagFilter.contains(info.getTag())) {
            this.mListView.post((Runnable)new LogRunnable(info));
        }
    }

    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        this.mAdapter.onItemClick(position);
    }

    public boolean onItemLongClick(AdapterView<?> parent, View view, final int position, long id2) {
        new ChooseWindow(this).setList(R.string.logcat_options_copy, R.string.logcat_options_share, R.string.logcat_options_delete, R.string.logcat_options_shield).setListener(new ChooseWindow.OnListener(){

            @Override
            public void onSelected(int location) {
                switch (location) {
                    case 0: {
                        ClipboardManager manager = (ClipboardManager)LogcatActivity.this.getSystemService("clipboard");
                        if (manager != null) {
                            manager.setPrimaryClip(ClipData.newPlainText((CharSequence)"log", (CharSequence)LogcatActivity.this.mAdapter.getItem(position).getLog()));
                            LogcatActivity.this.toast(R.string.logcat_copy_succeed);
                            break;
                        }
                        LogcatActivity.this.toast(R.string.logcat_copy_fail);
                        break;
                    }
                    case 1: {
                        Intent intent = new Intent("android.intent.action.SEND");
                        intent.setType("text/plain");
                        intent.putExtra("android.intent.extra.TEXT", LogcatActivity.this.mAdapter.getItem(position).getLog());
                        LogcatActivity.this.startActivity(Intent.createChooser((Intent)intent, (CharSequence)LogcatActivity.this.getResources().getString(R.string.logcat_options_share)));
                        break;
                    }
                    case 2: {
                        LogcatActivity.this.mLogData.remove(LogcatActivity.this.mAdapter.getItem(position));
                        LogcatActivity.this.mAdapter.removeItem(position);
                        break;
                    }
                    case 3: {
                        LogcatActivity.this.addFilter(LogcatActivity.this.mAdapter.getItem(position).getTag());
                        break;
                    }
                }
            }
        }).show();
        return true;
    }

    public boolean onLongClick(View v) {
        if (v == this.mSwitchView) {
            this.toast(R.string.logcat_capture);
        } else if (v == this.mSaveView) {
            this.toast(R.string.logcat_save);
        } else if (v == this.mLevelView) {
            this.toast(R.string.logcat_level);
        } else if (v == this.mCleanView) {
            this.toast(R.string.logcat_empty);
        } else if (v == this.mCloseView) {
            this.toast(R.string.logcat_close);
        }
        return true;
    }

    public void onClick(View v) {
        if (v == this.mSaveView) {
            this.saveLogToFile();
        } else if (v == this.mLevelView) {
            new ChooseWindow(this).setList(ARRAY_LOG_LEVEL).setListener(new ChooseWindow.OnListener(){

                @Override
                public void onSelected(int position) {
                    switch (position) {
                        case 0: {
                            LogcatActivity.this.setLogLevel("V");
                            break;
                        }
                        case 1: {
                            LogcatActivity.this.setLogLevel("D");
                            break;
                        }
                        case 2: {
                            LogcatActivity.this.setLogLevel("I");
                            break;
                        }
                        case 3: {
                            LogcatActivity.this.setLogLevel("W");
                            break;
                        }
                        case 4: {
                            LogcatActivity.this.setLogLevel("E");
                            break;
                        }
                    }
                }
            }).show();
        } else if (v == this.mEmptyView) {
            this.mSearchView.setText((CharSequence)"");
        } else if (v == this.mCleanView) {
            LogcatManager.clear();
            this.mAdapter.clearData();
        } else if (v == this.mCloseView) {
            this.onBackPressed();
        } else if (v == this.mDownView) {
            this.mListView.smoothScrollToPosition(this.mAdapter.getCount() - 1);
        }
    }

    public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
        if (isChecked) {
            this.toast(R.string.logcat_capture_pause);
            LogcatManager.pause();
        } else {
            LogcatManager.resume();
        }
    }

    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
    }

    public void onTextChanged(CharSequence s, int start, int before, int count) {
    }

    public void afterTextChanged(Editable s) {
        String keyword = s.toString().trim();
        LogcatConfig.setLogcatText(keyword);
        this.mAdapter.setKeyword(keyword);
        this.mAdapter.clearData();
        for (LogcatInfo info : this.mLogData) {
            if (!"V".equals(this.mLogLevel) && !info.getLevel().equals(this.mLogLevel)) continue;
            if (!"".equals(keyword)) {
                if (!info.getLog().contains(keyword) && !info.getTag().contains(keyword)) continue;
                this.mAdapter.addItem(info);
                continue;
            }
            this.mAdapter.addItem(info);
        }
        this.mListView.setSelection(this.mAdapter.getCount() - 1);
        this.mEmptyView.setVisibility("".equals(keyword) ? 8 : 0);
    }

    private void setLogLevel(String level) {
        if (level.equals(this.mLogLevel)) {
            return;
        }
        this.mLogLevel = level;
        LogcatConfig.setLogcatLevel(level);
        this.afterTextChanged(this.mSearchView.getText());
        switch (level) {
            case "V": {
                this.mLevelView.setText((CharSequence)ARRAY_LOG_LEVEL[0]);
                break;
            }
            case "D": {
                this.mLevelView.setText((CharSequence)ARRAY_LOG_LEVEL[1]);
                break;
            }
            case "I": {
                this.mLevelView.setText((CharSequence)ARRAY_LOG_LEVEL[2]);
                break;
            }
            case "W": {
                this.mLevelView.setText((CharSequence)ARRAY_LOG_LEVEL[3]);
                break;
            }
            case "E": {
                this.mLevelView.setText((CharSequence)ARRAY_LOG_LEVEL[4]);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initFilter() {
        File file = new File(this.getExternalFilesDir(FILE_TYPE), LOGCAT_TAG_FILTER_FILE);
        if (file.exists() && file.isFile()) {
            BufferedReader reader = null;
            try {
                String tag;
                reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), Build.VERSION.SDK_INT >= 19 ? StandardCharsets.UTF_8 : Charset.forName("UTF-8")));
                while ((tag = reader.readLine()) != null) {
                    this.mTagFilter.add(tag);
                }
            }
            catch (IOException e) {
                this.toast(R.string.logcat_read_config_fail);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFilter(String tag) {
        this.mTagFilter.add(tag);
        BufferedWriter writer = null;
        try {
            File file = new File(this.getExternalFilesDir(FILE_TYPE), LOGCAT_TAG_FILTER_FILE);
            if (!file.isFile()) {
                file.delete();
            }
            if (!file.exists()) {
                file.createNewFile();
            }
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file, false), Build.VERSION.SDK_INT >= 19 ? StandardCharsets.UTF_8 : Charset.forName("UTF-8")));
            for (String temp : this.mTagFilter) {
                writer.write(temp + "\r\n");
            }
            writer.flush();
            ArrayList<LogcatInfo> removeData = new ArrayList<LogcatInfo>();
            List<LogcatInfo> allData = this.mAdapter.getData();
            for (LogcatInfo info : allData) {
                if (!info.getTag().equals(tag)) continue;
                removeData.add(info);
            }
            for (LogcatInfo info : removeData) {
                allData.remove(info);
                this.mAdapter.notifyDataSetChanged();
            }
            this.toast(this.getResources().getString(R.string.logcat_shield_succeed) + file.getPath());
        }
        catch (IOException e) {
            this.toast(R.string.logcat_shield_fail);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveLogToFile() {
        BufferedWriter writer = null;
        try {
            File file;
            File directory = this.getExternalFilesDir(FILE_TYPE);
            if (!directory.isDirectory()) {
                directory.delete();
            }
            if (!directory.exists()) {
                directory.mkdirs();
            }
            if (!(file = new File(directory, new SimpleDateFormat("yyyyMMdd_kkmmss", Locale.getDefault()).format(new Date()) + ".txt")).isFile()) {
                file.delete();
            }
            if (!file.exists()) {
                file.createNewFile();
            }
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file, false), Charset.forName("UTF-8")));
            List<LogcatInfo> data = this.mAdapter.getData();
            for (LogcatInfo info : data) {
                writer.write(info.toString().replace("\n", "\r\n") + "\r\n\r\n");
            }
            writer.flush();
            this.toast(this.getResources().getString(R.string.logcat_save_succeed) + file.getPath());
        }
        catch (IOException e) {
            e.printStackTrace();
            this.toast(this.getResources().getString(R.string.logcat_save_fail));
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void toast(int stringId) {
        this.toast(this.getResources().getString(stringId));
    }

    private void toast(CharSequence text) {
        new XToast((Activity)this).setView(R.layout.logcat_window_toast).setDuration(3000).setGravity(17).setAnimStyle(16973828).setText(16908299, text).show();
    }

    public void onBackPressed() {
        this.moveTaskToBack(false);
    }

    protected void onResume() {
        super.onResume();
        LogcatManager.resume();
    }

    protected void onPause() {
        super.onPause();
        LogcatManager.pause();
    }

    protected void onDestroy() {
        super.onDestroy();
        LogcatManager.destroy();
    }

    private class LogRunnable
    implements Runnable {
        private final LogcatInfo info;

        private LogRunnable(LogcatInfo info) {
            this.info = info;
        }

        @Override
        public void run() {
            if (LogcatActivity.this.mLogData.size() > 0) {
                LogcatInfo lastInfo = (LogcatInfo)LogcatActivity.this.mLogData.get(LogcatActivity.this.mLogData.size() - 1);
                if (this.info.getLevel().equals(lastInfo.getLevel()) && this.info.getTag().equals(lastInfo.getTag())) {
                    lastInfo.addLog(this.info.getLog());
                    LogcatActivity.this.mAdapter.notifyDataSetChanged();
                    return;
                }
            }
            LogcatActivity.this.mLogData.add(this.info);
            String content = LogcatActivity.this.mSearchView.getText().toString();
            if ("".equals(content) && "V".equals(LogcatActivity.this.mLogLevel)) {
                LogcatActivity.this.mAdapter.addItem(this.info);
                return;
            }
            if (this.info.getLevel().equals(LogcatActivity.this.mLogLevel) && (this.info.getLog().contains(content) || this.info.getTag().contains(content))) {
                LogcatActivity.this.mAdapter.addItem(this.info);
            }
        }
    }
}

