/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.logcat;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import com.hjq.logcat.LogcatUtils;
import java.util.Locale;

final class LogcatConfig {
    @SuppressLint(value={"StaticFieldLeak"})
    private static Context sApplicationContext;
    private static SharedPreferences sConfig;

    LogcatConfig() {
    }

    static void init(Context context) {
        sApplicationContext = context.getApplicationContext();
        sConfig = sApplicationContext.getSharedPreferences("logcat", 0);
    }

    static String getLogLevelConfig() {
        String logLevel;
        String defaultLogLevel = LogcatUtils.getMetaStringData(sApplicationContext, "LogcatDefaultLogLevel");
        if (defaultLogLevel != null && !defaultLogLevel.isEmpty()) {
            defaultLogLevel = defaultLogLevel.toUpperCase(Locale.ROOT);
        }
        if ((logLevel = sConfig.getString("logcat_log_level", defaultLogLevel)) == null || logLevel.isEmpty()) {
            logLevel = "V";
        }
        return logLevel;
    }

    static void setLogLevelConfig(String logLevel) {
        sConfig.edit().putString("logcat_log_level", logLevel).apply();
    }

    static String getSearchKeyConfig() {
        String defaultSearchKey = LogcatUtils.getMetaStringData(sApplicationContext, "LogcatDefaultSearchKey");
        return sConfig.getString("logcat_search_key", defaultSearchKey);
    }

    static void setSearchKeyConfig(String searchKey) {
        sConfig.edit().putString("logcat_search_key", searchKey).apply();
    }
}

