/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.logcat;

import android.os.SystemClock;
import com.hjq.logcat.LogcatInfo;
import com.hjq.logcat.LogcatUtils;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

final class LogcatManager {
    private static volatile Callback sCallback;
    private static volatile boolean sCanObtainUid;
    private static volatile boolean FLAG_WORK;
    private static final List<LogcatInfo> LOG_BACKUP;
    private static final Set<String> LOG_HASH;

    LogcatManager() {
    }

    public static void setCanObtainUid(boolean canObtainUid) {
        sCanObtainUid = canObtainUid;
    }

    public static void setCallback(Callback callback) {
        sCallback = callback;
    }

    static void start() {
        FLAG_WORK = true;
        new Thread(new LogRunnable()).start();
    }

    static void resume() {
        FLAG_WORK = true;
        Callback callback = sCallback;
        if (callback != null && !LOG_BACKUP.isEmpty()) {
            for (LogcatInfo info : LOG_BACKUP) {
                if (info == null) continue;
                callback.onReceiveLog(info);
            }
        }
        LOG_BACKUP.clear();
    }

    static void pause() {
        FLAG_WORK = false;
    }

    static void destroy() {
        FLAG_WORK = false;
        sCallback = null;
    }

    static void clear() {
        try {
            new ProcessBuilder("logcat", "-c").start();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static BufferedReader createLogcatBufferedReader() throws IOException {
        String command = "logcat -v " + (sCanObtainUid ? "uid" : "threadtime");
        Process process = Runtime.getRuntime().exec(command);
        return new BufferedReader(new InputStreamReader(process.getInputStream()));
    }

    private static void closeStream(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        try {
            closeable.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        LOG_BACKUP = new ArrayList<LogcatInfo>();
        LOG_HASH = new HashSet<String>();
    }

    public static interface Callback {
        public void onReceiveLog(LogcatInfo var1);
    }

    private static class LogRunnable
    implements Runnable {
        private LogRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            BufferedReader reader = null;
            while (true) {
                String line;
                Class<LogcatManager> clazz = LogcatManager.class;
                // MONITORENTER : com.hjq.logcat.LogcatManager.class
                if (reader == null) {
                    try {
                        reader = LogcatManager.createLogcatBufferedReader();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        // MONITOREXIT : clazz
                        return;
                    }
                }
                try {
                    line = reader.readLine();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    LogcatManager.closeStream(reader);
                    // MONITOREXIT : clazz
                    return;
                }
                if (line == null) {
                    LogcatManager.closeStream(reader);
                    reader = null;
                    SystemClock.sleep((long)5000L);
                    // MONITOREXIT : clazz
                    continue;
                }
                if (LogcatInfo.IGNORED_LOG.contains(line)) {
                    // MONITOREXIT : clazz
                    continue;
                }
                String md5 = LogcatUtils.computeMD5Hash(line);
                if (LOG_HASH.contains(md5)) {
                    // MONITOREXIT : clazz
                    continue;
                }
                LOG_HASH.add(md5);
                LogcatInfo info = LogcatInfo.create(line, sCanObtainUid);
                if (info == null) {
                    // MONITOREXIT : clazz
                    continue;
                }
                if (!FLAG_WORK) {
                    LOG_BACKUP.add(info);
                    // MONITOREXIT : clazz
                    continue;
                }
                Callback callback = sCallback;
                if (callback == null) {
                    // MONITOREXIT : clazz
                    return;
                }
                callback.onReceiveLog(info);
                // MONITOREXIT : clazz
            }
        }
    }
}

