/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.logcat;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ValueAnimator;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.design.widget.CoordinatorLayout;
import android.support.design.widget.Snackbar;
import android.support.v4.view.ViewCompat;
import android.util.AttributeSet;
import android.view.View;
import java.util.List;

public final class FloatingActionBehavior
extends CoordinatorLayout.Behavior<View> {
    private float mTranslationY;
    private boolean mAnimFlag;

    public FloatingActionBehavior(Context context, AttributeSet attrs) {
    }

    public boolean layoutDependsOn(CoordinatorLayout parent, View child, View dependency) {
        return dependency instanceof Snackbar.SnackbarLayout;
    }

    public boolean onDependentViewChanged(CoordinatorLayout parent, View child, View dependency) {
        this.updateTranslation(parent, child, dependency);
        return false;
    }

    public void onDependentViewRemoved(CoordinatorLayout parent, View child, View dependency) {
        ViewCompat.animate((View)child).cancel();
        ViewCompat.animate((View)child).translationY(0.0f);
        child.setTranslationY(0.0f);
        this.mTranslationY = 0.0f;
    }

    private void updateTranslation(CoordinatorLayout parent, View child, View dependency) {
        float translationY = this.getTranslationY(parent, child);
        if (translationY != this.mTranslationY) {
            ViewCompat.animate((View)child).cancel();
            if (Math.abs(translationY - this.mTranslationY) == (float)dependency.getHeight()) {
                ViewCompat.animate((View)child).translationY(translationY);
            } else {
                child.setTranslationY(translationY);
            }
            this.mTranslationY = translationY;
        }
    }

    private float getTranslationY(CoordinatorLayout parent, View child) {
        float minOffset = 0.0f;
        List dependencies = parent.getDependencies(child);
        int z = dependencies.size();
        for (int i = 0; i < z; ++i) {
            View view = (View)dependencies.get(i);
            if (!(view instanceof Snackbar.SnackbarLayout) || !parent.doViewsOverlap(child, view)) continue;
            minOffset = Math.min(minOffset, view.getTranslationY() - (float)view.getHeight());
        }
        return minOffset;
    }

    public boolean onStartNestedScroll(@NonNull CoordinatorLayout coordinatorLayout, @NonNull View child, @NonNull View directTargetChild, @NonNull View target, int axes, int type) {
        return axes == 2 || super.onStartNestedScroll(coordinatorLayout, child, directTargetChild, target, axes, type);
    }

    public void onNestedScroll(@NonNull CoordinatorLayout coordinatorLayout, final @NonNull View child, @NonNull View target, int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed, int type) {
        super.onNestedScroll(coordinatorLayout, child, target, dxConsumed, dyConsumed, dxUnconsumed, dyUnconsumed, type);
        if (this.mAnimFlag) {
            return;
        }
        if (dyConsumed > 0) {
            if (child.getVisibility() == 4) {
                return;
            }
            this.mAnimFlag = true;
            ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{1.0f, 0.0f});
            animator.setDuration(300L);
            animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    float scale = ((Float)animation.getAnimatedValue()).floatValue();
                    child.setScaleX(scale);
                    child.setScaleY(scale);
                    if (scale != 0.0f) {
                        return;
                    }
                    child.setVisibility(4);
                }
            });
            animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationStart(Animator animation) {
                    FloatingActionBehavior.this.mAnimFlag = true;
                }

                public void onAnimationEnd(Animator animation) {
                    FloatingActionBehavior.this.mAnimFlag = false;
                }
            });
            animator.start();
        } else if (dyConsumed < 0) {
            if (child.getVisibility() == 0) {
                return;
            }
            child.setVisibility(0);
            ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
            animator.setDuration(300L);
            animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    float scale = ((Float)animation.getAnimatedValue()).floatValue();
                    child.setScaleX(scale);
                    child.setScaleY(scale);
                }
            });
            animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationStart(Animator animation) {
                    FloatingActionBehavior.this.mAnimFlag = true;
                }

                public void onAnimationEnd(Animator animation) {
                    FloatingActionBehavior.this.mAnimFlag = false;
                }
            });
            animator.start();
        }
    }
}

