/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.gson.factory.element;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.internal.;
import com.google.gson.internal.ObjectConstructor;
import com.google.gson.reflect.TypeToken;
import com.hjq.gson.factory.constructor.MainConstructor;
import com.hjq.gson.factory.element.CollectionTypeAdapter;
import com.hjq.gson.factory.other.ReflectiveTypeUtils;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Type;
import java.util.Collection;

public class CollectionTypeAdapterFactory
implements TypeAdapterFactory {
    private final MainConstructor mMainConstructor;

    public CollectionTypeAdapterFactory(MainConstructor mainConstructor) {
        this.mMainConstructor = mainConstructor;
    }

    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
        Type type = typeToken.getType();
        Class rawType = typeToken.getRawType();
        if (ReflectiveTypeUtils.containsClass(rawType)) {
            return null;
        }
        if (typeToken.getType() instanceof GenericArrayType || typeToken.getType() instanceof Class && ((Class)typeToken.getType()).isArray()) {
            return null;
        }
        if (!Collection.class.isAssignableFrom(rawType)) {
            return null;
        }
        Type elementType = .Gson.Types.getCollectionElementType((Type)type, (Class)rawType);
        TypeAdapter elementTypeAdapter = gson.getAdapter(TypeToken.get((Type)elementType));
        ObjectConstructor<T> constructor = this.mMainConstructor.get(gson, typeToken);
        CollectionTypeAdapter collectionTypeAdapter = new CollectionTypeAdapter(gson, elementType, elementTypeAdapter, constructor);
        collectionTypeAdapter.setReflectiveType(typeToken, null);
        return collectionTypeAdapter;
    }
}

