/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.gson.factory.constructor;

import com.google.gson.internal.ObjectConstructor;
import com.google.gson.internal.Primitives;
import java.lang.reflect.Constructor;

public final class KotlinDataClassDefaultValueConstructor<T>
implements ObjectConstructor<T> {
    private static final String DEFAULT_CONSTRUCTOR_MARKER_CLASS_NAME = "kotlin.jvm.internal.DefaultConstructorMarker";
    private final Class<? super T> mRawType;

    public KotlinDataClassDefaultValueConstructor(Class<? super T> rawType) {
        this.mRawType = rawType;
    }

    public T construct() {
        T instance = null;
        try {
            Constructor<?>[] constructors;
            for (Constructor<?> constructor : constructors = this.mRawType.getConstructors()) {
                Class<?>[] parameterTypes = constructor.getParameterTypes();
                int parameterLength = parameterTypes.length;
                if (parameterLength < 3 || !DEFAULT_CONSTRUCTOR_MARKER_CLASS_NAME.equals(parameterTypes[parameterTypes.length - 1].getName()) && !Integer.TYPE.isAssignableFrom(parameterTypes[parameterTypes.length - 2])) continue;
                Object[] parameterValue = new Object[parameterLength];
                parameterValue[parameterLength - 2] = Integer.MAX_VALUE;
                parameterValue[parameterLength - 1] = null;
                for (int i = 0; i < parameterTypes.length - 2; ++i) {
                    Class<?> parameterType = parameterTypes[i];
                    parameterValue[i] = this.getTypeDefaultValue(parameterType);
                }
                instance = (T)constructor.newInstance(parameterValue);
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return instance;
    }

    private Object getTypeDefaultValue(Class<?> clazz) {
        if (Primitives.isWrapperType(clazz)) {
            return null;
        }
        if (clazz.isPrimitive()) {
            if (clazz == Byte.TYPE) {
                return (byte)0;
            }
            if (clazz == Short.TYPE) {
                return (short)0;
            }
            if (clazz == Integer.TYPE) {
                return 0;
            }
            if (clazz == Long.TYPE) {
                return 0L;
            }
            if (clazz == Float.TYPE) {
                return Float.valueOf(0.0f);
            }
            if (clazz == Double.TYPE) {
                return 0.0;
            }
            if (clazz == Character.TYPE) {
                return Character.valueOf('\u0000');
            }
            if (clazz == Boolean.TYPE) {
                return false;
            }
        }
        return null;
    }
}

