/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.http.request;

import androidx.annotation.Nullable;
import androidx.lifecycle.LifecycleOwner;
import com.hjq.http.EasyConfig;
import com.hjq.http.EasyLog;
import com.hjq.http.EasyUtils;
import com.hjq.http.body.CustomTypeRequestBody;
import com.hjq.http.body.JsonRequestBody;
import com.hjq.http.body.ProgressMonitorRequestBody;
import com.hjq.http.body.TextRequestBody;
import com.hjq.http.config.IRequestBodyStrategy;
import com.hjq.http.listener.OnHttpListener;
import com.hjq.http.listener.OnUpdateListener;
import com.hjq.http.model.HttpHeaders;
import com.hjq.http.model.HttpParams;
import com.hjq.http.request.HttpRequest;
import java.util.List;
import java.util.Map;
import okhttp3.FormBody;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.Request;
import okhttp3.RequestBody;

public abstract class BodyRequest<T extends BodyRequest<?>>
extends HttpRequest<T> {
    private OnUpdateListener<?> mUpdateListener;
    private RequestBody mRequestBody;

    public BodyRequest(LifecycleOwner lifecycleOwner) {
        super(lifecycleOwner);
    }

    public T json(Map<?, ?> map) {
        if (map == null) {
            return (T)this;
        }
        return this.body(new JsonRequestBody(map));
    }

    public T json(List<?> list) {
        if (list == null) {
            return (T)this;
        }
        return this.body(new JsonRequestBody(list));
    }

    public T json(String json) {
        if (json == null) {
            return (T)this;
        }
        return this.body(new JsonRequestBody(json));
    }

    public T text(String text) {
        if (text == null) {
            return (T)this;
        }
        return this.body(new TextRequestBody(text));
    }

    public T body(RequestBody body) {
        this.mRequestBody = body;
        return (T)this;
    }

    @Override
    public void request(@Nullable OnHttpListener<?> listener) {
        if (listener instanceof OnUpdateListener) {
            this.mUpdateListener = (OnUpdateListener)listener;
        }
        if (this.mRequestBody != null) {
            this.mRequestBody = new ProgressMonitorRequestBody(this, this.mRequestBody, this.getLifecycleOwner(), this.mUpdateListener);
        }
        super.request(listener);
    }

    @Override
    protected void addHttpParams(HttpParams params, String key, Object value, IRequestBodyStrategy requestBodyStrategy) {
        requestBodyStrategy.addParams(params, key, value);
    }

    @Override
    protected void addRequestParams(Request.Builder requestBuilder, HttpParams params, @Nullable String contentType, IRequestBodyStrategy requestBodyStrategy) {
        RequestBody body = this.mRequestBody != null ? this.mRequestBody : this.createRequestBody(params, contentType, requestBodyStrategy);
        requestBuilder.method(this.getRequestMethod(), body);
    }

    @Override
    protected void printRequestLog(Request request, HttpParams params, HttpHeaders headers, IRequestBodyStrategy requestBodyStrategy) {
        if (!EasyConfig.getInstance().isLogEnabled()) {
            return;
        }
        EasyLog.printKeyValue(this, "RequestUrl", String.valueOf(request.url()));
        EasyLog.printKeyValue(this, "RequestMethod", this.getRequestMethod());
        RequestBody body = request.body();
        if (!headers.isEmpty() || !params.isEmpty()) {
            EasyLog.printLine(this);
        }
        for (String key : headers.getKeys()) {
            EasyLog.printKeyValue(this, key, headers.get(key));
        }
        if (!headers.isEmpty() && !params.isEmpty()) {
            EasyLog.printLine(this);
        }
        if ((body = EasyUtils.findRealRequestBody(body)) instanceof FormBody || body instanceof MultipartBody) {
            for (String key : params.getKeys()) {
                Object value = params.get(key);
                if (value instanceof Map) {
                    Map map = (Map)value;
                    for (Object itemKey : map.keySet()) {
                        if (itemKey == null) continue;
                        this.printKeyValue(String.valueOf(itemKey), map.get(itemKey));
                    }
                    continue;
                }
                if (value instanceof List) {
                    List list = (List)value;
                    for (int i = 0; i < list.size(); ++i) {
                        Object itemValue = list.get(i);
                        this.printKeyValue(key + "[" + i + "]", itemValue);
                    }
                    continue;
                }
                this.printKeyValue(key, value);
            }
        } else if (body instanceof JsonRequestBody) {
            EasyLog.printJson(this, String.valueOf(body));
        } else if (body instanceof TextRequestBody) {
            EasyLog.printLog(this, String.valueOf(body));
        } else if (body != null) {
            EasyLog.printLog(this, String.valueOf(body));
        }
        if (!headers.isEmpty() || !params.isEmpty()) {
            EasyLog.printLine(this);
        }
    }

    private RequestBody createRequestBody(HttpParams params, @Nullable String contentType, IRequestBodyStrategy requestBodyStrategy) {
        MediaType mediaType;
        RequestBody requestBody = requestBodyStrategy.createRequestBody(this, params);
        if (contentType != null && !contentType.isEmpty() && (mediaType = MediaType.parse((String)contentType)) != null) {
            CustomTypeRequestBody customTypeRequestBody = new CustomTypeRequestBody(requestBody);
            customTypeRequestBody.setContentType(mediaType);
            requestBody = customTypeRequestBody;
        }
        if (this.mUpdateListener != null) {
            requestBody = new ProgressMonitorRequestBody(this, requestBody, this.getLifecycleOwner(), this.mUpdateListener);
        }
        return requestBody;
    }
}

