/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.http.listener;

import androidx.annotation.NonNull;
import com.hjq.http.config.IRequestApi;
import com.hjq.http.listener.OnHttpListener;

public class HttpCallbackProxy<T>
implements OnHttpListener<T> {
    private final OnHttpListener mSourceListener;

    public HttpCallbackProxy(OnHttpListener listener) {
        this.mSourceListener = listener;
    }

    @Override
    public void onHttpStart(@NonNull IRequestApi api) {
        if (this.mSourceListener == null) {
            return;
        }
        this.mSourceListener.onHttpStart(api);
    }

    @Override
    public void onHttpSuccess(@NonNull T result, boolean cache) {
        this.onHttpSuccess(result);
    }

    @Override
    public void onHttpSuccess(@NonNull T result) {
        if (this.mSourceListener == null) {
            return;
        }
        this.mSourceListener.onHttpSuccess(result);
    }

    @Override
    public void onHttpFail(@NonNull Throwable throwable) {
        if (this.mSourceListener == null) {
            return;
        }
        this.mSourceListener.onHttpFail(throwable);
    }

    @Override
    public void onHttpEnd(@NonNull IRequestApi api) {
        if (this.mSourceListener == null) {
            return;
        }
        this.mSourceListener.onHttpEnd(api);
    }
}

