/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.http.config.impl;

import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.hjq.http.EasyUtils;
import com.hjq.http.config.IRequestLogStrategy;

public final class EasyHttpLogStrategy
implements IRequestLogStrategy {
    @Override
    public void printLog(@NonNull String tag, @Nullable String message) {
        Log.i((String)tag, (String)(message != null ? message : "null"));
    }

    @Override
    public void printJson(@NonNull String tag, @Nullable String json) {
        String text = EasyUtils.formatJson(json);
        if (TextUtils.isEmpty((CharSequence)text)) {
            return;
        }
        text = " \n" + text;
        int segmentSize = 3600;
        long length = text.length();
        if (length <= (long)segmentSize) {
            this.printLog(tag, text);
            return;
        }
        while (text.length() > segmentSize) {
            String logContent = text.substring(0, segmentSize);
            text = text.replace(logContent, "");
            this.printLog(tag, logContent);
        }
        this.printLog(tag, text);
    }

    @Override
    public void printKeyValue(@NonNull String tag, @Nullable String key, @Nullable String value) {
        this.printLog(tag, key + " = " + value);
    }

    @Override
    public void printThrowable(@NonNull String tag, @Nullable Throwable throwable) {
        if (throwable == null) {
            Log.e((String)tag, (String)"An empty throwable object appears");
            return;
        }
        Log.e((String)tag, (String)throwable.getMessage(), (Throwable)throwable);
    }

    @Override
    public void printStackTrace(@NonNull String tag, @Nullable StackTraceElement[] stackTrace) {
        if (stackTrace == null) {
            return;
        }
        for (StackTraceElement element : stackTrace) {
            int lineNumber = element.getLineNumber();
            String className = element.getClassName();
            if (lineNumber <= 0 || className.startsWith("com.hjq.http")) continue;
            this.printLog(tag, "RequestCode = (" + element.getFileName() + ":" + lineNumber + ") ");
            break;
        }
    }
}

