/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.http.callback;

import androidx.annotation.NonNull;
import com.hjq.http.EasyConfig;
import com.hjq.http.EasyLog;
import com.hjq.http.EasyUtils;
import com.hjq.http.lifecycle.HttpLifecycleManager;
import com.hjq.http.model.CallProxy;
import com.hjq.http.model.ThreadSchedulers;
import com.hjq.http.request.HttpRequest;
import java.io.Closeable;
import java.io.IOException;
import java.net.SocketTimeoutException;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Response;

public abstract class BaseCallback
implements Callback {
    private final HttpRequest<?> mHttpRequest;
    private CallProxy.Factory mCallProxyFactory;
    private CallProxy mCallProxy;
    private int mRetryCount;

    public BaseCallback(@NonNull HttpRequest<?> request) {
        this.mHttpRequest = request;
        EasyUtils.runOnAssignThread(ThreadSchedulers.MAIN, () -> HttpLifecycleManager.register(this.mHttpRequest.getLifecycleOwner()));
    }

    public BaseCallback setCallProxyFactory(CallProxy.Factory factory) {
        this.mCallProxyFactory = factory;
        return this;
    }

    public void start() {
        this.onStart();
        this.mCallProxy = this.mCallProxyFactory.create();
        try {
            this.mCallProxy.enqueue(this);
        }
        catch (Throwable throwable) {
            this.onHttpFailure(throwable);
        }
    }

    protected CallProxy getCallProxy() {
        return this.mCallProxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onResponse(@NonNull Call call, @NonNull Response response) {
        try {
            this.onHttpResponse(response);
        }
        catch (Throwable throwable) {
            this.onHttpFailure(throwable);
        }
        finally {
            this.closeResponse(response);
        }
    }

    public void onFailure(@NonNull Call call, @NonNull IOException e) {
        if (e instanceof SocketTimeoutException && this.mRetryCount < EasyConfig.getInstance().getRetryCount()) {
            EasyUtils.postDelayedRunnable(() -> {
                if (!HttpLifecycleManager.isLifecycleActive(this.mHttpRequest.getLifecycleOwner())) {
                    EasyLog.printLog(this.mHttpRequest, "LifecycleOwner has been destroyed and the request cannot be made");
                    return;
                }
                ++this.mRetryCount;
                Call newCall = call.clone();
                this.mCallProxy.setRealCall(newCall);
                newCall.enqueue((Callback)this);
                EasyLog.printLog(this.mHttpRequest, "The request timed out, a delayed retry is being performed, the number of retries: " + this.mRetryCount + " / " + EasyConfig.getInstance().getRetryCount());
            }, EasyConfig.getInstance().getRetryTime());
            return;
        }
        this.onHttpFailure(e);
    }

    protected abstract void onStart();

    protected abstract void onHttpResponse(Response var1) throws Throwable;

    protected abstract void onHttpFailure(Throwable var1);

    protected void closeResponse(Response response) {
        EasyUtils.closeStream((Closeable)response);
    }
}

