/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.http.body;

import androidx.annotation.NonNull;
import androidx.lifecycle.LifecycleOwner;
import com.hjq.http.EasyLog;
import com.hjq.http.EasyUtils;
import com.hjq.http.body.WrapperRequestBody;
import com.hjq.http.lifecycle.HttpLifecycleManager;
import com.hjq.http.listener.OnUpdateListener;
import com.hjq.http.request.HttpRequest;
import java.io.IOException;
import okhttp3.RequestBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.ForwardingSink;
import okio.Okio;
import okio.Sink;

public class ProgressMonitorRequestBody
extends WrapperRequestBody {
    private final HttpRequest<?> mHttpRequest;
    private final OnUpdateListener<?> mListener;
    private final LifecycleOwner mLifecycleOwner;
    private long mTotalByte;
    private long mUpdateByte;
    private int mUpdateProgress;

    public ProgressMonitorRequestBody(HttpRequest<?> httpRequest, RequestBody body, LifecycleOwner lifecycleOwner, OnUpdateListener<?> listener) {
        super(body);
        this.mHttpRequest = httpRequest;
        this.mLifecycleOwner = lifecycleOwner;
        this.mListener = listener;
    }

    @Override
    public void writeTo(@NonNull BufferedSink sink) throws IOException {
        this.mTotalByte = this.contentLength();
        sink = Okio.buffer((Sink)new WrapperSink((Sink)sink));
        this.getRequestBody().writeTo(sink);
        sink.flush();
    }

    private void dispatchUpdateByteChangeCallback() {
        int currentProgress;
        if (this.mListener != null && HttpLifecycleManager.isLifecycleActive(this.mLifecycleOwner)) {
            this.mListener.onUpdateByteChange(this.mTotalByte, this.mUpdateByte);
        }
        if ((currentProgress = EasyUtils.getProgressProgress(this.mTotalByte, this.mUpdateByte)) == this.mUpdateProgress) {
            return;
        }
        this.mUpdateProgress = currentProgress;
        if (this.mListener != null && HttpLifecycleManager.isLifecycleActive(this.mLifecycleOwner)) {
            this.mListener.onUpdateProgressChange(currentProgress);
        }
        EasyLog.printLog(this.mHttpRequest, "Update progress change, uploaded: " + this.mUpdateByte + " / " + this.mTotalByte + ", progress: " + currentProgress + "%");
    }

    private class WrapperSink
    extends ForwardingSink {
        public WrapperSink(Sink delegate) {
            super(delegate);
        }

        public void write(Buffer source, long byteCount) throws IOException {
            super.write(source, byteCount);
            ProgressMonitorRequestBody.this.mUpdateByte = ProgressMonitorRequestBody.this.mUpdateByte + byteCount;
            EasyUtils.runOnAssignThread(ProgressMonitorRequestBody.this.mHttpRequest.getThreadSchedulers(), () -> ProgressMonitorRequestBody.this.dispatchUpdateByteChangeCallback());
        }
    }
}

