/*
 * Decompiled with CFR 0.152.
 */
package com.hjq.device.compat;

import android.annotation.SuppressLint;
import android.os.Environment;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Properties;

public final class SystemPropertyCompat {
    private SystemPropertyCompat() {
    }

    @NonNull
    public static String getSystemPropertyValue(@Nullable String key) {
        if (key == null || key.isEmpty()) {
            return "";
        }
        String propertyValue = null;
        try {
            propertyValue = SystemPropertyCompat.getSystemPropertyByReflect(key);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (propertyValue != null && !propertyValue.isEmpty()) {
            return propertyValue;
        }
        try {
            propertyValue = SystemPropertyCompat.getSystemPropertyByShell(key);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (propertyValue != null && !propertyValue.isEmpty()) {
            return propertyValue;
        }
        try {
            propertyValue = SystemPropertyCompat.getSystemPropertyByStream(key);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (propertyValue != null && !propertyValue.isEmpty()) {
            return propertyValue;
        }
        return "";
    }

    @NonNull
    public static String[] getSystemPropertyValues(@Nullable String[] keys) {
        if (keys == null) {
            return new String[0];
        }
        String[] propertyValues = new String[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            propertyValues[i] = SystemPropertyCompat.getSystemPropertyValue(keys[i]);
        }
        return propertyValues;
    }

    @NonNull
    public static String getSystemPropertyAnyOneValue(@Nullable String[] keys) {
        if (keys == null) {
            return "";
        }
        for (String key : keys) {
            String propertyValue = SystemPropertyCompat.getSystemPropertyValue(key);
            if (propertyValue.isEmpty()) continue;
            return propertyValue;
        }
        return "";
    }

    public static boolean isSystemPropertyExist(@Nullable String key) {
        return !TextUtils.isEmpty((CharSequence)SystemPropertyCompat.getSystemPropertyValue(key));
    }

    public static boolean isSystemPropertyAnyOneExist(@Nullable String[] keys) {
        if (keys == null) {
            return false;
        }
        for (String key : keys) {
            if (!SystemPropertyCompat.isSystemPropertyExist(key)) continue;
            return true;
        }
        return false;
    }

    @SuppressLint(value={"PrivateApi"})
    private static String getSystemPropertyByReflect(@NonNull String key) throws ClassNotFoundException, InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        Class<?> clz = Class.forName("android.os.SystemProperties");
        Method getMethod = clz.getMethod("get", String.class, String.class);
        return (String)getMethod.invoke(clz, key, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getSystemPropertyByShell(@NonNull String key) throws IOException {
        BufferedReader input = null;
        try {
            Process p = Runtime.getRuntime().exec("getprop " + key);
            input = new BufferedReader(new InputStreamReader(p.getInputStream()), 1024);
            String firstLine = input.readLine();
            if (firstLine != null) {
                String string = firstLine;
                return string;
            }
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getSystemPropertyByStream(@NonNull String key) throws IOException {
        FileInputStream inputStream = null;
        try {
            Properties prop = new Properties();
            File file = new File(Environment.getRootDirectory(), "build.prop");
            inputStream = new FileInputStream(file);
            prop.load(inputStream);
            String string = prop.getProperty(key, "");
            return string;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

