/*
 * Decompiled with CFR 0.152.
 */
package org.yi.acru.bukkit.Lockette;

import java.util.List;
import java.util.Set;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Sign;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.yi.acru.bukkit.BlockUtil;
import org.yi.acru.bukkit.Lockette.Lockette;

public class LockettePlayerListener
implements Listener {
    private static Lockette plugin;

    public LockettePlayerListener(Lockette instance) {
        plugin = instance;
    }

    protected void registerEvents() {
        PluginManager pm = plugin.getServer().getPluginManager();
        pm.registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onPlayerCommandPreprocess(PlayerCommandPreprocessEvent event) {
        String[] command = event.getMessage().split(" ", 3);
        if (command.length < 1) {
            return;
        }
        if (!command[0].equalsIgnoreCase("/lockette") && !command[0].equalsIgnoreCase("/lock")) {
            return;
        }
        event.setCancelled(true);
        Player player = event.getPlayer();
        if (command.length == 2) {
            if (command[1].equalsIgnoreCase("reload")) {
                if (!plugin.hasPermission(player.getWorld(), player, "lockette.admin.reload")) {
                    return;
                }
                plugin.loadProperties(true);
                plugin.localizedMessage(player, Lockette.broadcastReloadTarget, "msg-admin-reload");
                return;
            }
            if (command[1].equalsIgnoreCase("version")) {
                player.sendMessage(ChatColor.RED + "Lockette version " + plugin.getDescription().getVersion() + " loaded.  (Core: " + Lockette.getCoreVersion() + ")");
                return;
            }
            if (command[1].equalsIgnoreCase("fix")) {
                if (LockettePlayerListener.fixDoor(player)) {
                    plugin.localizedMessage(player, null, "msg-error-fix");
                }
                return;
            }
        } else if (command.length == 3 && command[1].equalsIgnoreCase("debug")) {
            Lockette.DEBUG = Boolean.parseBoolean(command[2]);
            player.sendMessage(ChatColor.RED + "[Lockette] DEBUG mode is set to " + Lockette.DEBUG);
            return;
        }
        if ((command.length == 2 || command.length == 3) && (command[1].equals("1") || command[1].equals("2") || command[1].equals("3") || command[1].equals("4"))) {
            boolean privateSign;
            Sign sign;
            Block block = LockettePlayerListener.plugin.playerList.get(player.getName());
            if (block == null) {
                plugin.localizedMessage(player, null, "msg-error-edit");
                return;
            }
            if (block.getTypeId() != Material.WALL_SIGN.getId()) {
                plugin.localizedMessage(player, null, "msg-error-edit");
                return;
            }
            Sign owner = sign = (Sign)block.getState();
            String text = sign.getLine(0).replaceAll("(?i)\u00a7[0-F]", "").toLowerCase();
            if (text.equals("[private]") || text.equalsIgnoreCase(Lockette.altPrivate)) {
                privateSign = true;
            } else if (text.equals("[more users]") || text.equalsIgnoreCase(Lockette.altMoreUsers)) {
                privateSign = false;
                Block checkBlock = Lockette.getSignAttachedBlock(block);
                if (checkBlock == null) {
                    plugin.localizedMessage(player, null, "msg-error-edit");
                    return;
                }
                Block signBlock = Lockette.findBlockOwner(checkBlock);
                if (signBlock == null) {
                    plugin.localizedMessage(player, null, "msg-error-edit");
                    return;
                }
                owner = (Sign)signBlock.getState();
            } else {
                plugin.localizedMessage(player, null, "msg-error-edit");
                return;
            }
            if (Lockette.isOwner(owner, (OfflinePlayer)player) || Lockette.debugMode) {
                int line = Integer.parseInt(command[1]) - 1;
                if (!Lockette.debugMode) {
                    if (line <= 0) {
                        return;
                    }
                    if (line <= 1 && privateSign && (command.length < 3 || command[2].isEmpty() || !command[2].replaceAll("&([0-9A-Fa-f])", "").equalsIgnoreCase(player.getName()))) {
                        return;
                    }
                }
                if (command.length == 3) {
                    String id;
                    String string = id = !Lockette.colorTags ? command[2].replaceAll("&([0-9A-Fa-f])", "") : command[2];
                    if (Lockette.DEBUG) {
                        Lockette.log.info("[Lockette] striped name = " + command[2].replaceAll("&([0-9A-Fa-f])", ""));
                        Lockette.log.info("[Lockette] player name = " + player.getName());
                    }
                    Lockette.setLine(sign, line, id);
                } else {
                    Lockette.setLine(sign, line, "");
                }
                sign.update();
                plugin.localizedMessage(player, null, "msg-owner-edit");
                return;
            }
            plugin.localizedMessage(player, null, "msg-error-edit");
            return;
        }
        plugin.localizedMessage(player, null, "msg-help-command1");
        plugin.localizedMessage(player, null, "msg-help-command2");
        plugin.localizedMessage(player, null, "msg-help-command3");
        plugin.localizedMessage(player, null, "msg-help-command4");
        plugin.localizedMessage(player, null, "msg-help-command5");
        plugin.localizedMessage(player, null, "msg-help-command6");
        plugin.localizedMessage(player, null, "msg-help-command7");
        plugin.localizedMessage(player, null, "msg-help-command8");
        plugin.localizedMessage(player, null, "msg-help-command9");
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (!event.hasBlock()) {
            return;
        }
        Action action = event.getAction();
        Player player = event.getPlayer();
        Block block = event.getClickedBlock();
        int type = block.getTypeId();
        BlockFace face = event.getBlockFace();
        if (action == Action.RIGHT_CLICK_BLOCK) {
            ItemStack item;
            if (Lockette.protectTrapDoors && BlockUtil.isInList(type, BlockUtil.materialListTrapDoors)) {
                if (LockettePlayerListener.interactDoor(block, player)) {
                    return;
                }
                event.setUseInteractedBlock(Event.Result.DENY);
                event.setUseItemInHand(Event.Result.DENY);
                return;
            }
            if (Lockette.protectDoors && BlockUtil.isInList(type, BlockUtil.materialListDoors)) {
                if (LockettePlayerListener.interactDoor(block, player)) {
                    return;
                }
                event.setUseInteractedBlock(Event.Result.DENY);
                event.setUseItemInHand(Event.Result.DENY);
                return;
            }
            if (type == Material.WALL_SIGN.getId()) {
                LockettePlayerListener.interactSign(block, player);
                return;
            }
            if (BlockUtil.isInList(type, BlockUtil.materialListChests)) {
                Lockette.rotateChestOrientation(block, face);
            }
            if (BlockUtil.isInList(type, BlockUtil.materialListNonDoors) || Lockette.isInList(type, Lockette.customBlockList)) {
                Block checkBlock;
                ItemStack item2;
                if (Lockette.directPlacement && event.hasItem() && face != BlockFace.UP && face != BlockFace.DOWN && (item2 = event.getItem()).getTypeId() == Material.SIGN.getId() && (type = (checkBlock = block.getRelative(face)).getTypeId()) == Material.AIR.getId()) {
                    boolean place = false;
                    if (Lockette.isProtected(block)) {
                        if (Lockette.isOwner(block, (OfflinePlayer)player)) {
                            place = true;
                        }
                    } else {
                        place = true;
                    }
                    if (place) {
                        event.setUseItemInHand(Event.Result.ALLOW);
                        event.setUseInteractedBlock(Event.Result.DENY);
                        return;
                    }
                }
                if (LockettePlayerListener.interactContainer(block, player)) {
                    return;
                }
                event.setUseInteractedBlock(Event.Result.DENY);
                event.setUseItemInHand(Event.Result.DENY);
                return;
            }
            if (type == Material.DIRT.getId() && event.hasItem() && ((type = (item = event.getItem()).getTypeId()) == Material.DIAMOND_HOE.getId() || type == Material.GOLD_HOE.getId() || type == Material.IRON_HOE.getId() || type == Material.STONE_HOE.getId() || type == Material.WOOD_HOE.getId())) {
                Block checkBlock = block.getRelative(BlockFace.UP);
                type = checkBlock.getTypeId();
                if (BlockUtil.isInList(type, BlockUtil.materialListDoors)) {
                    event.setUseInteractedBlock(Event.Result.DENY);
                    return;
                }
                if (LockettePlayerListener.hasAttachedTrapDoor(block)) {
                    event.setUseInteractedBlock(Event.Result.DENY);
                    return;
                }
            }
        } else if (action == Action.LEFT_CLICK_BLOCK) {
            if (Lockette.protectTrapDoors && BlockUtil.isInList(type, BlockUtil.materialListTrapDoors)) {
                if (LockettePlayerListener.interactDoor(block, player)) {
                    return;
                }
                event.setUseInteractedBlock(Event.Result.DENY);
                event.setUseItemInHand(Event.Result.DENY);
                return;
            }
            if (Lockette.protectDoors && BlockUtil.isInList(type, BlockUtil.materialListDoors)) {
                if (LockettePlayerListener.interactDoor(block, player)) {
                    return;
                }
                event.setUseInteractedBlock(Event.Result.DENY);
                event.setUseItemInHand(Event.Result.DENY);
                return;
            }
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        LockettePlayerListener.plugin.playerList.remove(player.getName());
    }

    private static boolean interactDoor(Block block, Player player) {
        Block signBlock = Lockette.findBlockOwner(block);
        if (signBlock == null) {
            return true;
        }
        boolean wooden = BlockUtil.isInList(block.getTypeId(), BlockUtil.materialListWoodenDoors);
        boolean trap = false;
        if (Lockette.protectTrapDoors && BlockUtil.isInList(block.getTypeId(), BlockUtil.materialListTrapDoors)) {
            trap = true;
        }
        boolean allow = false;
        if (LockettePlayerListener.canInteract(block, signBlock, player, true)) {
            allow = true;
        }
        if (allow) {
            List<Block> list = Lockette.toggleDoors(block, Lockette.getSignAttachedBlock(signBlock), wooden, trap);
            int delta = Lockette.getSignOption(signBlock, "timer", Lockette.altTimer, Lockette.defaultDoorTimer);
            LockettePlayerListener.plugin.doorCloser.add(list, delta != 0, delta);
            return true;
        }
        if (block.equals(LockettePlayerListener.plugin.playerList.get(player.getName()))) {
            return false;
        }
        LockettePlayerListener.plugin.playerList.put(player.getName(), block);
        plugin.localizedMessage(player, null, "msg-user-denied-door");
        return false;
    }

    private static void interactSign(Block block, Player player) {
        Sign sign = (Sign)block.getState();
        String text = sign.getLine(0).replaceAll("(?i)\u00a7[0-F]", "").toLowerCase();
        if (!text.equals("[private]") && !text.equalsIgnoreCase(Lockette.altPrivate)) {
            if (text.equals("[more users]") || text.equalsIgnoreCase(Lockette.altMoreUsers)) {
                Block checkBlock = Lockette.getSignAttachedBlock(block);
                if (checkBlock == null) {
                    return;
                }
                Block signBlock = Lockette.findBlockOwner(checkBlock);
                if (signBlock == null) {
                    return;
                }
                sign = (Sign)signBlock.getState();
            } else {
                return;
            }
        }
        if (Lockette.isOwner(sign, (OfflinePlayer)player) || Lockette.debugMode) {
            if (!block.equals(LockettePlayerListener.plugin.playerList.get(player.getName()))) {
                LockettePlayerListener.plugin.playerList.put(player.getName(), block);
                plugin.localizedMessage(player, null, "msg-help-select");
            }
        } else if (!block.equals(LockettePlayerListener.plugin.playerList.get(player.getName()))) {
            LockettePlayerListener.plugin.playerList.put(player.getName(), block);
            plugin.localizedMessage(player, null, "msg-user-touch-owned", sign.getLine(1));
        }
    }

    private static boolean interactContainer(Block block, Player player) {
        Block signBlock = Lockette.findBlockOwner(block);
        if (signBlock == null) {
            return true;
        }
        if (LockettePlayerListener.canInteract(block, signBlock, player, false)) {
            return true;
        }
        if (block.equals(LockettePlayerListener.plugin.playerList.get(player.getName()))) {
            return false;
        }
        LockettePlayerListener.plugin.playerList.put(player.getName(), block);
        plugin.localizedMessage(player, null, "msg-user-denied");
        return false;
    }

    private static boolean canInteract(Block block, Block signBlock, Player player, boolean isDoor) {
        Sign sign = (Sign)signBlock.getState();
        if (Lockette.isUser(block, (OfflinePlayer)player, true)) {
            return true;
        }
        boolean snoop = false;
        if (isDoor) {
            if (Lockette.adminBypass) {
                if (plugin.hasPermission(block.getWorld(), player, "lockette.admin.bypass")) {
                    snoop = true;
                }
                if (snoop) {
                    Lockette.log.info("[" + plugin.getDescription().getName() + "] (Admin) " + player.getName() + " has bypassed a door owned by " + sign.getLine(1));
                    plugin.localizedMessage(player, null, "msg-admin-bypass", sign.getLine(1));
                    return true;
                }
            }
        } else if (Lockette.adminSnoop) {
            if (plugin.hasPermission(block.getWorld(), player, "lockette.admin.snoop")) {
                snoop = true;
            }
            if (snoop) {
                Lockette.log.info("[" + plugin.getDescription().getName() + "] (Admin) " + player.getName() + " has snooped around in a container owned by " + sign.getLine(1) + "!");
                plugin.localizedMessage(player, Lockette.broadcastSnoopTarget, "msg-admin-snoop", sign.getLine(1));
                return true;
            }
        }
        return false;
    }

    private static boolean fixDoor(Player player) {
        Block block = player.getTargetBlock((Set)null, 10);
        int type = block.getTypeId();
        boolean doCheck = false;
        if (Lockette.protectTrapDoors && BlockUtil.isInList(type, BlockUtil.materialListTrapDoors)) {
            doCheck = true;
        }
        if (Lockette.protectDoors && BlockUtil.isInList(type, BlockUtil.materialListDoors)) {
            doCheck = true;
        }
        if (!doCheck) {
            return true;
        }
        Block signBlock = Lockette.findBlockOwner(block);
        if (signBlock == null) {
            return true;
        }
        Sign sign = (Sign)signBlock.getState();
        if (Lockette.isOwner(block, (OfflinePlayer)player)) {
            Lockette.toggleSingleDoor(block);
            return false;
        }
        return true;
    }

    public static boolean hasAttachedTrapDoor(Block block) {
        int face;
        Block checkBlock = block.getRelative(BlockFace.NORTH);
        int type = checkBlock.getTypeId();
        if (BlockUtil.isInList(type, BlockUtil.materialListTrapDoors) && (face = checkBlock.getData() & 3) == 2) {
            return true;
        }
        checkBlock = block.getRelative(BlockFace.EAST);
        type = checkBlock.getTypeId();
        if (BlockUtil.isInList(type, BlockUtil.materialListTrapDoors) && (face = checkBlock.getData() & 3) == 0) {
            return true;
        }
        checkBlock = block.getRelative(BlockFace.SOUTH);
        type = checkBlock.getTypeId();
        if (BlockUtil.isInList(type, BlockUtil.materialListTrapDoors) && (face = checkBlock.getData() & 3) == 3) {
            return true;
        }
        checkBlock = block.getRelative(BlockFace.WEST);
        type = checkBlock.getTypeId();
        return BlockUtil.isInList(type, BlockUtil.materialListTrapDoors) && (face = checkBlock.getData() & 3) == 1;
    }
}

