/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.storage;

import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.operations.RedisOperation;
import com.github.fppt.jedismock.server.RedisClient;
import com.github.fppt.jedismock.storage.RedisBase;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OperationExecutorState {
    private final RedisClient owner;
    private final Map<Integer, RedisBase> redisBases;
    private TransactionState transactionState = TransactionState.NORMAL;
    private final List<RedisOperation> tx = new ArrayList<RedisOperation>();
    private final Set<Slice> watchedKeys = new HashSet<Slice>();
    private boolean watchedKeysAffected = false;
    private int selectedRedisBase = 0;
    private String clientName;

    public OperationExecutorState(RedisClient owner, Map<Integer, RedisBase> redisBases) {
        this.owner = owner;
        this.redisBases = redisBases;
    }

    public RedisBase base() {
        return this.redisBases.computeIfAbsent(this.selectedRedisBase, key -> new RedisBase());
    }

    public RedisClient owner() {
        return this.owner;
    }

    public List<RedisOperation> tx() {
        return this.tx;
    }

    public void changeActiveRedisBase(int selectedRedisBase) {
        this.selectedRedisBase = selectedRedisBase;
    }

    public void transactionMode(boolean isTransactionModeOn) {
        this.transactionState = isTransactionModeOn ? TransactionState.MULTI : TransactionState.NORMAL;
    }

    public boolean isTransactionModeOn() {
        return this.transactionState != TransactionState.NORMAL;
    }

    public void errorTransaction() {
        if (this.isTransactionModeOn()) {
            this.transactionState = TransactionState.ERRORED;
        }
    }

    public TransactionState getTransactionState() {
        return this.transactionState;
    }

    public void clearAll() {
        for (RedisBase redisBase : this.redisBases.values()) {
            redisBase.clear();
        }
    }

    public Object lock() {
        return this.redisBases;
    }

    public void checkWatchedKeysNotExpired() {
        for (Slice key : this.watchedKeys) {
            this.base().exists(key);
        }
    }

    public boolean isValid() {
        return !this.watchedKeysAffected;
    }

    public void watchedKeyIsAffected() {
        this.watchedKeysAffected = true;
    }

    public void watch(List<Slice> keys) {
        RedisBase redisBase = this.base();
        for (Slice key : keys) {
            this.watchedKeys.add(key);
            redisBase.watch(this, key);
        }
    }

    public void unwatch() {
        RedisBase redisBase = this.base();
        for (Slice key : this.watchedKeys) {
            redisBase.unwatchSingleKey(this, key);
        }
        this.watchedKeysAffected = false;
    }

    public int getSelected() {
        return this.selectedRedisBase;
    }

    public int getPort() {
        return this.owner.getPort();
    }

    public String getHost() {
        return this.owner.getAddress();
    }

    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    public String getClientName() {
        return this.clientName;
    }

    public static enum TransactionState {
        NORMAL,
        MULTI,
        ERRORED;

    }
}

