/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.server;

import com.github.fppt.jedismock.server.RedisClient;
import com.github.fppt.jedismock.server.ServiceOptions;
import com.github.fppt.jedismock.storage.RedisBase;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public final class RedisService
implements Callable<Void> {
    private final ServerSocket server;
    private final Map<Integer, RedisBase> redisBases;
    private final ServiceOptions options;
    private final ExecutorService threadPool = Executors.newCachedThreadPool();
    private final List<RedisClient> clients = new CopyOnWriteArrayList<RedisClient>();

    public RedisService(int bindPort, InetAddress address, Map<Integer, RedisBase> redisBases, ServiceOptions options) throws IOException {
        Objects.requireNonNull(redisBases);
        Objects.requireNonNull(options);
        this.server = new ServerSocket(bindPort, 0, address);
        this.redisBases = redisBases;
        this.options = options;
    }

    @Override
    public Void call() throws IOException {
        while (!this.server.isClosed()) {
            Socket socket = this.server.accept();
            RedisClient rc = new RedisClient(this.redisBases, socket, this.options, this.clients::remove);
            this.clients.add(rc);
            this.threadPool.submit(rc);
        }
        return null;
    }

    public ServerSocket getServer() {
        return this.server;
    }

    public void stop() throws IOException {
        this.clients.forEach(RedisClient::close);
        this.server.close();
        this.threadPool.shutdownNow();
    }
}

