/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.operations.scripting;

import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.operations.AbstractRedisOperation;
import com.github.fppt.jedismock.operations.RedisCommand;
import com.github.fppt.jedismock.server.Response;
import com.github.fppt.jedismock.storage.RedisBase;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;

@RedisCommand(value="script")
public class Script
extends AbstractRedisOperation {
    private static final String SCRIPT_PARAM_ERROR = "Wrong number of arguments for SCRIPT";

    public Script(RedisBase base, List<Slice> params) {
        super(base, params);
    }

    @Override
    protected Slice response() {
        String operation = this.params().get(0).toString();
        if ("LOAD".equalsIgnoreCase(operation)) {
            return this.load();
        }
        if ("EXISTS".equalsIgnoreCase(operation)) {
            return this.exists();
        }
        if ("FLUSH".equalsIgnoreCase(operation)) {
            this.base().flushCachedLuaScrips();
            return Response.OK;
        }
        return Response.error(String.format("Unsupported operation: script %s", operation));
    }

    private Slice exists() {
        ArrayList<Slice> result = new ArrayList<Slice>();
        for (int i = 1; i < this.params().size(); ++i) {
            result.add(Response.integer(this.base().cachedLuaScriptExists(this.params().get(i).toString()) ? 1L : 0L));
        }
        return Response.array(result);
    }

    private Slice load() {
        if (this.params().size() < 2) {
            return Response.error(SCRIPT_PARAM_ERROR);
        }
        String script = this.params().get(1).toString();
        String scriptSHA = Script.getScriptSHA(script);
        this.base().addCachedLuaScript(scriptSHA, script);
        return Response.bulkString(Slice.create(scriptSHA));
    }

    public static String getScriptSHA(String script) {
        try {
            MessageDigest sha1 = MessageDigest.getInstance("SHA1");
            byte[] scriptSHA1 = sha1.digest(script.getBytes());
            return Script.byteArrayToHexString(scriptSHA1);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private static String byteArrayToHexString(byte[] b) {
        StringBuilder result = new StringBuilder();
        for (byte value : b) {
            result.append(Integer.toString((value & 0xFF) + 256, 16).substring(1));
        }
        return result.toString();
    }
}

