/*
 * Decompiled with CFR 0.152.
 */
package soup.neumorphism.internal.util;

import android.content.Context;
import android.content.res.TypedArray;
import androidx.annotation.ColorRes;
import androidx.annotation.StyleableRes;
import androidx.core.content.ContextCompat;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010\t\u001a\u00020\u00042\b\b\u0001\u0010\n\u001a\u00020\u0004\u00a8\u0006\u000b"}, d2={"Lsoup/neumorphism/internal/util/NeumorphResources;", "", "()V", "getColor", "", "context", "Landroid/content/Context;", "attributes", "Landroid/content/res/TypedArray;", "index", "defaultColor", "neumorphism_release"})
public final class NeumorphResources {
    @NotNull
    public static final NeumorphResources INSTANCE = new NeumorphResources();

    private NeumorphResources() {
    }

    public final int getColor(@NotNull Context context, @NotNull TypedArray attributes, @StyleableRes int index, @ColorRes int defaultColor) {
        int n;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        try {
            int resourceId;
            if (attributes.hasValue(index) && (resourceId = attributes.getResourceId(index, 0)) != 0) {
                return ContextCompat.getColor((Context)context, (int)resourceId);
            }
            n = attributes.getColor(index, ContextCompat.getColor((Context)context, (int)defaultColor));
        }
        catch (Exception e) {
            n = ContextCompat.getColor((Context)context, (int)defaultColor);
        }
        return n;
    }
}

