/*
 * Decompiled with CFR 0.152.
 */
package soup.neumorphism.internal.shape;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.drawable.GradientDrawable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import soup.neumorphism.LightSource;
import soup.neumorphism.NeumorphShapeAppearanceModel;
import soup.neumorphism.NeumorphShapeDrawable;
import soup.neumorphism.internal.blur.BlurProvider;
import soup.neumorphism.internal.shape.Shape;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\b\u0010\u0019\u001a\u00020\u0017H\u0002J\b\u0010\u001a\u001a\u00020\u0017H\u0002J\u0010\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u0003H\u0016J\u0010\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lsoup/neumorphism/internal/shape/PressedShape;", "Lsoup/neumorphism/internal/shape/Shape;", "drawableState", "Lsoup/neumorphism/NeumorphShapeDrawable$NeumorphShapeDrawableState;", "(Lsoup/neumorphism/NeumorphShapeDrawable$NeumorphShapeDrawableState;)V", "darkShadowDrawable", "Landroid/graphics/drawable/GradientDrawable;", "lightShadowDrawable", "shadowBitmap", "Landroid/graphics/Bitmap;", "draw", "", "canvas", "Landroid/graphics/Canvas;", "outlinePath", "Landroid/graphics/Path;", "generateShadowBitmap", "w", "", "h", "getCornerRadiiForDarkShadow", "", "cornerSize", "", "getCornerRadiiForLightShadow", "getCornerSizeForDarkShadow", "getCornerSizeForLightShadow", "setDrawableState", "newDrawableState", "updateShadowBitmap", "bounds", "Landroid/graphics/Rect;", "neumorphism_release"})
public final class PressedShape
implements Shape {
    @NotNull
    private NeumorphShapeDrawable.NeumorphShapeDrawableState drawableState;
    @Nullable
    private Bitmap shadowBitmap;
    @NotNull
    private final GradientDrawable lightShadowDrawable;
    @NotNull
    private final GradientDrawable darkShadowDrawable;

    public PressedShape(@NotNull NeumorphShapeDrawable.NeumorphShapeDrawableState drawableState) {
        Intrinsics.checkNotNullParameter((Object)((Object)drawableState), (String)"drawableState");
        this.drawableState = drawableState;
        this.lightShadowDrawable = new GradientDrawable();
        this.darkShadowDrawable = new GradientDrawable();
    }

    @Override
    public void setDrawableState(@NotNull NeumorphShapeDrawable.NeumorphShapeDrawableState newDrawableState) {
        Intrinsics.checkNotNullParameter((Object)((Object)newDrawableState), (String)"newDrawableState");
        this.drawableState = newDrawableState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void draw(@NotNull Canvas canvas, @NotNull Path outlinePath) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Intrinsics.checkNotNullParameter((Object)outlinePath, (String)"outlinePath");
        Canvas $this$withClip$iv = canvas;
        boolean $i$f$withClip = false;
        int checkpoint$iv = $this$withClip$iv.save();
        $this$withClip$iv.clipPath(outlinePath);
        try {
            Canvas $this$draw_u24lambda_u2d1 = $this$withClip$iv;
            boolean bl = false;
            Bitmap bitmap = this.shadowBitmap;
            if (bitmap == null) {
            } else {
                Bitmap bitmap2 = bitmap;
                boolean bl2 = false;
                boolean bl3 = false;
                Bitmap it = bitmap2;
                boolean bl4 = false;
                float left = 0.0f;
                float top = 0.0f;
                Rect inset = this.drawableState.getInset();
                left = inset.left;
                top = inset.top;
                $this$draw_u24lambda_u2d1.drawBitmap(it, left, top, null);
            }
        }
        finally {
            $this$withClip$iv.restoreToCount(checkpoint$iv);
        }
    }

    @Override
    public void updateShadowBitmap(@NotNull Rect bounds) {
        float cornerSize;
        boolean bl;
        float f;
        float f2;
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        int shadowElevation = (int)this.drawableState.getShadowElevation();
        int w = bounds.width();
        int h = bounds.height();
        int width = w + shadowElevation;
        int height = h + shadowElevation;
        GradientDrawable gradientDrawable = this.lightShadowDrawable;
        boolean bl2 = false;
        boolean bl3 = false;
        GradientDrawable $this$updateShadowBitmap_u24lambda_u2d2 = gradientDrawable;
        boolean bl4 = false;
        $this$updateShadowBitmap_u24lambda_u2d2.setSize(width, height);
        $this$updateShadowBitmap_u24lambda_u2d2.setStroke(shadowElevation, this.drawableState.getShadowColorLight());
        int n = this.drawableState.getShapeAppearanceModel().getCornerFamily();
        switch (n) {
            case 1: {
                $this$updateShadowBitmap_u24lambda_u2d2.setShape(1);
                break;
            }
            case 0: {
                f2 = (float)w / 2.0f;
                f = (float)h / 2.0f;
                bl = false;
                f2 = Math.min(f2, f);
                f = this.getCornerSizeForLightShadow();
                bl = false;
                cornerSize = Math.min(f2, f);
                $this$updateShadowBitmap_u24lambda_u2d2.setShape(0);
                $this$updateShadowBitmap_u24lambda_u2d2.setCornerRadii(this.getCornerRadiiForLightShadow(cornerSize));
            }
        }
        gradientDrawable = this.darkShadowDrawable;
        bl2 = false;
        bl3 = false;
        GradientDrawable $this$updateShadowBitmap_u24lambda_u2d3 = gradientDrawable;
        boolean bl5 = false;
        $this$updateShadowBitmap_u24lambda_u2d3.setSize(width, height);
        $this$updateShadowBitmap_u24lambda_u2d3.setStroke(shadowElevation, this.drawableState.getShadowColorDark());
        n = this.drawableState.getShapeAppearanceModel().getCornerFamily();
        switch (n) {
            case 1: {
                $this$updateShadowBitmap_u24lambda_u2d3.setShape(1);
                break;
            }
            case 0: {
                f2 = (float)w / 2.0f;
                f = (float)h / 2.0f;
                bl = false;
                f2 = Math.min(f2, f);
                f = this.getCornerSizeForDarkShadow();
                bl = false;
                cornerSize = Math.min(f2, f);
                $this$updateShadowBitmap_u24lambda_u2d3.setShape(0);
                $this$updateShadowBitmap_u24lambda_u2d3.setCornerRadii(this.getCornerRadiiForDarkShadow(cornerSize));
            }
        }
        this.lightShadowDrawable.setSize(width, height);
        this.lightShadowDrawable.setBounds(0, 0, width, height);
        this.darkShadowDrawable.setSize(width, height);
        this.darkShadowDrawable.setBounds(0, 0, width, height);
        this.shadowBitmap = this.generateShadowBitmap(w, h);
    }

    private final float getCornerSizeForLightShadow() {
        float f;
        NeumorphShapeAppearanceModel neumorphShapeAppearanceModel = this.drawableState.getShapeAppearanceModel();
        boolean bl = false;
        boolean bl2 = false;
        NeumorphShapeAppearanceModel $this$getCornerSizeForLightShadow_u24lambda_u2d4 = neumorphShapeAppearanceModel;
        boolean bl3 = false;
        int n = this.drawableState.getLightSource();
        switch (n) {
            case 0: {
                f = $this$getCornerSizeForLightShadow_u24lambda_u2d4.getBottomLeftCornerSize();
                break;
            }
            case 1: {
                f = $this$getCornerSizeForLightShadow_u24lambda_u2d4.getTopRightCornerSize();
                break;
            }
            case 2: {
                f = $this$getCornerSizeForLightShadow_u24lambda_u2d4.getBottomRightCornerSize();
                break;
            }
            case 3: {
                f = $this$getCornerSizeForLightShadow_u24lambda_u2d4.getTopLeftCornerSize();
                break;
            }
            default: {
                throw new IllegalStateException("LightSource " + this.drawableState.getLightSource() + " is not supported.");
            }
        }
        return f;
    }

    private final float[] getCornerRadiiForLightShadow(float cornerSize) {
        float[] fArray;
        int n = this.drawableState.getLightSource();
        switch (n) {
            case 0: {
                float[] fArray2 = new float[]{0.0f, 0.0f, 0.0f, 0.0f, cornerSize, cornerSize, 0.0f, 0.0f};
                fArray = fArray2;
                break;
            }
            case 1: {
                float[] fArray3 = new float[]{0.0f, 0.0f, cornerSize, cornerSize, 0.0f, 0.0f, 0.0f, 0.0f};
                fArray = fArray3;
                break;
            }
            case 2: {
                float[] fArray4 = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, cornerSize, cornerSize};
                fArray = fArray4;
                break;
            }
            case 3: {
                float[] fArray5 = new float[]{cornerSize, cornerSize, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
                fArray = fArray5;
                break;
            }
            default: {
                throw new IllegalStateException("LightSource " + this.drawableState.getLightSource() + " is not supported.");
            }
        }
        return fArray;
    }

    private final float getCornerSizeForDarkShadow() {
        float f;
        NeumorphShapeAppearanceModel neumorphShapeAppearanceModel = this.drawableState.getShapeAppearanceModel();
        boolean bl = false;
        boolean bl2 = false;
        NeumorphShapeAppearanceModel $this$getCornerSizeForDarkShadow_u24lambda_u2d5 = neumorphShapeAppearanceModel;
        boolean bl3 = false;
        int n = this.drawableState.getLightSource();
        switch (n) {
            case 0: {
                f = $this$getCornerSizeForDarkShadow_u24lambda_u2d5.getTopLeftCornerSize();
                break;
            }
            case 1: {
                f = $this$getCornerSizeForDarkShadow_u24lambda_u2d5.getBottomLeftCornerSize();
                break;
            }
            case 2: {
                f = $this$getCornerSizeForDarkShadow_u24lambda_u2d5.getTopRightCornerSize();
                break;
            }
            case 3: {
                f = $this$getCornerSizeForDarkShadow_u24lambda_u2d5.getBottomRightCornerSize();
                break;
            }
            default: {
                throw new IllegalStateException("LightSource " + this.drawableState.getLightSource() + " is not supported.");
            }
        }
        return f;
    }

    private final float[] getCornerRadiiForDarkShadow(float cornerSize) {
        float[] fArray;
        int n = this.drawableState.getLightSource();
        switch (n) {
            case 0: {
                float[] fArray2 = new float[]{cornerSize, cornerSize, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
                fArray = fArray2;
                break;
            }
            case 1: {
                float[] fArray3 = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, cornerSize, cornerSize};
                fArray = fArray3;
                break;
            }
            case 2: {
                float[] fArray4 = new float[]{0.0f, 0.0f, cornerSize, cornerSize, 0.0f, 0.0f, 0.0f, 0.0f};
                fArray = fArray4;
                break;
            }
            case 3: {
                float[] fArray5 = new float[]{0.0f, 0.0f, 0.0f, 0.0f, cornerSize, cornerSize, 0.0f, 0.0f};
                fArray = fArray5;
                break;
            }
            default: {
                throw new IllegalStateException("LightSource " + this.drawableState.getLightSource() + " is not supported.");
            }
        }
        return fArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final Bitmap generateShadowBitmap(int w, int h) {
        float y$iv;
        float x$iv;
        Canvas $this$withTranslation$iv;
        void $this$onCanvas$iv;
        float shadowElevation = this.drawableState.getShadowElevation();
        int lightSource = this.drawableState.getLightSource();
        Bitmap bitmap = Bitmap.createBitmap((int)w, (int)h, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"createBitmap(w, h, Bitmap.Config.ARGB_8888)");
        boolean $i$f$onCanvas = false;
        void var7_7 = $this$onCanvas$iv;
        boolean bl = false;
        boolean bl2 = false;
        void it$iv = var7_7;
        boolean bl3 = false;
        Canvas canvas = new Canvas((Bitmap)it$iv);
        boolean bl4 = false;
        boolean bl5 = false;
        Canvas $this$generateShadowBitmap_u24lambda_u2d8 = canvas;
        boolean bl6 = false;
        Canvas canvas2 = $this$generateShadowBitmap_u24lambda_u2d8;
        float f = LightSource.Companion.isLeft(lightSource) ? -shadowElevation : 0.0f;
        float f2 = LightSource.Companion.isTop(lightSource) ? -shadowElevation : 0.0f;
        boolean $i$f$withTranslation = false;
        int checkpoint$iv = $this$withTranslation$iv.save();
        $this$withTranslation$iv.translate(x$iv, y$iv);
        try {
            void $this$generateShadowBitmap_u24lambda_u2d8_u24lambda_u2d6 = $this$withTranslation$iv;
            boolean bl7 = false;
            this.lightShadowDrawable.draw((Canvas)$this$generateShadowBitmap_u24lambda_u2d8_u24lambda_u2d6);
        }
        finally {
            $this$withTranslation$iv.restoreToCount(checkpoint$iv);
        }
        $this$withTranslation$iv = $this$generateShadowBitmap_u24lambda_u2d8;
        x$iv = LightSource.Companion.isRight(lightSource) ? -shadowElevation : 0.0f;
        y$iv = LightSource.Companion.isBottom(lightSource) ? -shadowElevation : 0.0f;
        $i$f$withTranslation = false;
        checkpoint$iv = $this$withTranslation$iv.save();
        $this$withTranslation$iv.translate(x$iv, y$iv);
        try {
            Canvas $this$generateShadowBitmap_u24lambda_u2d8_u24lambda_u2d7 = $this$withTranslation$iv;
            boolean bl8 = false;
            this.darkShadowDrawable.draw($this$generateShadowBitmap_u24lambda_u2d8_u24lambda_u2d7);
        }
        finally {
            $this$withTranslation$iv.restoreToCount(checkpoint$iv);
        }
        return PressedShape.generateShadowBitmap$blurred((Bitmap)var7_7, this);
    }

    private static final Bitmap generateShadowBitmap$blurred(Bitmap $this$generateShadowBitmap_u24blurred, PressedShape this$0) {
        if (this$0.drawableState.getInEditMode()) {
            return $this$generateShadowBitmap_u24blurred;
        }
        return BlurProvider.blur$default(this$0.drawableState.getBlurProvider(), $this$generateShadowBitmap_u24blurred, 0, 0, 6, null);
    }
}

