/*
 * Decompiled with CFR 0.152.
 */
package soup.neumorphism.internal.shape;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import soup.neumorphism.LightSource;
import soup.neumorphism.NeumorphShapeAppearanceModel;
import soup.neumorphism.NeumorphShapeDrawable;
import soup.neumorphism.internal.blur.BlurProvider;
import soup.neumorphism.internal.shape.Shape;
import soup.neumorphism.internal.util.CanvasCompat;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u001e\u0010\u0016\u001a\u0004\u0018\u00010\u0006*\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lsoup/neumorphism/internal/shape/FlatShape;", "Lsoup/neumorphism/internal/shape/Shape;", "drawableState", "Lsoup/neumorphism/NeumorphShapeDrawable$NeumorphShapeDrawableState;", "(Lsoup/neumorphism/NeumorphShapeDrawable$NeumorphShapeDrawableState;)V", "darkShadowBitmap", "Landroid/graphics/Bitmap;", "darkShadowDrawable", "Landroid/graphics/drawable/GradientDrawable;", "lightShadowBitmap", "lightShadowDrawable", "draw", "", "canvas", "Landroid/graphics/Canvas;", "outlinePath", "Landroid/graphics/Path;", "setDrawableState", "newDrawableState", "updateShadowBitmap", "bounds", "Landroid/graphics/Rect;", "toBlurredBitmap", "Landroid/graphics/drawable/Drawable;", "w", "", "h", "neumorphism_release"})
public final class FlatShape
implements Shape {
    @NotNull
    private NeumorphShapeDrawable.NeumorphShapeDrawableState drawableState;
    @Nullable
    private Bitmap lightShadowBitmap;
    @Nullable
    private Bitmap darkShadowBitmap;
    @NotNull
    private final GradientDrawable lightShadowDrawable;
    @NotNull
    private final GradientDrawable darkShadowDrawable;

    public FlatShape(@NotNull NeumorphShapeDrawable.NeumorphShapeDrawableState drawableState) {
        Intrinsics.checkNotNullParameter((Object)((Object)drawableState), (String)"drawableState");
        this.drawableState = drawableState;
        this.lightShadowDrawable = new GradientDrawable();
        this.darkShadowDrawable = new GradientDrawable();
    }

    @Override
    public void setDrawableState(@NotNull NeumorphShapeDrawable.NeumorphShapeDrawableState newDrawableState) {
        Intrinsics.checkNotNullParameter((Object)((Object)newDrawableState), (String)"newDrawableState");
        this.drawableState = newDrawableState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void draw(@NotNull Canvas canvas, @NotNull Path outlinePath) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Intrinsics.checkNotNullParameter((Object)outlinePath, (String)"outlinePath");
        Canvas $this$withClipOut$iv = canvas;
        boolean $i$f$withClipOut = false;
        int checkpoint$iv = $this$withClipOut$iv.save();
        CanvasCompat.INSTANCE.clipOutPath($this$withClipOut$iv, outlinePath);
        try {
            float offsetY;
            float offsetX;
            Bitmap it;
            boolean bl;
            boolean bl2;
            Bitmap bitmap;
            Canvas $this$draw_u24lambda_u2d2 = $this$withClipOut$iv;
            boolean bl3 = false;
            int lightSource = this.drawableState.getLightSource();
            float elevation = this.drawableState.getShadowElevation();
            float z = this.drawableState.getShadowElevation() + this.drawableState.getTranslationZ();
            Rect inset = this.drawableState.getInset();
            float left = inset.left;
            float top = inset.top;
            Bitmap bitmap2 = this.lightShadowBitmap;
            if (bitmap2 != null) {
                bitmap = bitmap2;
                bl2 = false;
                bl = false;
                it = bitmap;
                boolean bl4 = false;
                offsetX = LightSource.Companion.isLeft(lightSource) ? -elevation - z : -elevation + z;
                offsetY = LightSource.Companion.isTop(lightSource) ? -elevation - z : -elevation + z;
                $this$draw_u24lambda_u2d2.drawBitmap(it, offsetX + left, offsetY + top, null);
            }
            bitmap2 = this.darkShadowBitmap;
            if (bitmap2 == null) {
            } else {
                bitmap = bitmap2;
                bl2 = false;
                bl = false;
                it = bitmap;
                boolean bl5 = false;
                offsetX = LightSource.Companion.isLeft(lightSource) ? -elevation + z : -elevation - z;
                offsetY = LightSource.Companion.isTop(lightSource) ? -elevation + z : -elevation - z;
                $this$draw_u24lambda_u2d2.drawBitmap(it, offsetX + left, offsetY + top, null);
            }
        }
        finally {
            $this$withClipOut$iv.restoreToCount(checkpoint$iv);
        }
    }

    @Override
    public void updateShadowBitmap(@NotNull Rect bounds) {
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        GradientDrawable gradientDrawable = this.lightShadowDrawable;
        boolean bl = false;
        boolean bl2 = false;
        GradientDrawable $this$updateShadowBitmap_u24lambda_u2d3 = gradientDrawable;
        boolean bl3 = false;
        $this$updateShadowBitmap_u24lambda_u2d3.setColor(this.drawableState.getShadowColorLight());
        FlatShape.updateShadowBitmap$setCornerShape($this$updateShadowBitmap_u24lambda_u2d3, bounds, this.drawableState.getShapeAppearanceModel());
        gradientDrawable = this.darkShadowDrawable;
        bl = false;
        bl2 = false;
        GradientDrawable $this$updateShadowBitmap_u24lambda_u2d4 = gradientDrawable;
        boolean bl4 = false;
        $this$updateShadowBitmap_u24lambda_u2d4.setColor(this.drawableState.getShadowColorDark());
        FlatShape.updateShadowBitmap$setCornerShape($this$updateShadowBitmap_u24lambda_u2d4, bounds, this.drawableState.getShapeAppearanceModel());
        int w = bounds.width();
        int h = bounds.height();
        this.lightShadowDrawable.setSize(w, h);
        this.lightShadowDrawable.setBounds(0, 0, w, h);
        this.darkShadowDrawable.setSize(w, h);
        this.darkShadowDrawable.setBounds(0, 0, w, h);
        this.lightShadowBitmap = this.toBlurredBitmap((Drawable)this.lightShadowDrawable, w, h);
        this.darkShadowBitmap = this.toBlurredBitmap((Drawable)this.darkShadowDrawable, w, h);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final Bitmap toBlurredBitmap(Drawable $this$toBlurredBitmap, int w, int h) {
        void $this$onCanvas$iv;
        float shadowElevation = this.drawableState.getShadowElevation();
        int width = MathKt.roundToInt((float)((float)w + shadowElevation * (float)2));
        int height = MathKt.roundToInt((float)((float)h + shadowElevation * (float)2));
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"createBitmap(width, heig\u2026 Bitmap.Config.ARGB_8888)");
        boolean $i$f$onCanvas = false;
        void var9_9 = $this$onCanvas$iv;
        boolean bl = false;
        boolean bl2 = false;
        void it$iv = var9_9;
        boolean bl3 = false;
        Canvas canvas = new Canvas((Bitmap)it$iv);
        boolean bl4 = false;
        boolean bl5 = false;
        Canvas $this$toBlurredBitmap_u24lambda_u2d6 = canvas;
        boolean bl6 = false;
        Canvas $this$withTranslation$iv = $this$toBlurredBitmap_u24lambda_u2d6;
        boolean $i$f$withTranslation = false;
        int checkpoint$iv = $this$withTranslation$iv.save();
        $this$withTranslation$iv.translate(shadowElevation, shadowElevation);
        try {
            Canvas $this$toBlurredBitmap_u24lambda_u2d6_u24lambda_u2d5 = $this$withTranslation$iv;
            boolean bl7 = false;
            $this$toBlurredBitmap.draw($this$toBlurredBitmap_u24lambda_u2d6_u24lambda_u2d5);
        }
        finally {
            $this$withTranslation$iv.restoreToCount(checkpoint$iv);
        }
        return FlatShape.toBlurredBitmap$blurred((Bitmap)var9_9, this);
    }

    private static final void updateShadowBitmap$setCornerShape(GradientDrawable $this$updateShadowBitmap_u24setCornerShape, Rect $bounds, NeumorphShapeAppearanceModel shapeAppearanceModel) {
        int n = shapeAppearanceModel.getCornerFamily();
        switch (n) {
            case 1: {
                $this$updateShadowBitmap_u24setCornerShape.setShape(1);
                break;
            }
            case 0: {
                $this$updateShadowBitmap_u24setCornerShape.setShape(0);
                float f = (float)$bounds.width() / 2.0f;
                float f2 = (float)$bounds.height() / 2.0f;
                boolean bl = false;
                $this$updateShadowBitmap_u24setCornerShape.setCornerRadii(shapeAppearanceModel.getCornerRadii$neumorphism_release(Math.min(f, f2)));
            }
        }
    }

    private static final Bitmap toBlurredBitmap$blurred(Bitmap $this$toBlurredBitmap_u24blurred, FlatShape this$0) {
        if (this$0.drawableState.getInEditMode()) {
            return $this$toBlurredBitmap_u24blurred;
        }
        return BlurProvider.blur$default(this$0.drawableState.getBlurProvider(), $this$toBlurredBitmap_u24blurred, 0, 0, 6, null);
    }
}

