/*
 * Decompiled with CFR 0.152.
 */
package soup.neumorphism.internal.blur;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.os.Build;
import android.renderscript.Allocation;
import android.renderscript.Element;
import android.renderscript.RSRuntimeException;
import android.renderscript.RenderScript;
import android.renderscript.ScriptIntrinsicBlur;
import android.renderscript.Type;
import android.util.DisplayMetrics;
import java.lang.ref.WeakReference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import soup.neumorphism.internal.blur.BlurFactor;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u000b2\b\b\u0002\u0010\r\u001a\u00020\t2\b\b\u0002\u0010\u000e\u001a\u00020\tJ\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\tH\u0002J\"\u0010\u0013\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u001c\u0010\u0005\u001a\u0010\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00030\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lsoup/neumorphism/internal/blur/BlurProvider;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "contextRef", "Ljava/lang/ref/WeakReference;", "kotlin.jvm.PlatformType", "defaultBlurRadius", "", "blur", "Landroid/graphics/Bitmap;", "source", "radius", "sampling", "factor", "Lsoup/neumorphism/internal/blur/BlurFactor;", "rs", "bitmap", "stack", "sentBitmap", "canReuseInBitmap", "", "neumorphism_release"})
public final class BlurProvider {
    @NotNull
    private final WeakReference<Context> contextRef;
    private final int defaultBlurRadius;

    public BlurProvider(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.contextRef = new WeakReference<Context>(context);
        float densityStable = Build.VERSION.SDK_INT >= 24 ? (float)DisplayMetrics.DENSITY_DEVICE_STABLE / 160.0f : context.getResources().getDisplayMetrics().density;
        int n = 25;
        int n2 = MathKt.roundToInt((float)(densityStable * (float)10));
        boolean bl = false;
        this.defaultBlurRadius = Math.min(n, n2);
    }

    @Nullable
    public final Bitmap blur(@NotNull Bitmap source, int radius, int sampling) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        BlurFactor factor = new BlurFactor(source.getWidth(), source.getHeight(), radius, sampling, 0, 16, null);
        return this.blur(source, factor);
    }

    public static /* synthetic */ Bitmap blur$default(BlurProvider blurProvider, Bitmap bitmap, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = blurProvider.defaultBlurRadius;
        }
        if ((n3 & 4) != 0) {
            n2 = 1;
        }
        return blurProvider.blur(bitmap, n, n2);
    }

    /*
     * WARNING - void declaration
     */
    private final Bitmap blur(Bitmap source, BlurFactor factor) {
        Bitmap bitmap;
        Bitmap blurBitmap;
        Bitmap bitmap2;
        void $this$onCanvas$iv;
        int width = factor.getWidth() / factor.getSampling();
        int height = factor.getHeight() / factor.getSampling();
        if (width == 0 || height == 0) {
            return null;
        }
        Bitmap bitmap3 = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap3, (String)"createBitmap(width, heig\u2026 Bitmap.Config.ARGB_8888)");
        boolean $i$f$onCanvas = false;
        Bitmap bitmap4 = $this$onCanvas$iv;
        boolean bl = false;
        boolean bl2 = false;
        void it$iv = bitmap4;
        boolean bl3 = false;
        Canvas canvas = new Canvas((Bitmap)it$iv);
        boolean bl4 = false;
        boolean bl5 = false;
        Canvas $this$blur_u24lambda_u2d1 = canvas;
        boolean bl6 = false;
        $this$blur_u24lambda_u2d1.scale(1.0f / (float)factor.getSampling(), 1.0f / (float)factor.getSampling());
        Paint paint = new Paint();
        boolean bl7 = false;
        boolean bl8 = false;
        Paint $this$blur_u24lambda_u2d1_u24lambda_u2d0 = paint;
        boolean bl9 = false;
        $this$blur_u24lambda_u2d1_u24lambda_u2d0.setFlags(3);
        $this$blur_u24lambda_u2d1_u24lambda_u2d0.setColorFilter((ColorFilter)new PorterDuffColorFilter(factor.getColor(), PorterDuff.Mode.SRC_ATOP));
        Paint paint2 = paint;
        $this$blur_u24lambda_u2d1.drawBitmap(source, 0.0f, 0.0f, paint2);
        void bitmap5 = bitmap4;
        try {
            bitmap2 = this.rs((Bitmap)bitmap5, factor.getRadius());
        }
        catch (RSRuntimeException e) {
            bitmap2 = this.stack((Bitmap)bitmap5, factor.getRadius(), true);
        }
        bitmap2 = blurBitmap = bitmap2;
        if (bitmap2 == null) {
            bitmap = null;
        } else {
            bitmap4 = bitmap2;
            bl = false;
            bl2 = false;
            Bitmap it = bitmap4;
            boolean bl10 = false;
            if (factor.getSampling() == 1) {
                bitmap = it;
            } else {
                Bitmap scaled = Bitmap.createScaledBitmap((Bitmap)it, (int)factor.getWidth(), (int)factor.getHeight(), (boolean)true);
                it.recycle();
                bitmap = scaled;
            }
        }
        return bitmap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Bitmap rs(Bitmap bitmap, int radius) throws RSRuntimeException {
        Context context;
        Context context2 = (Context)this.contextRef.get();
        if (context2 == null) {
            return null;
        }
        Context context3 = context = context2;
        RenderScript rs = null;
        Allocation input = null;
        Allocation output = null;
        ScriptIntrinsicBlur blur = null;
        try {
            rs = RenderScript.create((Context)context3);
            rs.setMessageHandler(new RenderScript.RSMessageHandler());
            input = Allocation.createFromBitmap((RenderScript)rs, (Bitmap)bitmap, (Allocation.MipmapControl)Allocation.MipmapControl.MIPMAP_NONE, (int)1);
            output = Allocation.createTyped((RenderScript)rs, (Type)input.getType());
            blur = ScriptIntrinsicBlur.create((RenderScript)rs, (Element)Element.U8_4((RenderScript)rs));
            blur.setInput(input);
            blur.setRadius((float)radius);
            blur.forEach(output);
            output.copyTo(bitmap);
        }
        finally {
            RenderScript renderScript = rs;
            if (renderScript != null) {
                renderScript.destroy();
            }
            renderScript = input;
            if (renderScript != null) {
                renderScript.destroy();
            }
            renderScript = output;
            if (renderScript != null) {
                renderScript.destroy();
            }
            renderScript = blur;
            if (renderScript != null) {
                renderScript.destroy();
            }
        }
        return bitmap;
    }

    private final Bitmap stack(Bitmap sentBitmap, int radius, boolean canReuseInBitmap) {
        int n;
        Bitmap bitmap;
        if (radius < 1) {
            return null;
        }
        if (canReuseInBitmap) {
            bitmap = sentBitmap;
        } else {
            Bitmap bitmap2 = sentBitmap.copy(sentBitmap.getConfig(), true);
            Intrinsics.checkNotNullExpressionValue((Object)bitmap2, (String)"{\n            sentBitmap\u2026p.config, true)\n        }");
            bitmap = bitmap2;
        }
        Bitmap bitmap3 = bitmap;
        int w = bitmap3.getWidth();
        int h = bitmap3.getHeight();
        int[] pix = new int[w * h];
        bitmap3.getPixels(pix, 0, w, 0, 0, w, h);
        int wm = w - 1;
        int hm = h - 1;
        int wh = w * h;
        int div = radius + radius + 1;
        int[] r = new int[wh];
        int[] g = new int[wh];
        int[] b = new int[wh];
        int rsum = 0;
        int gsum = 0;
        int bsum = 0;
        int x = 0;
        int y = 0;
        int i = 0;
        int p = 0;
        int yp = 0;
        int yi = 0;
        int yw = 0;
        boolean bl = false;
        int[] vmin = new int[Math.max(w, h)];
        int divsum = div + 1 >> 1;
        divsum *= divsum;
        int[] dv = new int[256 * divsum];
        i = 0;
        while (i < 256 * divsum) {
            dv[i] = i / divsum;
            int n2 = i;
            i = n2 + 1;
        }
        yw = yi = 0;
        int n3 = 0;
        int n4 = div;
        int[][] nArrayArray = new int[n4][];
        while (n3 < n4) {
            int n5 = n3++;
            nArrayArray[n5] = new int[3];
        }
        int[][] stack = nArrayArray;
        int stackpointer = 0;
        int stackstart = 0;
        int[] sir = null;
        int rbs = 0;
        int r1 = radius + 1;
        int routsum = 0;
        int goutsum = 0;
        int boutsum = 0;
        int rinsum = 0;
        int ginsum = 0;
        int binsum = 0;
        y = 0;
        while (y < h) {
            rinsum = ginsum = (binsum = (routsum = (goutsum = (boutsum = (rsum = (gsum = (bsum = 0)))))));
            i = -radius;
            while (i <= radius) {
                n = 0;
                boolean bl2 = false;
                n = Math.max(i, n);
                bl2 = false;
                p = pix[yi + Math.min(wm, n)];
                sir = stack[i + radius];
                sir[0] = (p & 0xFF0000) >> 16;
                sir[1] = (p & 0xFF00) >> 8;
                sir[2] = p & 0xFF;
                rbs = r1 - Math.abs(i);
                rsum += sir[0] * rbs;
                gsum += sir[1] * rbs;
                bsum += sir[2] * rbs;
                if (i > 0) {
                    rinsum += sir[0];
                    ginsum += sir[1];
                    binsum += sir[2];
                } else {
                    routsum += sir[0];
                    goutsum += sir[1];
                    boutsum += sir[2];
                }
                n = i;
                i = n + 1;
            }
            stackpointer = radius;
            x = 0;
            while (x < w) {
                r[yi] = dv[rsum];
                g[yi] = dv[gsum];
                b[yi] = dv[bsum];
                rsum -= routsum;
                gsum -= goutsum;
                bsum -= boutsum;
                stackstart = stackpointer - radius + div;
                sir = stack[stackstart % div];
                routsum -= sir[0];
                goutsum -= sir[1];
                boutsum -= sir[2];
                if (y == 0) {
                    vmin[x] = Math.min(x + radius + 1, wm);
                }
                p = pix[yw + vmin[x]];
                sir[0] = (p & 0xFF0000) >> 16;
                sir[1] = (p & 0xFF00) >> 8;
                sir[2] = p & 0xFF;
                rsum += (rinsum += sir[0]);
                gsum += (ginsum += sir[1]);
                bsum += (binsum += sir[2]);
                stackpointer = (stackpointer + 1) % div;
                sir = stack[stackpointer % div];
                routsum += sir[0];
                goutsum += sir[1];
                boutsum += sir[2];
                rinsum -= sir[0];
                ginsum -= sir[1];
                binsum -= sir[2];
                n = yi;
                yi = n + 1;
                n = x;
                x = n + 1;
            }
            yw += w;
            n = y;
            y = n + 1;
        }
        x = 0;
        while (x < w) {
            rinsum = ginsum = (binsum = (routsum = (goutsum = (boutsum = (rsum = (gsum = (bsum = 0)))))));
            yp = -radius * w;
            i = -radius;
            while (i <= radius) {
                yi = Math.max(0, yp) + x;
                sir = stack[i + radius];
                sir[0] = r[yi];
                sir[1] = g[yi];
                sir[2] = b[yi];
                rbs = r1 - Math.abs(i);
                rsum += r[yi] * rbs;
                gsum += g[yi] * rbs;
                bsum += b[yi] * rbs;
                if (i > 0) {
                    rinsum += sir[0];
                    ginsum += sir[1];
                    binsum += sir[2];
                } else {
                    routsum += sir[0];
                    goutsum += sir[1];
                    boutsum += sir[2];
                }
                if (i < hm) {
                    yp += w;
                }
                n = i;
                i = n + 1;
            }
            yi = x;
            stackpointer = radius;
            y = 0;
            while (y < h) {
                pix[yi] = 0xFF000000 & pix[yi] | dv[rsum] << 16 | dv[gsum] << 8 | dv[bsum];
                rsum -= routsum;
                gsum -= goutsum;
                bsum -= boutsum;
                stackstart = stackpointer - radius + div;
                sir = stack[stackstart % div];
                routsum -= sir[0];
                goutsum -= sir[1];
                boutsum -= sir[2];
                if (x == 0) {
                    vmin[y] = Math.min(y + r1, hm) * w;
                }
                p = x + vmin[y];
                sir[0] = r[p];
                sir[1] = g[p];
                sir[2] = b[p];
                rsum += (rinsum += sir[0]);
                gsum += (ginsum += sir[1]);
                bsum += (binsum += sir[2]);
                stackpointer = (stackpointer + 1) % div;
                sir = stack[stackpointer];
                routsum += sir[0];
                goutsum += sir[1];
                boutsum += sir[2];
                rinsum -= sir[0];
                ginsum -= sir[1];
                binsum -= sir[2];
                yi += w;
                n = y;
                y = n + 1;
            }
            n = x;
            x = n + 1;
        }
        bitmap3.setPixels(pix, 0, w, 0, 0, w, h);
        return bitmap3;
    }
}

