/*
 * Decompiled with CFR 0.152.
 */
package soup.neumorphism;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BlurMaskFilter;
import android.graphics.Canvas;
import android.graphics.MaskFilter;
import android.graphics.Paint;
import android.os.Build;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.util.AttributeSet;
import androidx.appcompat.widget.AppCompatTextView;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import soup.neumorphism.R;
import soup.neumorphism.internal.util.NeumorphResources;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B/\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0007H\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J(\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u0007H\u0014J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J0\u0010$\u001a\u0004\u0018\u00010\u000b*\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010%\u001a\u00020\u00072\b\b\u0002\u0010&\u001a\u00020'H\u0002R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lsoup/neumorphism/NeumorphTextView;", "Landroidx/appcompat/widget/AppCompatTextView;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "defStyleRes", "(Landroid/content/Context;Landroid/util/AttributeSet;II)V", "lastShadowDark", "Landroid/graphics/Bitmap;", "lastShadowLight", "lastTextCache", "shadowColorDark", "shadowColorLight", "shadowElevation", "", "shadowPaint", "Landroid/graphics/Paint;", "buildTextCache", "w", "h", "draw", "", "canvas", "Landroid/graphics/Canvas;", "onSizeChanged", "oldw", "oldh", "staticLayout", "Landroid/text/StaticLayout;", "text", "", "textPaint", "Landroid/text/TextPaint;", "generateBitmapShadowCache", "color", "isInEditMode", "", "neumorphism_release"})
public final class NeumorphTextView
extends AppCompatTextView {
    private final float shadowElevation;
    private final int shadowColorLight;
    private final int shadowColorDark;
    private final Paint shadowPaint;
    private Bitmap lastTextCache;
    private Bitmap lastShadowLight;
    private Bitmap lastShadowDark;

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        Bitmap bitmap;
        super.onSizeChanged(w, h, oldw, oldh);
        Bitmap bitmap2 = this.buildTextCache(w, h);
        NeumorphTextView neumorphTextView = this;
        boolean bl = false;
        boolean bl2 = false;
        Bitmap origin = bitmap2;
        boolean bl3 = false;
        this.lastShadowLight = this.generateBitmapShadowCache(origin, w, h, this.shadowColorLight, this.isInEditMode());
        this.lastShadowDark = this.generateBitmapShadowCache(origin, w, h, this.shadowColorDark, this.isInEditMode());
        neumorphTextView.lastTextCache = bitmap = bitmap2;
    }

    public void draw(@NotNull Canvas canvas) {
        Bitmap it;
        boolean bl;
        boolean bl2;
        Bitmap bitmap;
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        Bitmap bitmap2 = this.lastShadowLight;
        if (bitmap2 != null) {
            bitmap = bitmap2;
            bl2 = false;
            bl = false;
            it = bitmap;
            boolean bl3 = false;
            canvas.drawBitmap(it, -this.shadowElevation, -this.shadowElevation, this.shadowPaint);
        }
        Bitmap bitmap3 = this.lastShadowDark;
        if (bitmap3 != null) {
            bitmap = bitmap3;
            bl2 = false;
            bl = false;
            it = bitmap;
            boolean bl4 = false;
            canvas.drawBitmap(it, this.shadowElevation, this.shadowElevation, this.shadowPaint);
        }
        super.draw(canvas);
    }

    private final Bitmap buildTextCache(int w, int h) {
        Bitmap bitmap = Bitmap.createBitmap((int)w, (int)h, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        boolean bl = false;
        boolean bl2 = false;
        Bitmap $this$apply = bitmap;
        boolean bl3 = false;
        TextPaint tp = new TextPaint(1);
        tp.setColor(-16777216);
        tp.setTextSize(this.getTextSize());
        tp.setTypeface(this.getTypeface());
        CharSequence charSequence = this.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)charSequence, (String)"text");
        this.staticLayout(charSequence, tp).draw(new Canvas($this$apply));
        Bitmap bitmap2 = bitmap;
        Intrinsics.checkExpressionValueIsNotNull((Object)bitmap2, (String)"Bitmap.createBitmap(w, h\u2026w(Canvas(this))\n        }");
        return bitmap2;
    }

    private final StaticLayout staticLayout(CharSequence text, TextPaint textPaint) {
        StaticLayout staticLayout;
        if (Build.VERSION.SDK_INT >= 23) {
            StaticLayout staticLayout2 = StaticLayout.Builder.obtain((CharSequence)text, (int)0, (int)text.length(), (TextPaint)textPaint, (int)Integer.MAX_VALUE).build();
            staticLayout = staticLayout2;
            Intrinsics.checkExpressionValueIsNotNull((Object)staticLayout2, (String)"StaticLayout.Builder\n   \u2026\n                .build()");
        } else {
            staticLayout = new StaticLayout(text, textPaint, Integer.MAX_VALUE, Layout.Alignment.ALIGN_NORMAL, 1.0f, 0.0f, false);
        }
        return staticLayout;
    }

    private final Bitmap generateBitmapShadowCache(@NotNull Bitmap $this$generateBitmapShadowCache, int w, int h, int color2, boolean isInEditMode) {
        Bitmap bitmap = Bitmap.createBitmap((int)w, (int)h, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        canvas.save();
        canvas.drawBitmap($this$generateBitmapShadowCache, 0.0f, 0.0f, null);
        canvas.restore();
        Paint paint = new Paint(3);
        paint.setColor(color2);
        if (!isInEditMode) {
            paint.setMaskFilter((MaskFilter)new BlurMaskFilter(5.0f, BlurMaskFilter.Blur.NORMAL));
        }
        int[] offset = new int[2];
        Bitmap shadow = bitmap.extractAlpha(paint, offset);
        paint.setMaskFilter((MaskFilter)null);
        bitmap.eraseColor(0);
        canvas.drawBitmap(shadow, (float)offset[0], (float)offset[1], paint);
        return bitmap;
    }

    static /* synthetic */ Bitmap generateBitmapShadowCache$default(NeumorphTextView neumorphTextView, Bitmap bitmap, int n, int n2, int n3, boolean bl, int n4, Object object) {
        if ((n4 & 8) != 0) {
            bl = false;
        }
        return neumorphTextView.generateBitmapShadowCache(bitmap, n, n2, n3, bl);
    }

    @JvmOverloads
    public NeumorphTextView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.shadowPaint = new Paint(3);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.NeumorphTextView, defStyleAttr, defStyleRes);
        Intrinsics.checkExpressionValueIsNotNull((Object)typedArray, (String)"context.obtainStyledAttr\u2026tr, defStyleRes\n        )");
        TypedArray a = typedArray;
        this.shadowElevation = a.getDimension(R.styleable.NeumorphTextView_neumorph_shadowElevation, 0.0f);
        this.shadowColorLight = NeumorphResources.INSTANCE.getColor(context, a, R.styleable.NeumorphTextView_neumorph_shadowColorLight, R.color.design_default_color_shadow_light);
        this.shadowColorDark = NeumorphResources.INSTANCE.getColor(context, a, R.styleable.NeumorphTextView_neumorph_shadowColorDark, R.color.design_default_color_shadow_dark);
        a.recycle();
    }

    public /* synthetic */ NeumorphTextView(Context context, AttributeSet attributeSet, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            attributeSet = null;
        }
        if ((n3 & 4) != 0) {
            n = R.attr.neumorphTextViewStyle;
        }
        if ((n3 & 8) != 0) {
            n2 = R.style.Widget_Neumorph_TextView;
        }
        this(context, attributeSet, n, n2);
    }

    @JvmOverloads
    public NeumorphTextView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0, 8, null);
    }

    @JvmOverloads
    public NeumorphTextView(@NotNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 0, 12, null);
    }

    @JvmOverloads
    public NeumorphTextView(@NotNull Context context) {
        this(context, null, 0, 0, 14, null);
    }
}

