/*
 * Decompiled with CFR 0.152.
 */
package com.github.fommil.netlib.generator;

import com.github.fommil.netlib.generator.AbstractJavaGenerator;
import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.stringtemplate.v4.ST;

@Mojo(name="native-java", defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresDependencyResolution=ResolutionScope.COMPILE)
public class NativeImplJavaGenerator
extends AbstractJavaGenerator {
    @Parameter(required=true)
    protected String implementing;
    @Parameter(required=true)
    protected String natives;
    @Parameter
    protected String extending;
    @Parameter
    protected String unsupported;

    @Override
    protected String generate(List<Method> methods) throws Exception {
        ArrayList members = Lists.newArrayList();
        ST loader = this.jTemplates.getInstanceOf("staticJniLoader");
        loader.add("libs", (Object)this.natives);
        loader.add("prop", (Object)(this.getTargetPackage() + "." + this.getTargetClassName() + ".natives"));
        members.add(loader.render());
        for (Method method : methods) {
            ST m = this.getTemplate(method, false);
            if (m == null) continue;
            members.add(this.render(m, method, false));
            if (!this.hasOffsets(method)) continue;
            members.add(this.render(this.getTemplate(method, true), method, true));
        }
        ST t = this.jTemplates.getInstanceOf("implClass");
        t.add("package", (Object)this.getTargetPackage());
        t.add("name", (Object)this.getTargetClassName());
        t.add("members", (Object)members);
        t.add("docs", (Object)this.getGenerationSummaryJavadocs());
        t.add("parent", (Object)(this.extending != null ? this.extending : this.implementing));
        return t.render();
    }

    private ST getTemplate(Method method, boolean offsets) {
        ST m = this.jTemplates.getInstanceOf("nativeImplMethod" + (offsets ? "_offsets" : ""));
        if (this.unsupported != null && method.getName().matches(this.unsupported)) {
            if (this.extending == null) {
                m = this.jTemplates.getInstanceOf("unsupportedMethod");
            } else {
                return null;
            }
        }
        return m;
    }

    private String render(ST m, Method method, boolean offsets) {
        m.add("returns", method.getReturnType());
        if (offsets && method.getReturnType() == Void.TYPE) {
            m.add("return", (Object)"");
        }
        m.add("method", (Object)method.getName());
        m.add("paramTypes", this.getNetlibJavaParameterTypes(method, offsets));
        m.add("paramNames", this.getNetlibJavaParameterNames(method, offsets));
        return m.render();
    }
}

