/*
 * Decompiled with CFR 0.152.
 */
package com.github.fommil.netlib.generator;

import com.github.fommil.netlib.generator.AbstractJavaGenerator;
import com.github.fommil.netlib.generator.F2jJavadocExtractor;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.stringtemplate.v4.ST;

@Mojo(name="interface", defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresDependencyResolution=ResolutionScope.COMPILE)
public class JavaInterfaceGenerator
extends AbstractJavaGenerator {
    @Parameter(required=true)
    protected String fallback;
    @Parameter
    protected String initCode;

    @Override
    protected String generate(List<Method> methods) throws Exception {
        ArrayList members = Lists.newArrayList();
        for (Method method : methods) {
            members.add(this.renderMethod(method, false));
            if (!this.hasOffsets(method)) continue;
            members.add(this.renderMethod(method, true));
        }
        ST t = this.jTemplates.getInstanceOf("abstractClass");
        t.add("package", (Object)this.getTargetPackage());
        t.add("name", (Object)this.getTargetClassName());
        t.add("members", (Object)members);
        t.add("docs", (Object)this.getGenerationSummaryJavadocs());
        t.add("fallback", (Object)this.fallback);
        if (!Strings.isNullOrEmpty((String)this.initCode)) {
            t.add("initCode", (Object)this.initCode);
        }
        return t.render();
    }

    private String renderMethod(Method method, boolean offsets) throws IOException {
        ST m = this.jTemplates.getInstanceOf("abstractMethod");
        m.add("return", method.getReturnType());
        if (method.getReturnType().equals(Void.TYPE)) {
            m.add("returnDocs", (Object)"");
        }
        m.add("method", (Object)method.getName());
        m.add("paramTypes", this.getNetlibJavaParameterTypes(method, offsets));
        m.add("paramNames", this.getNetlibJavaParameterNames(method, offsets));
        if (!Strings.isNullOrEmpty((String)this.javadoc)) {
            m.add("docs", (Object)this.getJavadocs(method));
        }
        return m.render();
    }

    private String getJavadocs(Method method) throws IOException {
        File jar = this.getFile(this.javadoc);
        F2jJavadocExtractor extractor = new F2jJavadocExtractor(jar);
        return extractor.getJavadocDescription(method);
    }
}

