/*
 * Decompiled with CFR 0.152.
 */
package com.github.fmjsjx.libnetty.example.fastcgi;

import com.github.fmjsjx.libnetty.example.fastcgi.TestClientHandler;
import com.github.fmjsjx.libnetty.fastcgi.FcgiMessageDecoder;
import com.github.fmjsjx.libnetty.fastcgi.FcgiMessageEncoder;
import com.github.fmjsjx.libnetty.fastcgi.FcgiParams;
import com.github.fmjsjx.libnetty.fastcgi.FcgiRequest;
import com.github.fmjsjx.libnetty.fastcgi.FcgiVersion;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.util.CharsetUtil;
import java.nio.charset.Charset;

public class TestClient {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        final FcgiMessageEncoder encoder = new FcgiMessageEncoder();
        NioEventLoopGroup group = new NioEventLoopGroup(1);
        try {
            Bootstrap b = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)group)).channel(NioSocketChannel.class)).option(ChannelOption.TCP_NODELAY, (Object)true)).handler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) throws Exception {
                    ch.pipeline().addLast(new ChannelHandler[]{new ReadTimeoutHandler(60)}).addLast(new ChannelHandler[]{encoder}).addLast(new ChannelHandler[]{new FcgiMessageDecoder()}).addLast(new ChannelHandler[]{new TestClientHandler()});
                }
            });
            ChannelFuture cf = b.connect("127.0.0.1", 9000).sync();
            Channel channel = cf.channel();
            if (cf.isSuccess()) {
                TestClient.request(channel, 1);
                TestClient.request(channel, 2);
                TestClient.request(channel, 3);
                channel.closeFuture().sync();
            }
        }
        finally {
            group.shutdownGracefully();
        }
    }

    static void request(Channel channel, int requestId) {
        ByteBuf content = Unpooled.copiedBuffer((CharSequence)("name=o&coung=" + requestId + "&test=haha&timestamp=" + System.currentTimeMillis()), (Charset)CharsetUtil.UTF_8);
        FcgiRequest request = new FcgiRequest(FcgiVersion.VERSION_1, requestId, content);
        if (requestId != 3) {
            request.beginRequest().keepConn();
        }
        ((FcgiParams)((FcgiParams)((FcgiParams)((FcgiParams)((FcgiParams)((FcgiParams)request.params().put("SCRIPT_FILENAME", (Object)"/scripts/ok.php")).put("REQUEST_METHOD", (Object)"POST")).put("REMOTE_ADDR", (Object)"127.0.0.1")).put("SERVER_ADDR", (Object)"127.0.0.1")).put("SERVER_PORT", (Object)"80")).put("CONTENT_TYPE", (Object)"application/www-url-form-encoded")).put("CONTENT_LENGTH", (Object)content.readableBytes());
        System.out.println("== request ==");
        System.out.println(request);
        channel.writeAndFlush((Object)request);
    }
}

