/*
 * Decompiled with CFR 0.152.
 */
package com.github.fmjsjx.libnetty.example.http.server;

import com.github.fmjsjx.libnetty.example.http.server.TestController;
import com.github.fmjsjx.libnetty.example.http.server.TestExceptionHandler;
import com.github.fmjsjx.libnetty.handler.ssl.PermutableSniHandlerProvider;
import com.github.fmjsjx.libnetty.handler.ssl.SniHandlerProvider;
import com.github.fmjsjx.libnetty.handler.ssl.SniHandlerProviders;
import com.github.fmjsjx.libnetty.handler.ssl.SslContextProviders;
import com.github.fmjsjx.libnetty.http.HttpContentCompressorProvider;
import com.github.fmjsjx.libnetty.http.server.DefaultHttpServer;
import com.github.fmjsjx.libnetty.http.server.component.HttpServerComponent;
import com.github.fmjsjx.libnetty.http.server.middleware.AccessLogger;
import com.github.fmjsjx.libnetty.http.server.middleware.Middleware;
import com.github.fmjsjx.libnetty.http.server.middleware.Router;
import com.github.fmjsjx.libnetty.http.server.middleware.ServeStatic;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.cors.CorsConfig;
import io.netty.handler.codec.http.cors.CorsConfigBuilder;
import io.netty.util.DomainWildcardMappingBuilder;
import io.netty.util.Mapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestSniServer {
    private static final Logger log = LoggerFactory.getLogger(TestSniServer.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        TestController controller = new TestController();
        CorsConfig corsConfig = CorsConfigBuilder.forAnyOrigin().allowedRequestMethods(new HttpMethod[]{HttpMethod.GET, HttpMethod.POST, HttpMethod.PUT, HttpMethod.PATCH, HttpMethod.DELETE}).allowedRequestHeaders(new String[]{"*"}).allowNullOrigin().build();
        DomainWildcardMappingBuilder mappingBuilder = new DomainWildcardMappingBuilder((Object)SslContextProviders.selfSignedForServer().get());
        PermutableSniHandlerProvider sniHandlerProvider = SniHandlerProviders.permutable((Mapping)mappingBuilder.build());
        DefaultHttpServer server = new DefaultHttpServer("test", 8443).enableSsl((SniHandlerProvider)sniHandlerProvider).neverTimeout().corsConfig(corsConfig).ioThreads(1).maxContentLength(0xA00000).supportJson().component((HttpServerComponent)new TestExceptionHandler()).soBackLog(1024).tcpNoDelay().applyCompressionOptions(HttpContentCompressorProvider.defaultOptions());
        server.defaultHandlerProvider().addLast(new Middleware[]{new AccessLogger((AccessLogger.LoggerWrapper)new AccessLogger.Slf4jLoggerWrapper("accessLogger"), AccessLogger.LogFormat.BASIC2)}).addLast(new Middleware[]{new ServeStatic("/static/", "src/main/resources/static/")}).addLast(new Middleware[]{new Router().register((Object)controller).init()});
        try {
            server.startup();
            log.info("Server {} started.", (Object)server);
            System.in.read();
        }
        catch (Exception e) {
            log.error("Unexpected error occurs when startup {}", (Object)server, (Object)e);
        }
        finally {
            if (server.isRunning()) {
                server.shutdown();
                log.info("Server {} stopped.", (Object)server);
            }
        }
    }
}

