/*
 * Decompiled with CFR 0.152.
 */
package com.github.fmjsjx.libnetty.example.http.server;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.fmjsjx.libnetty.http.server.HttpRequestContext;
import com.github.fmjsjx.libnetty.http.server.annotation.HttpGet;
import com.github.fmjsjx.libnetty.http.server.annotation.HttpPath;
import com.github.fmjsjx.libnetty.http.server.annotation.HttpPost;
import com.github.fmjsjx.libnetty.http.server.annotation.JsonBody;
import com.github.fmjsjx.libnetty.http.server.exception.ManualHttpFailureException;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.QueryStringDecoder;

@HttpPath(value={"/api"})
public class BlockingTestController {
    @HttpGet(value={"/jsons"})
    @JsonBody
    public Object getJsons(QueryStringDecoder query) {
        System.out.println("-- jsons --");
        System.out.println(Thread.currentThread());
        ObjectNode node = JsonNodeFactory.instance.objectNode();
        query.parameters().forEach((key, values) -> {
            if (values.size() == 1) {
                node.put(key, (String)values.get(0));
            } else {
                node.putPOJO(key, values);
            }
        });
        if (node.isEmpty()) {
            throw new ManualHttpFailureException(HttpResponseStatus.BAD_REQUEST, "{\"code\":1,\"message\":\"Missing Query String\"}", (CharSequence)HttpHeaderValues.APPLICATION_JSON, "Missing Query String");
        }
        return node;
    }

    @HttpPost(value={"/echo"})
    @JsonBody
    public Object postEcho(HttpRequestContext ctx, @JsonBody JsonNode value) {
        System.out.println("-- echo --");
        System.out.println(Thread.currentThread());
        System.out.println("value ==> " + value);
        return value;
    }
}

