/*
 * Decompiled with CFR 0.152.
 */
package com.github.fmjsjx.libnetty.example.http.client;

import com.github.fmjsjx.libnetty.http.client.HttpClient;
import com.github.fmjsjx.libnetty.http.client.HttpContentHandlers;
import com.github.fmjsjx.libnetty.http.client.HttpContentHolders;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;

public class TestDefaultClient {
    public static void main(String[] args) throws Exception {
        try (HttpClient client = HttpClient.defaultBuilder().compression(true).build();){
            TestDefaultClient.testSynchronousApi(client);
            TestDefaultClient.testAsynchronousApi(client);
        }
    }

    static void testSynchronousApi(HttpClient client) throws IOException, InterruptedException {
        HttpClient.Response response1 = client.request(URI.create("http://127.0.0.1:8080/foo")).get().send(HttpContentHandlers.ofString());
        if (response1.statusCode() == 200) {
            String body = (String)response1.content();
            System.out.println(body);
        }
        String postBody = "p1=abc&p2=12345";
        HttpClient.Response response2 = client.request(URI.create("http://127.0.0.1:8080/foo/bar")).post(HttpContentHolders.ofUtf8((String)postBody)).send(HttpContentHandlers.ofString());
        if (response2.statusCode() == 200) {
            String body = (String)response2.content();
            System.out.println(body);
        }
    }

    static void testAsynchronousApi(HttpClient client) throws IOException, InterruptedException {
        CountDownLatch cd = new CountDownLatch(2);
        CompletableFuture future1 = client.request(URI.create("http://127.0.0.1:8080/foo")).get().sendAsync(HttpContentHandlers.ofString());
        ((CompletableFuture)future1.thenAccept(response -> {
            if (response.statusCode() == 200) {
                String body = (String)response.content();
                System.out.println(body);
            }
        })).whenComplete((v, e) -> cd.countDown());
        String postBody = "p1=abc&p2=12345";
        CompletableFuture future2 = client.request(URI.create("http://127.0.0.1:8080/foo/bar")).post(HttpContentHolders.ofUtf8((String)postBody)).sendAsync(HttpContentHandlers.ofString());
        ((CompletableFuture)future2.thenAccept(response -> {
            if (response.statusCode() == 200) {
                String body = (String)response.content();
                System.out.println(body);
            }
        })).whenComplete((v, e) -> cd.countDown());
        cd.await();
    }
}

