/*
 * Decompiled with CFR 0.152.
 */
package flowctrl.integration.slack.webapi;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import flowctrl.integration.slack.RestUtils;
import flowctrl.integration.slack.exception.SlackArgumentException;
import flowctrl.integration.slack.exception.SlackException;
import flowctrl.integration.slack.exception.SlackResponseErrorException;
import flowctrl.integration.slack.type.Attachment;
import flowctrl.integration.slack.type.Authentication;
import flowctrl.integration.slack.type.Channel;
import flowctrl.integration.slack.type.Comment;
import flowctrl.integration.slack.type.DirectMessageChannel;
import flowctrl.integration.slack.type.DndInfo;
import flowctrl.integration.slack.type.DndSimpleInfo;
import flowctrl.integration.slack.type.EndSnooze;
import flowctrl.integration.slack.type.FileInfo;
import flowctrl.integration.slack.type.FileList;
import flowctrl.integration.slack.type.Group;
import flowctrl.integration.slack.type.History;
import flowctrl.integration.slack.type.OAuthAccessToken;
import flowctrl.integration.slack.type.PinItem;
import flowctrl.integration.slack.type.Presence;
import flowctrl.integration.slack.type.ReactionItem;
import flowctrl.integration.slack.type.ReactionList;
import flowctrl.integration.slack.type.SetSnooze;
import flowctrl.integration.slack.type.StarList;
import flowctrl.integration.slack.type.Team;
import flowctrl.integration.slack.type.TeamAccessLogList;
import flowctrl.integration.slack.type.TeamIntegrationLogList;
import flowctrl.integration.slack.type.User;
import flowctrl.integration.slack.type.UserPresence;
import flowctrl.integration.slack.type.Usergroup;
import flowctrl.integration.slack.validation.Problem;
import flowctrl.integration.slack.validation.ValidationError;
import flowctrl.integration.slack.webapi.SlackWebApiClient;
import flowctrl.integration.slack.webapi.method.SlackMethod;
import flowctrl.integration.slack.webapi.method.channels.ChannelArchiveMethod;
import flowctrl.integration.slack.webapi.method.channels.ChannelCreateMethod;
import flowctrl.integration.slack.webapi.method.channels.ChannelHistoryMethod;
import flowctrl.integration.slack.webapi.method.channels.ChannelInfoMethod;
import flowctrl.integration.slack.webapi.method.channels.ChannelInviteMethod;
import flowctrl.integration.slack.webapi.method.channels.ChannelJoinMethod;
import flowctrl.integration.slack.webapi.method.channels.ChannelKickMethod;
import flowctrl.integration.slack.webapi.method.channels.ChannelLeaveMethod;
import flowctrl.integration.slack.webapi.method.channels.ChannelListMethod;
import flowctrl.integration.slack.webapi.method.channels.ChannelMarkMethod;
import flowctrl.integration.slack.webapi.method.channels.ChannelRenameMethod;
import flowctrl.integration.slack.webapi.method.channels.ChannelSetPurposeMethod;
import flowctrl.integration.slack.webapi.method.channels.ChannelSetTopicMethod;
import flowctrl.integration.slack.webapi.method.channels.ChannelUnarchiveMethod;
import flowctrl.integration.slack.webapi.method.chats.ChatDeleteMethod;
import flowctrl.integration.slack.webapi.method.chats.ChatPostMessageMethod;
import flowctrl.integration.slack.webapi.method.chats.ChatUpdateMethod;
import flowctrl.integration.slack.webapi.method.dnd.DndInfoMethod;
import flowctrl.integration.slack.webapi.method.dnd.DndTeamInfoMethod;
import flowctrl.integration.slack.webapi.method.dnd.EndDndMethod;
import flowctrl.integration.slack.webapi.method.dnd.EndSnoozeMethod;
import flowctrl.integration.slack.webapi.method.dnd.SetSnoozeMethod;
import flowctrl.integration.slack.webapi.method.emoji.EmojiListMethod;
import flowctrl.integration.slack.webapi.method.files.FileDeleteMethod;
import flowctrl.integration.slack.webapi.method.files.FileInfoMethod;
import flowctrl.integration.slack.webapi.method.files.FileListMethod;
import flowctrl.integration.slack.webapi.method.files.FileUploadMethod;
import flowctrl.integration.slack.webapi.method.files.comments.FileCommentAddMethod;
import flowctrl.integration.slack.webapi.method.files.comments.FileCommentDeleteMethod;
import flowctrl.integration.slack.webapi.method.files.comments.FileCommentEditMethod;
import flowctrl.integration.slack.webapi.method.groups.GroupArchiveMethod;
import flowctrl.integration.slack.webapi.method.groups.GroupCloseMethod;
import flowctrl.integration.slack.webapi.method.groups.GroupCreateChildMethod;
import flowctrl.integration.slack.webapi.method.groups.GroupCreateMethod;
import flowctrl.integration.slack.webapi.method.groups.GroupHistoryMethod;
import flowctrl.integration.slack.webapi.method.groups.GroupInfoMethod;
import flowctrl.integration.slack.webapi.method.groups.GroupInviteMethod;
import flowctrl.integration.slack.webapi.method.groups.GroupKickMethod;
import flowctrl.integration.slack.webapi.method.groups.GroupLeaveMethod;
import flowctrl.integration.slack.webapi.method.groups.GroupListMethod;
import flowctrl.integration.slack.webapi.method.groups.GroupMarkMethod;
import flowctrl.integration.slack.webapi.method.groups.GroupOpenMethod;
import flowctrl.integration.slack.webapi.method.groups.GroupRenameMethod;
import flowctrl.integration.slack.webapi.method.groups.GroupSetPurposeMethod;
import flowctrl.integration.slack.webapi.method.groups.GroupSetTopicMethod;
import flowctrl.integration.slack.webapi.method.groups.GroupUnarchiveMethod;
import flowctrl.integration.slack.webapi.method.im.ImCloseMethod;
import flowctrl.integration.slack.webapi.method.im.ImHistoryMethod;
import flowctrl.integration.slack.webapi.method.im.ImListMethod;
import flowctrl.integration.slack.webapi.method.im.ImMarkMethod;
import flowctrl.integration.slack.webapi.method.im.ImOpenMethod;
import flowctrl.integration.slack.webapi.method.mpim.MpimCloseMethod;
import flowctrl.integration.slack.webapi.method.mpim.MpimHistoryMethod;
import flowctrl.integration.slack.webapi.method.mpim.MpimListMethod;
import flowctrl.integration.slack.webapi.method.mpim.MpimMarkMethod;
import flowctrl.integration.slack.webapi.method.mpim.MpimOpenMethod;
import flowctrl.integration.slack.webapi.method.oauth.OAuthAccessMethod;
import flowctrl.integration.slack.webapi.method.pins.PinsAddMethod;
import flowctrl.integration.slack.webapi.method.pins.PinsListMethod;
import flowctrl.integration.slack.webapi.method.pins.PinsRemoveMethod;
import flowctrl.integration.slack.webapi.method.reactions.ReactionsAddMethod;
import flowctrl.integration.slack.webapi.method.reactions.ReactionsGetMethod;
import flowctrl.integration.slack.webapi.method.reactions.ReactionsListMethod;
import flowctrl.integration.slack.webapi.method.reactions.ReactionsRemoveMethod;
import flowctrl.integration.slack.webapi.method.rtm.RtmStartMethod;
import flowctrl.integration.slack.webapi.method.stars.StarsAddMethod;
import flowctrl.integration.slack.webapi.method.stars.StarsListMethod;
import flowctrl.integration.slack.webapi.method.stars.StarsRemoveMethod;
import flowctrl.integration.slack.webapi.method.team.TeamAccessLogsMethod;
import flowctrl.integration.slack.webapi.method.team.TeamInfoMethod;
import flowctrl.integration.slack.webapi.method.team.TeamIntegrationLogMethod;
import flowctrl.integration.slack.webapi.method.test.AuthTestMethod;
import flowctrl.integration.slack.webapi.method.usergroups.UsergroupsCreateMethod;
import flowctrl.integration.slack.webapi.method.usergroups.UsergroupsDisableMethod;
import flowctrl.integration.slack.webapi.method.usergroups.UsergroupsEnableMethod;
import flowctrl.integration.slack.webapi.method.usergroups.UsergroupsListMethod;
import flowctrl.integration.slack.webapi.method.usergroups.UsergroupsUpdateMethod;
import flowctrl.integration.slack.webapi.method.usergroups.users.UsergroupsUsersListMethod;
import flowctrl.integration.slack.webapi.method.usergroups.users.UsergroupsUsersUpdateMethod;
import flowctrl.integration.slack.webapi.method.users.UserGetPresenceMethod;
import flowctrl.integration.slack.webapi.method.users.UserInfoMethod;
import flowctrl.integration.slack.webapi.method.users.UserListMethod;
import flowctrl.integration.slack.webapi.method.users.UserSetActiveMethod;
import flowctrl.integration.slack.webapi.method.users.UserSetPresenceMethod;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.impl.client.CloseableHttpClient;

public class SlackWebApiClientImpl
implements SlackWebApiClient {
    private String token;
    private ObjectMapper mapper;
    private CloseableHttpClient httpClient;

    public SlackWebApiClientImpl(String token) {
        this(token, null);
    }

    public SlackWebApiClientImpl(String token, ObjectMapper mapper) {
        this(token, mapper, 5000);
    }

    public SlackWebApiClientImpl(String token, ObjectMapper mapper, int timeout) {
        this.token = token;
        this.mapper = mapper != null ? mapper : new ObjectMapper();
        this.httpClient = RestUtils.createHttpClient(timeout);
    }

    @Override
    public void shutdown() {
        if (this.httpClient != null) {
            try {
                this.httpClient.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public Authentication auth() {
        JsonNode retNode = this.call(new AuthTestMethod());
        return this.readValue(retNode, null, Authentication.class);
    }

    @Override
    public boolean archiveChannel(String channel) {
        return this.isOk(new ChannelArchiveMethod(channel));
    }

    @Override
    public Channel createChannel(String name) {
        JsonNode retNode = this.call(new ChannelCreateMethod(name));
        return this.readValue(retNode, "channel", Channel.class);
    }

    @Override
    public History getChannelHistory(String channel) {
        return this.getChannelHistory(channel, null, null, false, 100, false);
    }

    @Override
    public History getChannelHistory(String channel, int count) {
        return this.getChannelHistory(channel, null, null, false, count, false);
    }

    @Override
    public History getChannelHistory(String channel, String latest, String oldest, boolean inclusive, int count, boolean unreads) {
        ChannelHistoryMethod channelHistoryMethod = new ChannelHistoryMethod(channel);
        channelHistoryMethod.setLatest(latest);
        channelHistoryMethod.setOldest(oldest);
        channelHistoryMethod.setInclusive(inclusive);
        channelHistoryMethod.setCount(count);
        channelHistoryMethod.setUnreads(unreads);
        JsonNode retNode = this.call(channelHistoryMethod);
        return this.readValue(retNode, null, History.class);
    }

    @Override
    public Channel getChannelInfo(String channel) {
        JsonNode retNode = this.call(new ChannelInfoMethod(channel));
        return this.readValue(retNode, "channel", Channel.class);
    }

    @Override
    public Channel inviteUserToChannel(String channel, String user) {
        JsonNode retNode = this.call(new ChannelInviteMethod(channel, user));
        return this.readValue(retNode, "channel", Channel.class);
    }

    @Override
    public Channel joinChannel(String name) {
        JsonNode retNode = this.call(new ChannelJoinMethod(name));
        return this.readValue(retNode, "channel", Channel.class);
    }

    @Override
    public boolean kickUserFormChannel(String channel, String user) {
        return this.isOk(new ChannelKickMethod(channel, user));
    }

    @Override
    public boolean leaveChannel(String channel) {
        return this.isOk(new ChannelLeaveMethod(channel));
    }

    @Override
    public List<Channel> getChannelList() {
        return this.getChannelList(false);
    }

    @Override
    public List<Channel> getChannelList(boolean exclude_archived) {
        JsonNode retNode = this.call(new ChannelListMethod(exclude_archived));
        return (List)this.readValue(retNode, "channels", new TypeReference<List<Channel>>(){});
    }

    @Override
    public boolean markChannel(String channel, String ts) {
        return this.isOk(new ChannelMarkMethod(channel, ts));
    }

    @Override
    public Channel renameChannel(String channel, String name) {
        JsonNode retNode = this.call(new ChannelRenameMethod(channel, name));
        return this.readValue(retNode, "channel", Channel.class);
    }

    @Override
    public boolean setChannelPurpose(String channel, String purpose) {
        return this.isOk(new ChannelSetPurposeMethod(channel, purpose));
    }

    @Override
    public boolean setChannelTopic(String channel, String topic) {
        return this.isOk(new ChannelSetTopicMethod(channel, topic));
    }

    @Override
    public boolean unarchiveChannel(String channel) {
        return this.isOk(new ChannelUnarchiveMethod(channel));
    }

    @Override
    public boolean deleteMessage(String channel, String ts) {
        return this.isOk(new ChatDeleteMethod(channel, ts));
    }

    @Override
    public String postMessage(String channel, String text) {
        return this.postMessage(new ChatPostMessageMethod(channel, text));
    }

    @Override
    public String postMessage(String channel, String text, String username, boolean as_user) {
        ChatPostMessageMethod method = new ChatPostMessageMethod(channel, text);
        method.setUsername(username);
        method.setAs_user(as_user);
        return this.postMessage(method);
    }

    @Override
    public String postMessage(String channel, String text, String username, boolean as_user, boolean link_names, List<Attachment> attachments, boolean unfurl_links, boolean unfurl_media, String icon_url, String icon_emoji) {
        ChatPostMessageMethod method = new ChatPostMessageMethod(channel, text);
        method.setUsername(username);
        method.setLink_names(link_names);
        method.setAttachments(attachments);
        method.setUnfurl_links(unfurl_links);
        method.setUnfurl_media(unfurl_media);
        method.setIcon_url(icon_url);
        method.setIcon_emoji(icon_emoji);
        return this.postMessage(method);
    }

    @Override
    public String postMessage(ChatPostMessageMethod method) {
        if (method.getMapper() == null) {
            method.setMapper(this.mapper);
        }
        JsonNode retNode = this.call(method);
        return retNode.findPath("ts").asText();
    }

    @Override
    public String updateMessage(String channel, String ts, String text) {
        return this.updateMessage(channel, ts, text, null, false);
    }

    @Override
    public String updateMessage(String channel, String ts, String text, List<Attachment> attachments, boolean link_names) {
        ChatUpdateMethod method = new ChatUpdateMethod(channel, ts, text);
        method.setAttachments(attachments);
        method.setLink_names(link_names);
        method.setMapper(this.mapper);
        JsonNode retNode = this.call(method);
        return retNode.findPath("ts").asText();
    }

    @Override
    public boolean endDnd() {
        return this.isOk(new EndDndMethod());
    }

    @Override
    public EndSnooze endSnooze() {
        JsonNode retNode = this.call(new EndSnoozeMethod());
        return this.readValue(retNode, null, EndSnooze.class);
    }

    @Override
    public SetSnooze setSnooze(int num_minutes) {
        JsonNode retNode = this.call(new SetSnoozeMethod(String.valueOf(num_minutes)));
        return this.readValue(retNode, null, SetSnooze.class);
    }

    @Override
    public DndInfo getDndInfo() {
        return this.getDndInfo(null);
    }

    @Override
    public DndInfo getDndInfo(String user) {
        JsonNode retNode = this.call(new DndInfoMethod(user));
        return this.readValue(retNode, null, DndInfo.class);
    }

    @Override
    public Map<String, DndSimpleInfo> getDndTeamInfo() {
        return this.getDndTeamInfo(null);
    }

    @Override
    public Map<String, DndSimpleInfo> getDndTeamInfo(List<String> users) {
        JsonNode retNode = this.call(new DndTeamInfoMethod(users));
        return (Map)this.readValue(retNode, "users", new TypeReference<Map<String, DndSimpleInfo>>(){});
    }

    @Override
    public Map<String, String> getEmojiList() {
        JsonNode retNode = this.call(new EmojiListMethod());
        return (Map)this.readValue(retNode, "emoji", new TypeReference<Map<String, String>>(){});
    }

    @Override
    public Comment addFileComment(String file, String comment) {
        JsonNode retNode = this.call(new FileCommentAddMethod(file, comment));
        return this.readValue(retNode, "comment", Comment.class);
    }

    @Override
    public Comment editFileComment(String file, String id, String comment) {
        JsonNode retNode = this.call(new FileCommentEditMethod(file, id, comment));
        return this.readValue(retNode, "comment", Comment.class);
    }

    @Override
    public boolean deleteFileComment(String file, String id) {
        return this.isOk(new FileCommentDeleteMethod(file, id));
    }

    @Override
    public boolean deleteFile(String file) {
        return this.isOk(new FileDeleteMethod(file));
    }

    @Override
    public FileInfo getFileInfo(String file) {
        return this.getFileInfo(file, 1);
    }

    @Override
    public FileInfo getFileInfo(String file, int page) {
        return this.getFileInfo(file, page, 100);
    }

    @Override
    public FileInfo getFileInfo(String file, int page, int count) {
        FileInfoMethod method = new FileInfoMethod(file);
        method.setPage(page);
        method.setCount(count);
        JsonNode retNode = this.call(method);
        return this.readValue(retNode, null, FileInfo.class);
    }

    @Override
    public FileList getFileList() {
        return this.getFileList(null, null, null, null, 1, 100);
    }

    @Override
    public FileList getFileList(int page) {
        return this.getFileList(null, null, null, null, page, 100);
    }

    @Override
    public FileList getFileList(int page, int count) {
        return this.getFileList(null, null, null, null, page, count);
    }

    @Override
    public FileList getFileList(String user) {
        return this.getFileList(user, null, null, null, 1, 100);
    }

    @Override
    public FileList getFileList(String user, int page) {
        return this.getFileList(user, null, null, null, page, 100);
    }

    @Override
    public FileList getFileList(String user, int page, int count) {
        return this.getFileList(user, null, null, null, page, count);
    }

    @Override
    public FileList getFileList(String user, String ts_from, String ts_to, String types, int page, int count) {
        FileListMethod method = new FileListMethod();
        method.setUser(user);
        method.setTs_from(ts_from);
        method.setTs_to(ts_to);
        method.setTypes(types);
        method.setPage(page);
        method.setCount(count);
        JsonNode retNode = this.call(method);
        return this.readValue(retNode, null, FileList.class);
    }

    @Override
    public flowctrl.integration.slack.type.File uploadFile(File file, String title, String initial_comment, String channels) {
        String filename = file.getName();
        String filetype = null;
        int i = filename.lastIndexOf(46);
        if (i > 0) {
            filetype = filename.substring(i + 1);
        }
        return this.uploadFile(file, filetype, filename, title, initial_comment, channels);
    }

    @Override
    public flowctrl.integration.slack.type.File uploadFile(File file, String filetype, String filename, String title, String initial_comment, String channels) {
        try {
            return this.uploadFile(new FileInputStream(file), filetype, filename, title, initial_comment, channels);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public flowctrl.integration.slack.type.File uploadFile(InputStream is, String filetype, String filename, String title, String initial_comment, String channels) {
        FileUploadMethod method = new FileUploadMethod();
        method.setChannels(channels);
        method.setFilename(filename);
        method.setFiletype(filetype);
        method.setInitial_comment(initial_comment);
        method.setTitle(title);
        JsonNode retNode = this.call(method, is);
        return this.readValue(retNode, "file", flowctrl.integration.slack.type.File.class);
    }

    @Override
    public boolean archiveGroup(String channel) {
        return this.isOk(new GroupArchiveMethod(channel));
    }

    @Override
    public boolean closeGroup(String channel) {
        return this.isOk(new GroupCloseMethod(channel));
    }

    @Override
    public Group createGroup(String name) {
        JsonNode retNode = this.call(new GroupCreateMethod(name));
        return this.readValue(retNode, "group", Group.class);
    }

    @Override
    public Group createChildGroup(String name) {
        JsonNode retNode = this.call(new GroupCreateChildMethod(name));
        return this.readValue(retNode, "group", Group.class);
    }

    @Override
    public History getGroupHistory(String channel) {
        return this.getGroupHistory(channel, null, null, false, 100, false);
    }

    @Override
    public History getGroupHistory(String channel, int count) {
        return this.getGroupHistory(channel, null, null, false, count, false);
    }

    @Override
    public History getGroupHistory(String channel, String latest, String oldest, boolean inclusive, int count, boolean unreads) {
        GroupHistoryMethod channelHistoryMethod = new GroupHistoryMethod(channel);
        channelHistoryMethod.setLatest(latest);
        channelHistoryMethod.setOldest(oldest);
        channelHistoryMethod.setInclusive(inclusive);
        channelHistoryMethod.setCount(count);
        channelHistoryMethod.setUnreads(unreads);
        JsonNode retNode = this.call(channelHistoryMethod);
        return this.readValue(retNode, null, History.class);
    }

    @Override
    public Group getGroupInfo(String channel) {
        JsonNode retNode = this.call(new GroupInfoMethod(channel));
        return this.readValue(retNode, "group", Group.class);
    }

    @Override
    public Group inviteUserToGroup(String channel, String user) {
        JsonNode retNode = this.call(new GroupInviteMethod(channel, user));
        return this.readValue(retNode, "group", Group.class);
    }

    @Override
    public boolean kickUserFormGroup(String channel, String user) {
        return this.isOk(new GroupKickMethod(channel, user));
    }

    @Override
    public boolean leaveGroup(String channel) {
        return this.isOk(new GroupLeaveMethod(channel));
    }

    @Override
    public List<Group> getGroupList() {
        return this.getGroupList(false);
    }

    @Override
    public List<Group> getGroupList(boolean exclude_archived) {
        JsonNode retNode = this.call(new GroupListMethod(exclude_archived));
        return (List)this.readValue(retNode, "groups", new TypeReference<List<Group>>(){});
    }

    @Override
    public boolean markGroup(String channel, String ts) {
        return this.isOk(new GroupMarkMethod(channel, ts));
    }

    @Override
    public boolean openGroup(String channel) {
        return this.isOk(new GroupOpenMethod(channel));
    }

    @Override
    public Group renameGroup(String channel, String name) {
        JsonNode retNode = this.call(new GroupRenameMethod(channel, name));
        return this.readValue(retNode, "channel", Group.class);
    }

    @Override
    public boolean setGroupPurpose(String channel, String purpose) {
        return this.isOk(new GroupSetPurposeMethod(channel, purpose));
    }

    @Override
    public boolean setGroupTopic(String channel, String topic) {
        return this.isOk(new GroupSetTopicMethod(channel, topic));
    }

    @Override
    public boolean unarchiveGroup(String channel) {
        return this.isOk(new GroupUnarchiveMethod(channel));
    }

    @Override
    public boolean closeDirectMessageChannel(String channel) {
        return this.isOk(new ImCloseMethod(channel));
    }

    @Override
    public History getDirectMessageChannelHistory(String channel) {
        return this.getDirectMessageChannelHistory(channel, null, null, false, 100, false);
    }

    @Override
    public History getDirectMessageChannelHistory(String channel, int count) {
        return this.getDirectMessageChannelHistory(channel, null, null, false, count, false);
    }

    @Override
    public History getDirectMessageChannelHistory(String channel, String latest, String oldest, boolean inclusive, int count, boolean unreads) {
        ImHistoryMethod imHistoryMethod = new ImHistoryMethod(channel);
        imHistoryMethod.setLatest(latest);
        imHistoryMethod.setOldest(oldest);
        imHistoryMethod.setInclusive(inclusive);
        imHistoryMethod.setCount(count);
        imHistoryMethod.setUnreads(unreads);
        JsonNode retNode = this.call(imHistoryMethod);
        return this.readValue(retNode, null, History.class);
    }

    @Override
    public List<DirectMessageChannel> getDirectMessageChannelList() {
        JsonNode retNode = this.call(new ImListMethod());
        return (List)this.readValue(retNode, "ims", new TypeReference<List<DirectMessageChannel>>(){});
    }

    @Override
    public boolean markDirectMessageChannel(String channel, String ts) {
        return this.isOk(new ImMarkMethod(channel, ts));
    }

    @Override
    public String openDirectMessageChannel(String user) {
        JsonNode retNode = this.call(new ImOpenMethod(user));
        return retNode.findPath("channel").findPath("id").asText();
    }

    @Override
    public boolean closeMultipartyDirectMessageChannel(String channel) {
        return this.isOk(new MpimCloseMethod(channel));
    }

    @Override
    public History getMultipartyDirectMessageChannelHistory(String channel) {
        return this.getMultipartyDirectMessageChannelHistory(channel, null, null, false, 100, false);
    }

    @Override
    public History getMultipartyDirectMessageChannelHistory(String channel, int count) {
        return this.getMultipartyDirectMessageChannelHistory(channel, null, null, false, count, false);
    }

    @Override
    public History getMultipartyDirectMessageChannelHistory(String channel, String latest, String oldest, boolean inclusive, int count, boolean unreads) {
        MpimHistoryMethod mpimHistoryMethod = new MpimHistoryMethod(channel);
        mpimHistoryMethod.setLatest(latest);
        mpimHistoryMethod.setOldest(oldest);
        mpimHistoryMethod.setInclusive(inclusive);
        mpimHistoryMethod.setCount(count);
        mpimHistoryMethod.setUnreads(unreads);
        JsonNode retNode = this.call(mpimHistoryMethod);
        return this.readValue(retNode, null, History.class);
    }

    @Override
    public List<Group> getMultipartyDirectMessageChannelList() {
        JsonNode retNode = this.call(new MpimListMethod());
        return (List)this.readValue(retNode, "groups", new TypeReference<List<Group>>(){});
    }

    @Override
    public boolean markMultipartyDirectMessageChannel(String channel, String ts) {
        return this.isOk(new MpimMarkMethod(channel, ts));
    }

    @Override
    public Group openMultipartyDirectMessageChannel(String ... users) {
        return this.openMultipartyDirectMessageChannel(Arrays.asList(users));
    }

    @Override
    public Group openMultipartyDirectMessageChannel(List<String> users) {
        JsonNode retNode = this.call(new MpimOpenMethod(users));
        return this.readValue(retNode, "group", Group.class);
    }

    @Override
    public OAuthAccessToken accessOAuth(String client_id, String client_secret, String code, String redirect_uri) {
        OAuthAccessMethod method = new OAuthAccessMethod(client_id, client_secret, code);
        method.setRedirect_uri(redirect_uri);
        JsonNode retNode = this.call(method);
        return this.readValue(retNode, null, OAuthAccessToken.class);
    }

    @Override
    public boolean pinFile(String channel, String file) {
        PinsAddMethod method = new PinsAddMethod(channel);
        method.setFile(file);
        return this.isOk(method);
    }

    @Override
    public boolean pinFileComment(String channel, String file_comment) {
        PinsAddMethod method = new PinsAddMethod(channel);
        method.setFile_comment(file_comment);
        return this.isOk(method);
    }

    @Override
    public boolean pinMessage(String channel, String timestamp) {
        PinsAddMethod method = new PinsAddMethod(channel);
        method.setTimestamp(timestamp);
        return this.isOk(method);
    }

    @Override
    public List<PinItem> getPinList(String channel) {
        JsonNode retNode = this.call(new PinsListMethod(channel));
        return (List)this.readValue(retNode, "items", new TypeReference<List<PinItem>>(){});
    }

    @Override
    public boolean unpinFile(String channel, String file) {
        PinsRemoveMethod method = new PinsRemoveMethod(channel);
        method.setFile(file);
        return this.isOk(method);
    }

    @Override
    public boolean unpinFileComment(String channel, String file_comment) {
        PinsRemoveMethod method = new PinsRemoveMethod(channel);
        method.setFile_comment(file_comment);
        return this.isOk(method);
    }

    @Override
    public boolean unpinMessage(String channel, String timestamp) {
        PinsRemoveMethod method = new PinsRemoveMethod(channel);
        method.setTimestamp(timestamp);
        return this.isOk(method);
    }

    @Override
    public boolean addReactionToFile(String emojiName, String file) {
        ReactionsAddMethod method = new ReactionsAddMethod(emojiName);
        method.setFile(file);
        return this.isOk(method);
    }

    @Override
    public boolean addReactionToFileComment(String emojiName, String file_comment) {
        ReactionsAddMethod method = new ReactionsAddMethod(emojiName);
        method.setFile_comment(file_comment);
        return this.isOk(method);
    }

    @Override
    public boolean addReactionToMessage(String emojiName, String channel, String timestamp) {
        ReactionsAddMethod method = new ReactionsAddMethod(emojiName);
        method.setChannel(channel);
        method.setTimestamp(timestamp);
        return this.isOk(method);
    }

    @Override
    public ReactionItem getReactionByFile(String emojiName, String file) {
        ReactionsGetMethod method = new ReactionsGetMethod(emojiName);
        method.setFile(file);
        JsonNode retNode = this.call(method);
        return this.readValue(retNode, null, ReactionItem.class);
    }

    @Override
    public ReactionItem getReactionByFileComment(String emojiName, String file_comment) {
        ReactionsGetMethod method = new ReactionsGetMethod(emojiName);
        method.setFile_comment(file_comment);
        JsonNode retNode = this.call(method);
        return this.readValue(retNode, null, ReactionItem.class);
    }

    @Override
    public ReactionItem getReactionByMessage(String emojiName, String channel, String timestamp) {
        ReactionsGetMethod method = new ReactionsGetMethod(emojiName);
        method.setChannel(channel);
        method.setTimestamp(timestamp);
        JsonNode retNode = this.call(method);
        return this.readValue(retNode, null, ReactionItem.class);
    }

    @Override
    public ReactionList getReactionList(int page) {
        return this.getReactionList(page, 100);
    }

    @Override
    public ReactionList getReactionList(int page, int count) {
        return this.getReactionList(null, page, count);
    }

    @Override
    public ReactionList getReactionList(String user, int page) {
        return this.getReactionList(user, page, 100);
    }

    @Override
    public ReactionList getReactionList(String user, int page, int count) {
        ReactionsListMethod method = new ReactionsListMethod();
        method.setUser(user);
        method.setPage(page);
        method.setCount(count);
        JsonNode retNode = this.call(method);
        return this.readValue(retNode, null, ReactionList.class);
    }

    @Override
    public boolean removeReactionFromFile(String emojiName, String file) {
        ReactionsRemoveMethod method = new ReactionsRemoveMethod(emojiName);
        method.setFile(file);
        return this.isOk(method);
    }

    @Override
    public boolean removeReactionFromFileComment(String emojiName, String file_comment) {
        ReactionsRemoveMethod method = new ReactionsRemoveMethod(emojiName);
        method.setFile_comment(file_comment);
        return this.isOk(method);
    }

    @Override
    public boolean removeReactionFromMessage(String emojiName, String channel, String timestamp) {
        ReactionsRemoveMethod method = new ReactionsRemoveMethod(emojiName);
        method.setChannel(channel);
        method.setTimestamp(timestamp);
        return this.isOk(method);
    }

    @Override
    public String startRealTimeMessagingApi() {
        return this.startRealTimeMessagingApi(null, null, null);
    }

    @Override
    public String startRealTimeMessagingApi(String simple_latest, String no_unreads, String mpim_aware) {
        RtmStartMethod method = new RtmStartMethod();
        method.setSimple_latest(simple_latest);
        method.setNo_unreads(no_unreads);
        method.setMpim_aware(mpim_aware);
        JsonNode retNode = this.call(method);
        return retNode.findPath("url").asText();
    }

    @Override
    public boolean addStarToFile(String file) {
        StarsAddMethod method = new StarsAddMethod();
        method.setFile(file);
        return this.isOk(method);
    }

    @Override
    public boolean addStarToFileComment(String file_comment) {
        StarsAddMethod method = new StarsAddMethod();
        method.setFile_comment(file_comment);
        return this.isOk(method);
    }

    @Override
    public boolean addStarToMessage(String channel, String timestamp) {
        StarsAddMethod method = new StarsAddMethod();
        method.setChannel(channel);
        method.setTimestamp(timestamp);
        return this.isOk(method);
    }

    @Override
    public StarList getStarList(int page) {
        return this.getStarList(page, 100);
    }

    @Override
    public StarList getStarList(int page, int count) {
        return this.getStarList(null, page, count);
    }

    @Override
    public StarList getStarList(String user, int page) {
        return this.getStarList(user, page, 100);
    }

    @Override
    public StarList getStarList(String user, int page, int count) {
        StarsListMethod method = new StarsListMethod();
        method.setUser(user);
        method.setPage(page);
        method.setCount(count);
        JsonNode retNode = this.call(method);
        return this.readValue(retNode, null, StarList.class);
    }

    @Override
    public boolean removeStarFromFile(String file) {
        StarsRemoveMethod method = new StarsRemoveMethod();
        method.setFile(file);
        return this.isOk(method);
    }

    @Override
    public boolean removeStarFromFileComment(String file_comment) {
        StarsRemoveMethod method = new StarsRemoveMethod();
        method.setFile_comment(file_comment);
        return this.isOk(method);
    }

    @Override
    public boolean removeStarFromMessage(String channel, String timestamp) {
        StarsRemoveMethod method = new StarsRemoveMethod();
        method.setChannel(channel);
        method.setTimestamp(timestamp);
        return this.isOk(method);
    }

    @Override
    public TeamAccessLogList getTeamAccessLogList(int page) {
        return this.getTeamAccessLogList(page, 100);
    }

    @Override
    public TeamAccessLogList getTeamAccessLogList(int page, int count) {
        TeamAccessLogsMethod method = new TeamAccessLogsMethod();
        method.setPage(page);
        method.setCount(count);
        JsonNode retNode = this.call(method);
        return this.readValue(retNode, null, TeamAccessLogList.class);
    }

    @Override
    public Team getTeamInfo() {
        JsonNode retNode = this.call(new TeamInfoMethod());
        return this.readValue(retNode, "team", Team.class);
    }

    @Override
    public TeamIntegrationLogList getTeamIntegrationLogList(int page) {
        return this.getTeamIntegrationLogList(null, null, null, null, page, 100);
    }

    @Override
    public TeamIntegrationLogList getTeamIntegrationLogList(int page, int count) {
        return this.getTeamIntegrationLogList(null, null, null, null, page, count);
    }

    @Override
    public TeamIntegrationLogList getTeamIntegrationLogList(String service_id, String app_id, String user, String change_type, int page, int count) {
        TeamIntegrationLogMethod method = new TeamIntegrationLogMethod();
        method.setService_id(service_id);
        method.setApp_id(app_id);
        method.setUser(user);
        method.setChange_type(change_type);
        method.setPage(page);
        method.setCount(count);
        JsonNode retNode = this.call(method);
        return this.readValue(retNode, null, TeamIntegrationLogList.class);
    }

    @Override
    public Usergroup createUsergroup(String name, String handle, String description, List<String> channels) {
        return this.createUsergroup(name, handle, description, channels, true);
    }

    @Override
    public Usergroup createUsergroup(String name, String handle, String description, List<String> channels, boolean include_count) {
        UsergroupsCreateMethod method = new UsergroupsCreateMethod(name);
        method.setHandle(handle);
        method.setDescription(description);
        method.setChannels(channels);
        method.setInclude_count(include_count);
        JsonNode retNode = this.call(method);
        return this.readValue(retNode, "usergroup", Usergroup.class);
    }

    @Override
    public Usergroup disableUsergroup(String usergroup) {
        return this.disableUsergroup(usergroup, true);
    }

    @Override
    public Usergroup disableUsergroup(String usergroup, boolean include_count) {
        UsergroupsDisableMethod method = new UsergroupsDisableMethod(usergroup);
        method.setInclude_count(include_count);
        JsonNode retNode = this.call(method);
        return this.readValue(retNode, "usergroup", Usergroup.class);
    }

    @Override
    public Usergroup enableUsergroup(String usergroup) {
        return this.enableUsergroup(usergroup, true);
    }

    @Override
    public Usergroup enableUsergroup(String usergroup, boolean include_count) {
        UsergroupsEnableMethod method = new UsergroupsEnableMethod(usergroup);
        method.setInclude_count(include_count);
        JsonNode retNode = this.call(method);
        return this.readValue(retNode, "usergroup", Usergroup.class);
    }

    @Override
    public List<Usergroup> getUsergroupList() {
        return this.getUsergroupList(true, true, true);
    }

    @Override
    public List<Usergroup> getUsergroupList(boolean include_disabled, boolean include_count, boolean include_users) {
        UsergroupsListMethod method = new UsergroupsListMethod();
        method.setInclude_disabled(include_disabled);
        method.setInclude_count(include_count);
        method.setInclude_users(include_users);
        JsonNode retNode = this.call(method);
        return (List)this.readValue(retNode, "usergroup", new TypeReference<List<Usergroup>>(){});
    }

    @Override
    public Usergroup updateUsergroup(String name, String handle, String description, List<String> channels) {
        return this.updateUsergroup(name, handle, description, channels, true);
    }

    @Override
    public Usergroup updateUsergroup(String name, String handle, String description, List<String> channels, boolean include_count) {
        UsergroupsUpdateMethod method = new UsergroupsUpdateMethod(name);
        method.setHandle(handle);
        method.setDescription(description);
        method.setChannels(channels);
        method.setInclude_count(include_count);
        JsonNode retNode = this.call(method);
        return this.readValue(retNode, "usergroup", Usergroup.class);
    }

    @Override
    public List<String> getUsergroupUserList(String usergroup) {
        return this.getUsergroupUserList(usergroup, false);
    }

    @Override
    public List<String> getUsergroupUserList(String usergroup, boolean include_disabled) {
        UsergroupsUsersListMethod method = new UsergroupsUsersListMethod(usergroup);
        JsonNode retNode = this.call(method);
        return (List)this.readValue(retNode, "users", new TypeReference<List<String>>(){});
    }

    @Override
    public Usergroup updateUsergroupUser(String usergroup, List<String> users) {
        return this.updateUsergroupUser(usergroup, users, true);
    }

    @Override
    public Usergroup updateUsergroupUser(String usergroup, List<String> users, boolean include_count) {
        UsergroupsUsersUpdateMethod method = new UsergroupsUsersUpdateMethod(usergroup, users);
        method.setInclude_count(include_count);
        JsonNode retNode = this.call(method);
        return this.readValue(retNode, "usergroup", Usergroup.class);
    }

    @Override
    public UserPresence getUserPresence(String user) {
        JsonNode retNode = this.call(new UserGetPresenceMethod(user));
        return this.readValue(retNode, null, UserPresence.class);
    }

    @Override
    public User getUserInfo(String user) {
        JsonNode retNode = this.call(new UserInfoMethod(user));
        return this.readValue(retNode, "user", User.class);
    }

    @Override
    public List<User> getUserList() {
        JsonNode retNode = this.call(new UserListMethod());
        return (List)this.readValue(retNode, "members", new TypeReference<List<User>>(){});
    }

    @Override
    public List<User> getUserListWithPresence() {
        JsonNode retNode = this.call(new UserListMethod("1"));
        return (List)this.readValue(retNode, "members", new TypeReference<List<User>>(){});
    }

    @Override
    public boolean setActiveUser() {
        return this.isOk(new UserSetActiveMethod());
    }

    @Override
    public boolean setPresenceUser(Presence presence) {
        if (presence == null) {
            throw new SlackArgumentException("invalid presence(auto|away)");
        }
        return this.isOk(new UserSetPresenceMethod(presence.name().toLowerCase()));
    }

    protected boolean isOk(SlackMethod method) {
        JsonNode retNode = this.call(method);
        return retNode.findPath("ok").asBoolean();
    }

    protected <T> T readValue(JsonNode node, String findPath, Class<T> valueType) {
        try {
            if (findPath != null) {
                node = node.findPath(findPath);
            }
            return (T)this.mapper.readValue(node.toString(), valueType);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected <T> T readValue(JsonNode node, String findPath, TypeReference<?> typeReference) {
        try {
            if (findPath != null) {
                node = node.findPath(findPath);
            }
            return (T)this.mapper.readValue(node.toString(), typeReference);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected JsonNode call(SlackMethod method) {
        return this.call(method, null);
    }

    protected JsonNode call(SlackMethod method, InputStream is) {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        method.validate(errors);
        if (errors.size() > 0) {
            StringBuffer sb = new StringBuffer("*** slack argument error ***");
            for (ValidationError error : errors) {
                if (sb.length() > 0) {
                    sb.append("\n");
                }
                if (error.getDescription() != null) {
                    sb.append(error.getDescription());
                    continue;
                }
                if (error.getProblem() != Problem.REQUIRED) continue;
                sb.append("\"" + error.getField() + "\" is required.");
            }
            throw new SlackArgumentException(sb.toString());
        }
        Map<String, String> parameters = method.getParameters();
        if (method.isRequiredToken()) {
            parameters.put("token", this.token);
        }
        String apiUrl = "https://slack.com/api/" + method.getMethodName();
        HttpEntity httpEntity = null;
        httpEntity = is == null ? RestUtils.createUrlEncodedFormEntity(parameters) : RestUtils.createMultipartFormEntity(parameters, is);
        String retContent = RestUtils.execute(this.httpClient, apiUrl, httpEntity);
        JsonNode retNode = null;
        try {
            retNode = this.mapper.readTree(retContent);
        }
        catch (IOException e) {
            throw new SlackException(e);
        }
        boolean retOk = retNode.findPath("ok").asBoolean();
        if (!retOk) {
            String error = retNode.findPath("error").asText();
            throw new SlackResponseErrorException(error + ". check the link " + "https://api.slack.com/methods" + "/" + method.getMethodName());
        }
        return retNode;
    }
}

