/*
 * Decompiled with CFR 0.152.
 */
package flowctrl.integration.slack.type;

import com.fasterxml.jackson.annotation.JsonInclude;
import flowctrl.integration.slack.exception.SlackArgumentException;
import flowctrl.integration.slack.type.Attachment;
import flowctrl.integration.slack.validation.SlackFieldValidationUtils;
import java.util.ArrayList;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class Payload {
    protected String username;
    protected String text;
    protected String icon_url;
    protected String icon_emoji;
    protected String channel;
    protected List<Attachment> attachments;
    protected Boolean unfurl_links;
    protected Boolean unfurl_media;
    protected Boolean mrkdwn;

    public Boolean getMrkdwn() {
        return this.mrkdwn;
    }

    public void setMrkdwn(Boolean mrkdwn) {
        this.mrkdwn = mrkdwn;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getIcon_url() {
        return this.icon_url;
    }

    public void setIcon_url(String icon_url) {
        SlackFieldValidationUtils.validUrl(icon_url, "icon_url");
        this.icon_url = icon_url;
    }

    public String getIcon_emoji() {
        return this.icon_emoji;
    }

    public void setIcon_emoji(String icon_emoji) {
        if (!(icon_emoji == null || icon_emoji.startsWith(":") && icon_emoji.endsWith(":"))) {
            throw new SlackArgumentException("invalid icon_emoji. you should start and end with \":\". ex):sunny:");
        }
        this.icon_emoji = icon_emoji;
    }

    public String getChannel() {
        return this.channel;
    }

    public void setChannel(String channel) {
        if (channel != null && !channel.startsWith("#") && !channel.startsWith("@")) {
            throw new SlackArgumentException("invalid channel. you should start with \"#\" or \"@\". ex)#channelname, @username");
        }
        this.channel = channel;
    }

    public void addAttachment(Attachment attachment) {
        this.getAttachments().add(attachment);
    }

    public List<Attachment> getAttachments() {
        if (this.attachments == null) {
            this.attachments = new ArrayList<Attachment>();
        }
        return this.attachments;
    }

    public void setAttachments(List<Attachment> attachments) {
        this.attachments = attachments;
    }

    public Boolean getUnfurl_links() {
        return this.unfurl_links;
    }

    public void setUnfurl_links(Boolean unfurl_links) {
        this.unfurl_links = unfurl_links;
    }

    public Boolean getUnfurl_media() {
        return this.unfurl_media;
    }

    public void setUnfurl_media(Boolean unfurl_media) {
        this.unfurl_media = unfurl_media;
    }

    public String toString() {
        return "SlackPayload [username=" + this.username + ", text=" + this.text + ", icon_url=" + this.icon_url + ", icon_emoji=" + this.icon_emoji + ", channel=" + this.channel + ", attachments=" + this.attachments + ", unfurl_links=" + this.unfurl_links + ", unfurl_media=" + this.unfurl_media + "]";
    }
}

