/*
 * Decompiled with CFR 0.152.
 */
package flowctrl.integration.slack.rtm;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.ProxyServer;
import com.ning.http.client.ws.DefaultWebSocketListener;
import com.ning.http.client.ws.WebSocket;
import com.ning.http.client.ws.WebSocketListener;
import com.ning.http.client.ws.WebSocketUpgradeHandler;
import flowctrl.integration.slack.exception.SlackException;
import flowctrl.integration.slack.rtm.Event;
import flowctrl.integration.slack.rtm.EventListener;
import flowctrl.integration.slack.rtm.ProxyServerInfo;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SlackRealTimeMessagingClient {
    private static Log logger = LogFactory.getLog(SlackRealTimeMessagingClient.class);
    private String webSocketUrl;
    private ProxyServerInfo proxyServerInfo;
    private AsyncHttpClient asyncHttpClient;
    private WebSocket webSocket;
    private Map<String, List<EventListener>> listeners = new HashMap<String, List<EventListener>>();
    private boolean stop;
    private ObjectMapper mapper;

    public SlackRealTimeMessagingClient(String webSocketUrl, ObjectMapper mapper) {
        this(webSocketUrl, null, mapper);
    }

    public SlackRealTimeMessagingClient(String webSocketUrl, ProxyServerInfo proxyServerInfo, ObjectMapper mapper) {
        if (mapper == null) {
            mapper = new ObjectMapper();
        }
        this.webSocketUrl = webSocketUrl;
        this.proxyServerInfo = proxyServerInfo;
        this.mapper = mapper;
    }

    public void addListener(Event event, EventListener listener) {
        this.addListener(event.name().toLowerCase(), listener);
    }

    public void addListener(String event, EventListener listener) {
        List<EventListener> eventListeners = this.listeners.get(event);
        if (eventListeners == null) {
            eventListeners = new ArrayList<EventListener>();
            this.listeners.put(event, eventListeners);
        }
        eventListeners.add(listener);
    }

    public void close() {
        this.stop = true;
        if (this.webSocket != null && this.webSocket.isOpen()) {
            this.webSocket.close();
        }
        if (this.asyncHttpClient != null && !this.asyncHttpClient.isClosed()) {
            this.asyncHttpClient.close();
        }
    }

    public boolean connect() {
        AsyncHttpClientConfig.Builder builder = new AsyncHttpClientConfig.Builder();
        if (this.proxyServerInfo != null) {
            ProxyServer.Protocol protocol = null;
            for (ProxyServer.Protocol p : ProxyServer.Protocol.values()) {
                if (!p.getProtocol().equalsIgnoreCase(this.proxyServerInfo.getProtocol())) continue;
                protocol = p;
            }
            if (protocol == null) {
                protocol = ProxyServer.Protocol.HTTP;
            }
            builder.setProxyServer(new ProxyServer(protocol, this.proxyServerInfo.getHost(), this.proxyServerInfo.getPort()));
            builder.setUseProxyProperties(true);
        }
        AsyncHttpClientConfig clientConfig = builder.build();
        this.asyncHttpClient = new AsyncHttpClient(clientConfig);
        AsyncHttpClient.BoundRequestBuilder requestBuilder = this.asyncHttpClient.prepareGet(this.webSocketUrl);
        try {
            this.webSocket = (WebSocket)requestBuilder.execute((AsyncHandler)new WebSocketUpgradeHandler.Builder().addWebSocketListener((WebSocketListener)new DefaultWebSocketListener(){

                public void onClose(WebSocket websocket) {
                    super.onClose(websocket);
                    SlackRealTimeMessagingClient.this.stop = true;
                }

                public void onPing(byte[] message) {
                    ObjectNode pongMessage = SlackRealTimeMessagingClient.this.mapper.createObjectNode();
                    pongMessage.set("type", (JsonNode)TextNode.valueOf((String)"pong"));
                    pongMessage.set("time", (JsonNode)LongNode.valueOf((long)new Date().getTime()));
                    logger.info((Object)("pong message : " + pongMessage));
                    this.webSocket.sendPong(pongMessage.toString().getBytes());
                }

                public void onError(Throwable t) {
                    throw new SlackException(t);
                }

                public void onMessage(String message) {
                    List eventListeners;
                    logger.info((Object)("Slack RTM message : " + message));
                    String type = null;
                    JsonNode node = null;
                    try {
                        node = SlackRealTimeMessagingClient.this.mapper.readTree(message);
                        type = node.findPath("type").asText();
                    }
                    catch (Exception e) {
                        logger.error((Object)e);
                    }
                    if (type != null && (eventListeners = (List)SlackRealTimeMessagingClient.this.listeners.get(type)) != null && !eventListeners.isEmpty()) {
                        for (EventListener listener : eventListeners) {
                            listener.handleMessage(node);
                        }
                    }
                }
            }).build()).get();
            logger.info((Object)("connected Slack RTM(Real Time Messaging) server : " + this.webSocketUrl));
            this.await();
        }
        catch (Exception e) {
            throw new SlackException(e);
        }
        return true;
    }

    private void await() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (!SlackRealTimeMessagingClient.this.stop) {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (Exception e) {
                        throw new SlackException(e);
                    }
                }
            }
        });
        thread.start();
    }
}

