/*
 * Decompiled with CFR 0.152.
 */
package com.github.florent37.shapeofview.shapes;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Path;
import android.graphics.RectF;
import android.util.AttributeSet;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.github.florent37.shapeofview.R;
import com.github.florent37.shapeofview.ShapeOfView;
import com.github.florent37.shapeofview.manager.ClipPathManager;

public class CutCornerView
extends ShapeOfView {
    private final RectF rectF = new RectF();
    private float topLeftCutSizePx = 0.0f;
    private float topRightCutSizePx = 0.0f;
    private float bottomRightCutSizePx = 0.0f;
    private float bottomLeftCutSizePx = 0.0f;

    public CutCornerView(@NonNull Context context) {
        super(context);
        this.init(context, null);
    }

    public CutCornerView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public CutCornerView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        if (attrs != null) {
            TypedArray attributes = context.obtainStyledAttributes(attrs, R.styleable.CutCornerView);
            this.topLeftCutSizePx = attributes.getDimensionPixelSize(R.styleable.CutCornerView_shape_cutCorner_topLeftSize, (int)this.topLeftCutSizePx);
            this.topRightCutSizePx = attributes.getDimensionPixelSize(R.styleable.CutCornerView_shape_cutCorner_topRightSize, (int)this.topRightCutSizePx);
            this.bottomLeftCutSizePx = attributes.getDimensionPixelSize(R.styleable.CutCornerView_shape_cutCorner_bottomLeftSize, (int)this.bottomLeftCutSizePx);
            this.bottomRightCutSizePx = attributes.getDimensionPixelSize(R.styleable.CutCornerView_shape_cutCorner_bottomRightSize, (int)this.bottomRightCutSizePx);
            attributes.recycle();
        }
        super.setClipPathCreator(new ClipPathManager.ClipPathCreator(){

            @Override
            public Path createClipPath(int width, int height) {
                CutCornerView.this.rectF.set(0.0f, 0.0f, (float)width, (float)height);
                return CutCornerView.this.generatePath(CutCornerView.this.rectF, CutCornerView.this.topLeftCutSizePx, CutCornerView.this.topRightCutSizePx, CutCornerView.this.bottomRightCutSizePx, CutCornerView.this.bottomLeftCutSizePx);
            }

            @Override
            public boolean requiresBitmap() {
                return false;
            }
        });
    }

    private Path generatePath(RectF rect, float topLeftDiameter, float topRightDiameter, float bottomRightDiameter, float bottomLeftDiameter) {
        Path path = new Path();
        topLeftDiameter = topLeftDiameter < 0.0f ? 0.0f : topLeftDiameter;
        topRightDiameter = topRightDiameter < 0.0f ? 0.0f : topRightDiameter;
        bottomLeftDiameter = bottomLeftDiameter < 0.0f ? 0.0f : bottomLeftDiameter;
        bottomRightDiameter = bottomRightDiameter < 0.0f ? 0.0f : bottomRightDiameter;
        path.moveTo(rect.left + topLeftDiameter, rect.top);
        path.lineTo(rect.right - topRightDiameter, rect.top);
        path.lineTo(rect.right, rect.top + topRightDiameter);
        path.lineTo(rect.right, rect.bottom - bottomRightDiameter);
        path.lineTo(rect.right - bottomRightDiameter, rect.bottom);
        path.lineTo(rect.left + bottomLeftDiameter, rect.bottom);
        path.lineTo(rect.left, rect.bottom - bottomLeftDiameter);
        path.lineTo(rect.left, rect.top + topLeftDiameter);
        path.lineTo(rect.left + topLeftDiameter, rect.top);
        path.close();
        return path;
    }

    public float getTopLeftCutSize() {
        return this.topLeftCutSizePx;
    }

    public void setTopLeftCutSize(float topLeftCutSize) {
        this.topLeftCutSizePx = topLeftCutSize;
        this.requiresShapeUpdate();
    }

    public float getTopLeftCutSizeDp() {
        return this.pxToDp(this.getTopLeftCutSize());
    }

    public void setTopLeftCutSizeDp(float topLeftCutSize) {
        this.setTopLeftCutSize(this.dpToPx(topLeftCutSize));
    }

    public float getTopRightCutSize() {
        return this.topRightCutSizePx;
    }

    public void setTopRightCutSize(float topRightCutSize) {
        this.topRightCutSizePx = topRightCutSize;
        this.requiresShapeUpdate();
    }

    public float getTopRightCutSizeDp() {
        return this.pxToDp(this.getTopRightCutSize());
    }

    public void setTopRightCutSizeDp(float topRightCutSize) {
        this.setTopRightCutSize(this.dpToPx(topRightCutSize));
    }

    public float getBottomRightCutSize() {
        return this.bottomRightCutSizePx;
    }

    public void setBottomRightCutSize(float bottomRightCutSize) {
        this.bottomRightCutSizePx = bottomRightCutSize;
        this.requiresShapeUpdate();
    }

    public float getBottomRightCutSizeDp() {
        return this.pxToDp(this.getBottomRightCutSize());
    }

    public void setBottomRightCutSizeDp(float bottomRightCutSize) {
        this.setBottomRightCutSize(this.dpToPx(bottomRightCutSize));
    }

    public float getBottomLeftCutSize() {
        return this.bottomLeftCutSizePx;
    }

    public void setBottomLeftCutSize(float bottomLeftCutSize) {
        this.bottomLeftCutSizePx = bottomLeftCutSize;
        this.requiresShapeUpdate();
    }

    public float getBottomLeftCutSizeDp() {
        return this.pxToDp(this.getBottomLeftCutSize());
    }

    public void setBottomLeftCutSizeDp(float bottomLeftCutSize) {
        this.setBottomLeftCutSize(this.dpToPx(bottomLeftCutSize));
    }
}

