/*
 * Decompiled with CFR 0.152.
 */
package com.github.florent37.shapeofview.shapes;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Path;
import android.graphics.RectF;
import android.util.AttributeSet;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.github.florent37.shapeofview.R;
import com.github.florent37.shapeofview.ShapeOfView;
import com.github.florent37.shapeofview.manager.ClipPathManager;

public class DottedEdgesCutCornerView
extends ShapeOfView {
    public static final int POSITION_NONE = 0;
    public static final int POSITION_BOTTOM = 1;
    public static final int POSITION_TOP = 2;
    public static final int POSITION_LEFT = 4;
    public static final int POSITION_RIGHT = 8;
    private final RectF rectF = new RectF();
    private float topLeftCutSize = 0.0f;
    private float topRightCutSize = 0.0f;
    private float bottomRightCutSize = 0.0f;
    private float bottomLeftCutSize = 0.0f;
    private int dotEdgePosition;
    private float dotRadius = 0.0f;
    private float dotSpacing = 0.0f;

    public DottedEdgesCutCornerView(@NonNull Context context) {
        super(context);
        this.init(context, null);
    }

    public DottedEdgesCutCornerView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public DottedEdgesCutCornerView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        if (attrs != null) {
            TypedArray attributes = context.obtainStyledAttributes(attrs, R.styleable.DottedEdgesCutCornerView);
            this.topLeftCutSize = attributes.getDimensionPixelSize(R.styleable.DottedEdgesCutCornerView_shape_dottedEdgesCutCorner_topLeftSize, (int)this.topLeftCutSize);
            this.topRightCutSize = attributes.getDimensionPixelSize(R.styleable.DottedEdgesCutCornerView_shape_dottedEdgesCutCorner_topRightSize, (int)this.topRightCutSize);
            this.bottomLeftCutSize = attributes.getDimensionPixelSize(R.styleable.DottedEdgesCutCornerView_shape_dottedEdgesCutCorner_bottomLeftSize, (int)this.bottomLeftCutSize);
            this.bottomRightCutSize = attributes.getDimensionPixelSize(R.styleable.DottedEdgesCutCornerView_shape_dottedEdgesCutCorner_bottomRightSize, (int)this.bottomRightCutSize);
            this.dotEdgePosition = attributes.getInteger(R.styleable.DottedEdgesCutCornerView_shape_edge_position, 0);
            this.dotRadius = attributes.getDimensionPixelSize(R.styleable.DottedEdgesCutCornerView_shape_dot_radius, (int)this.dotRadius);
            this.dotSpacing = attributes.getDimensionPixelSize(R.styleable.DottedEdgesCutCornerView_shape_dot_spacing, (int)this.dotSpacing);
            attributes.recycle();
        }
        super.setClipPathCreator(new ClipPathManager.ClipPathCreator(){

            @Override
            public Path createClipPath(int width, int height) {
                DottedEdgesCutCornerView.this.rectF.set(0.0f, 0.0f, (float)width, (float)height);
                return DottedEdgesCutCornerView.this.generatePath(DottedEdgesCutCornerView.this.rectF, DottedEdgesCutCornerView.this.topLeftCutSize, DottedEdgesCutCornerView.this.topRightCutSize, DottedEdgesCutCornerView.this.bottomRightCutSize, DottedEdgesCutCornerView.this.bottomLeftCutSize);
            }

            @Override
            public boolean requiresBitmap() {
                return false;
            }
        });
    }

    private Path generatePath(RectF rect, float topLeftDiameter, float topRightDiameter, float bottomRightDiameter, float bottomLeftDiameter) {
        int y;
        int x;
        int count;
        Path path = new Path();
        topLeftDiameter = topLeftDiameter < 0.0f ? 0.0f : topLeftDiameter;
        topRightDiameter = topRightDiameter < 0.0f ? 0.0f : topRightDiameter;
        bottomLeftDiameter = bottomLeftDiameter < 0.0f ? 0.0f : bottomLeftDiameter;
        bottomRightDiameter = bottomRightDiameter < 0.0f ? 0.0f : bottomRightDiameter;
        path.moveTo(rect.left + topLeftDiameter, rect.top);
        if (this.containsFlag(2)) {
            count = 1;
            x = (int)(rect.left + topLeftDiameter + this.dotSpacing * (float)count + this.dotRadius * 2.0f * (float)(count - 1));
            while ((float)x + this.dotSpacing + this.dotRadius * 2.0f <= rect.right - topRightDiameter) {
                x = (int)(rect.left + topLeftDiameter + this.dotSpacing * (float)count + this.dotRadius * 2.0f * (float)(count - 1));
                path.lineTo((float)x, rect.top);
                path.quadTo((float)x + this.dotRadius, rect.top + this.dotRadius, (float)x + this.dotRadius * 2.0f, rect.top);
                ++count;
            }
            path.lineTo(rect.right - topRightDiameter, rect.top);
        } else {
            path.lineTo(rect.right - topRightDiameter, rect.top);
        }
        path.lineTo(rect.right, rect.top + topRightDiameter);
        if (this.containsFlag(8)) {
            path.lineTo(rect.right - this.dotRadius, rect.top + topRightDiameter);
            path.lineTo(rect.right - this.dotRadius, rect.bottom - bottomRightDiameter);
            path.lineTo(rect.right, rect.bottom - bottomRightDiameter);
            count = 1;
            y = (int)(rect.bottom - bottomRightDiameter - this.dotSpacing * (float)count - this.dotRadius * 2.0f * (float)(count - 1));
            while ((float)y - this.dotSpacing - this.dotRadius * 2.0f >= rect.top + topRightDiameter) {
                y = (int)(rect.bottom - bottomRightDiameter - this.dotSpacing * (float)count - this.dotRadius * 2.0f * (float)(count - 1));
                path.lineTo(rect.right, (float)y);
                path.quadTo(rect.right - this.dotRadius, (float)y - this.dotRadius, rect.right, (float)y - this.dotRadius * 2.0f);
                ++count;
            }
            path.lineTo(rect.right, rect.top + topRightDiameter);
            path.lineTo(rect.right - this.dotRadius, rect.top + topRightDiameter);
            path.lineTo(rect.right - this.dotRadius, rect.bottom - bottomRightDiameter);
            path.lineTo(rect.right, rect.bottom - bottomRightDiameter);
        } else {
            path.lineTo(rect.right, rect.bottom - bottomRightDiameter);
        }
        path.lineTo(rect.right - bottomRightDiameter, rect.bottom);
        if (this.containsFlag(1)) {
            count = 1;
            x = (int)(rect.right - bottomRightDiameter - this.dotSpacing * (float)count - this.dotRadius * 2.0f * (float)(count - 1));
            while ((float)x - this.dotSpacing - this.dotRadius * 2.0f >= rect.left + bottomLeftDiameter) {
                x = (int)(rect.right - bottomRightDiameter - this.dotSpacing * (float)count - this.dotRadius * 2.0f * (float)(count - 1));
                path.lineTo((float)x, rect.bottom);
                path.quadTo((float)x - this.dotRadius, rect.bottom - this.dotRadius, (float)x - this.dotRadius * 2.0f, rect.bottom);
                ++count;
            }
            path.lineTo(rect.left + bottomLeftDiameter, rect.bottom);
        } else {
            path.lineTo(rect.left + bottomLeftDiameter, rect.bottom);
        }
        path.lineTo(rect.left, rect.bottom - bottomLeftDiameter);
        if (this.containsFlag(4)) {
            count = 1;
            y = (int)(rect.bottom - bottomLeftDiameter - this.dotSpacing * (float)count - this.dotRadius * 2.0f * (float)(count - 1));
            while ((float)y - this.dotSpacing - this.dotRadius * 2.0f >= rect.top + topLeftDiameter) {
                y = (int)(rect.bottom - bottomLeftDiameter - this.dotSpacing * (float)count - this.dotRadius * 2.0f * (float)(count - 1));
                path.lineTo(rect.left, (float)y);
                path.quadTo(rect.left + this.dotRadius, (float)y - this.dotRadius, rect.left, (float)y - this.dotRadius * 2.0f);
                ++count;
            }
            path.lineTo(rect.left, rect.top + topLeftDiameter);
        } else {
            path.lineTo(rect.left, rect.top + topLeftDiameter);
        }
        path.lineTo(rect.left + topLeftDiameter, rect.top);
        path.close();
        return path;
    }

    private boolean containsFlag(int positionFlag) {
        return (this.dotEdgePosition | positionFlag) == this.dotEdgePosition;
    }

    public float getTopLeftCutSize() {
        return this.topLeftCutSize;
    }

    public void setTopLeftCutSize(float topLeftCutSize) {
        this.topLeftCutSize = topLeftCutSize;
        this.requiresShapeUpdate();
    }

    public float getTopLeftCutSizeDp() {
        return this.pxToDp(this.getTopLeftCutSize());
    }

    public void setTopLeftCutSizeDp(float topLeftCutSize) {
        this.setTopLeftCutSize(this.dpToPx(topLeftCutSize));
    }

    public float getTopRightCutSize() {
        return this.topRightCutSize;
    }

    public void setTopRightCutSize(float topRightCutSize) {
        this.topRightCutSize = topRightCutSize;
        this.requiresShapeUpdate();
    }

    public float getTopRightCutSizeDp() {
        return this.pxToDp(this.getTopRightCutSize());
    }

    public void setTopRightCutSizeDp(float topRightCutSize) {
        this.setTopRightCutSize(this.dpToPx(topRightCutSize));
    }

    public float getBottomRightCutSize() {
        return this.bottomRightCutSize;
    }

    public void setBottomRightCutSize(float bottomRightCutSize) {
        this.bottomRightCutSize = bottomRightCutSize;
        this.requiresShapeUpdate();
    }

    public float getBottomRightCutSizeDp() {
        return this.pxToDp(this.getBottomRightCutSize());
    }

    public void setBottomRightCutSizeDp(float bottomRightCutSize) {
        this.setBottomRightCutSize(this.dpToPx(bottomRightCutSize));
    }

    public float getBottomLeftCutSize() {
        return this.bottomLeftCutSize;
    }

    public void setBottomLeftCutSize(float bottomLeftCutSize) {
        this.bottomLeftCutSize = bottomLeftCutSize;
        this.requiresShapeUpdate();
    }

    public float getBottomLeftCutSizeDp() {
        return this.pxToDp(this.getBottomLeftCutSize());
    }

    public void setBottomLeftCutSizeDp(float bottomLeftCutSize) {
        this.setBottomLeftCutSize(this.dpToPx(bottomLeftCutSize));
    }

    public int getDotEdgePosition() {
        return this.dotEdgePosition;
    }

    public void addDotEdgePosition(int dotEdgePosition) {
        this.dotEdgePosition |= dotEdgePosition;
        this.requiresShapeUpdate();
    }

    public float getDotRadius() {
        return this.dotRadius;
    }

    public void setDotRadius(float dotRadius) {
        this.dotRadius = dotRadius;
        this.requiresShapeUpdate();
    }

    public float getDotRadiusDp() {
        return this.pxToDp(this.getDotRadius());
    }

    public void setDotRadiusDp(float dotRadius) {
        this.setDotRadius(this.dpToPx(dotRadius));
    }

    public float getDotSpacing() {
        return this.dotSpacing;
    }

    public void setDotSpacing(float dotSpacing) {
        this.dotSpacing = dotSpacing;
        this.requiresShapeUpdate();
    }

    public float getDotSpacingDp() {
        return this.pxToDp(this.dotSpacing);
    }

    public void setDotSpacingDp(float dotSpacing) {
        this.setDotRadius(this.dpToPx(dotSpacing));
    }
}

