/*
 * Decompiled with CFR 0.152.
 */
package com.github.florent37.shapeofview.shapes;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Path;
import android.util.AttributeSet;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.github.florent37.shapeofview.R;
import com.github.florent37.shapeofview.ShapeOfView;
import com.github.florent37.shapeofview.manager.ClipPathManager;

public class DiagonalView
extends ShapeOfView {
    public static final int POSITION_BOTTOM = 1;
    public static final int POSITION_TOP = 2;
    public static final int POSITION_LEFT = 3;
    public static final int POSITION_RIGHT = 4;
    public static final int DIRECTION_LEFT = 1;
    public static final int DIRECTION_RIGHT = 2;
    @DiagonalPosition
    private int diagonalPosition = 2;
    private int diagonalDirection = 2;
    private float diagonalAngle = 0.0f;

    public DiagonalView(@NonNull Context context) {
        super(context);
        this.init(context, null);
    }

    public DiagonalView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public DiagonalView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        if (attrs != null) {
            TypedArray attributes = context.obtainStyledAttributes(attrs, R.styleable.DiagonalView);
            this.diagonalAngle = attributes.getFloat(R.styleable.DiagonalView_shape_diagonal_angle, this.diagonalAngle);
            this.diagonalDirection = attributes.getInteger(R.styleable.DiagonalView_shape_diagonal_direction, this.diagonalDirection);
            this.diagonalPosition = attributes.getInteger(R.styleable.DiagonalView_shape_diagonal_position, this.diagonalPosition);
            attributes.recycle();
        }
        super.setClipPathCreator(new ClipPathManager.ClipPathCreator(){

            @Override
            public Path createClipPath(int width, int height) {
                Path path = new Path();
                float perpendicularHeight = (float)((double)width * Math.tan(Math.toRadians(DiagonalView.this.diagonalAngle)));
                boolean isDirectionLeft = DiagonalView.this.diagonalDirection == 1;
                switch (DiagonalView.this.diagonalPosition) {
                    case 1: {
                        if (isDirectionLeft) {
                            path.moveTo((float)DiagonalView.this.getPaddingLeft(), (float)DiagonalView.this.getPaddingRight());
                            path.lineTo((float)(width - DiagonalView.this.getPaddingRight()), (float)DiagonalView.this.getPaddingTop());
                            path.lineTo((float)(width - DiagonalView.this.getPaddingRight()), (float)height - perpendicularHeight - (float)DiagonalView.this.getPaddingBottom());
                            path.lineTo((float)DiagonalView.this.getPaddingLeft(), (float)(height - DiagonalView.this.getPaddingBottom()));
                            path.close();
                            break;
                        }
                        path.moveTo((float)(width - DiagonalView.this.getPaddingRight()), (float)(height - DiagonalView.this.getPaddingBottom()));
                        path.lineTo((float)DiagonalView.this.getPaddingLeft(), (float)height - perpendicularHeight - (float)DiagonalView.this.getPaddingBottom());
                        path.lineTo((float)DiagonalView.this.getPaddingLeft(), (float)DiagonalView.this.getPaddingTop());
                        path.lineTo((float)(width - DiagonalView.this.getPaddingRight()), (float)DiagonalView.this.getPaddingTop());
                        path.close();
                        break;
                    }
                    case 2: {
                        if (isDirectionLeft) {
                            path.moveTo((float)(width - DiagonalView.this.getPaddingRight()), (float)(height - DiagonalView.this.getPaddingBottom()));
                            path.lineTo((float)(width - DiagonalView.this.getPaddingRight()), (float)DiagonalView.this.getPaddingTop() + perpendicularHeight);
                            path.lineTo((float)DiagonalView.this.getPaddingLeft(), (float)DiagonalView.this.getPaddingTop());
                            path.lineTo((float)DiagonalView.this.getPaddingLeft(), (float)(height - DiagonalView.this.getPaddingBottom()));
                            path.close();
                            break;
                        }
                        path.moveTo((float)(width - DiagonalView.this.getPaddingRight()), (float)(height - DiagonalView.this.getPaddingBottom()));
                        path.lineTo((float)(width - DiagonalView.this.getPaddingRight()), (float)DiagonalView.this.getPaddingTop());
                        path.lineTo((float)DiagonalView.this.getPaddingLeft(), (float)DiagonalView.this.getPaddingTop() + perpendicularHeight);
                        path.lineTo((float)DiagonalView.this.getPaddingLeft(), (float)(height - DiagonalView.this.getPaddingBottom()));
                        path.close();
                        break;
                    }
                    case 4: {
                        if (isDirectionLeft) {
                            path.moveTo((float)DiagonalView.this.getPaddingLeft(), (float)DiagonalView.this.getPaddingTop());
                            path.lineTo((float)(width - DiagonalView.this.getPaddingRight()), (float)DiagonalView.this.getPaddingTop());
                            path.lineTo((float)(width - DiagonalView.this.getPaddingRight()) - perpendicularHeight, (float)(height - DiagonalView.this.getPaddingBottom()));
                            path.lineTo((float)DiagonalView.this.getPaddingLeft(), (float)(height - DiagonalView.this.getPaddingBottom()));
                            path.close();
                            break;
                        }
                        path.moveTo((float)DiagonalView.this.getPaddingLeft(), (float)DiagonalView.this.getPaddingTop());
                        path.lineTo((float)(width - DiagonalView.this.getPaddingRight()) - perpendicularHeight, (float)DiagonalView.this.getPaddingTop());
                        path.lineTo((float)(width - DiagonalView.this.getPaddingRight()), (float)(height - DiagonalView.this.getPaddingBottom()));
                        path.lineTo((float)DiagonalView.this.getPaddingLeft(), (float)(height - DiagonalView.this.getPaddingBottom()));
                        path.close();
                        break;
                    }
                    case 3: {
                        if (isDirectionLeft) {
                            path.moveTo((float)DiagonalView.this.getPaddingLeft() + perpendicularHeight, (float)DiagonalView.this.getPaddingTop());
                            path.lineTo((float)(width - DiagonalView.this.getPaddingRight()), (float)DiagonalView.this.getPaddingTop());
                            path.lineTo((float)(width - DiagonalView.this.getPaddingRight()), (float)(height - DiagonalView.this.getPaddingBottom()));
                            path.lineTo((float)DiagonalView.this.getPaddingLeft(), (float)(height - DiagonalView.this.getPaddingBottom()));
                            path.close();
                            break;
                        }
                        path.moveTo((float)DiagonalView.this.getPaddingLeft(), (float)DiagonalView.this.getPaddingTop());
                        path.lineTo((float)(width - DiagonalView.this.getPaddingRight()), (float)DiagonalView.this.getPaddingTop());
                        path.lineTo((float)(width - DiagonalView.this.getPaddingRight()), (float)(height - DiagonalView.this.getPaddingBottom()));
                        path.lineTo((float)DiagonalView.this.getPaddingLeft() + perpendicularHeight, (float)(height - DiagonalView.this.getPaddingBottom()));
                        path.close();
                    }
                }
                return path;
            }

            @Override
            public boolean requiresBitmap() {
                return false;
            }
        });
    }

    public void setDiagonalPosition(@DiagonalPosition int diagonalPosition) {
        this.diagonalPosition = diagonalPosition;
        this.requiresShapeUpdate();
    }

    public int getDiagonalPosition() {
        return this.diagonalPosition;
    }

    public int getDiagonalDirection() {
        return this.diagonalDirection;
    }

    public void setDiagonalDirection(int diagonalDirection) {
        this.diagonalDirection = diagonalDirection;
        this.requiresShapeUpdate();
    }

    public float getDiagonalAngle() {
        return this.diagonalAngle;
    }

    public void setDiagonalAngle(float diagonalAngle) {
        this.diagonalAngle = diagonalAngle;
        this.requiresShapeUpdate();
    }

    public static @interface DiagonalDirection {
    }

    public static @interface DiagonalPosition {
    }
}

