/*
 * Decompiled with CFR 0.152.
 */
package com.github.florent37.shapeofview.shapes;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Path;
import android.util.AttributeSet;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.github.florent37.shapeofview.R;
import com.github.florent37.shapeofview.ShapeOfView;
import com.github.florent37.shapeofview.manager.ClipPathManager;

public class ArcView
extends ShapeOfView {
    public static final int POSITION_BOTTOM = 1;
    public static final int POSITION_TOP = 2;
    public static final int POSITION_LEFT = 3;
    public static final int POSITION_RIGHT = 4;
    public static final int CROP_INSIDE = 1;
    public static final int CROP_OUTSIDE = 2;
    @ArcPosition
    private int arcPosition = 2;
    private float arcHeightPx = 0.0f;

    public ArcView(@NonNull Context context) {
        super(context);
        this.init(context, null);
    }

    public ArcView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public ArcView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        if (attrs != null) {
            TypedArray attributes = context.obtainStyledAttributes(attrs, R.styleable.ArcView);
            this.arcHeightPx = attributes.getDimensionPixelSize(R.styleable.ArcView_shape_arc_height, (int)this.arcHeightPx);
            this.arcPosition = attributes.getInteger(R.styleable.ArcView_shape_arc_position, this.arcPosition);
            attributes.recycle();
        }
        super.setClipPathCreator(new ClipPathManager.ClipPathCreator(){

            @Override
            public Path createClipPath(int width, int height) {
                Path path = new Path();
                boolean isCropInside = ArcView.this.getCropDirection() == 1;
                float arcHeightAbs = Math.abs(ArcView.this.arcHeightPx);
                switch (ArcView.this.arcPosition) {
                    case 1: {
                        if (isCropInside) {
                            path.moveTo(0.0f, 0.0f);
                            path.lineTo(0.0f, (float)height);
                            path.quadTo((float)(width / 2), (float)height - 2.0f * arcHeightAbs, (float)width, (float)height);
                            path.lineTo((float)width, 0.0f);
                            path.close();
                            break;
                        }
                        path.moveTo(0.0f, 0.0f);
                        path.lineTo(0.0f, (float)height - arcHeightAbs);
                        path.quadTo((float)(width / 2), (float)height + arcHeightAbs, (float)width, (float)height - arcHeightAbs);
                        path.lineTo((float)width, 0.0f);
                        path.close();
                        break;
                    }
                    case 2: {
                        if (isCropInside) {
                            path.moveTo(0.0f, (float)height);
                            path.lineTo(0.0f, 0.0f);
                            path.quadTo((float)(width / 2), 2.0f * arcHeightAbs, (float)width, 0.0f);
                            path.lineTo((float)width, (float)height);
                            path.close();
                            break;
                        }
                        path.moveTo(0.0f, arcHeightAbs);
                        path.quadTo((float)(width / 2), -arcHeightAbs, (float)width, arcHeightAbs);
                        path.lineTo((float)width, (float)height);
                        path.lineTo(0.0f, (float)height);
                        path.close();
                        break;
                    }
                    case 3: {
                        if (isCropInside) {
                            path.moveTo((float)width, 0.0f);
                            path.lineTo(0.0f, 0.0f);
                            path.quadTo(arcHeightAbs * 2.0f, (float)(height / 2), 0.0f, (float)height);
                            path.lineTo((float)width, (float)height);
                            path.close();
                            break;
                        }
                        path.moveTo((float)width, 0.0f);
                        path.lineTo(arcHeightAbs, 0.0f);
                        path.quadTo(-arcHeightAbs, (float)(height / 2), arcHeightAbs, (float)height);
                        path.lineTo((float)width, (float)height);
                        path.close();
                        break;
                    }
                    case 4: {
                        if (isCropInside) {
                            path.moveTo(0.0f, 0.0f);
                            path.lineTo((float)width, 0.0f);
                            path.quadTo((float)width - arcHeightAbs * 2.0f, (float)(height / 2), (float)width, (float)height);
                            path.lineTo(0.0f, (float)height);
                            path.close();
                            break;
                        }
                        path.moveTo(0.0f, 0.0f);
                        path.lineTo((float)width - arcHeightAbs, 0.0f);
                        path.quadTo((float)width + arcHeightAbs, (float)(height / 2), (float)width - arcHeightAbs, (float)height);
                        path.lineTo(0.0f, (float)height);
                        path.close();
                    }
                }
                return path;
            }

            @Override
            public boolean requiresBitmap() {
                return false;
            }
        });
    }

    public int getArcPosition() {
        return this.arcPosition;
    }

    public void setArcPosition(@ArcPosition int arcPosition) {
        this.arcPosition = arcPosition;
        this.requiresShapeUpdate();
    }

    public int getCropDirection() {
        return this.arcHeightPx > 0.0f ? 2 : 1;
    }

    public float getArcHeight() {
        return this.arcHeightPx;
    }

    public void setArcHeight(float arcHeight) {
        this.arcHeightPx = arcHeight;
        this.requiresShapeUpdate();
    }

    public float getArcHeightDp() {
        return this.pxToDp(this.arcHeightPx);
    }

    public void setArcHeightDp(float arcHeight) {
        this.setArcHeight(this.dpToPx(arcHeight));
    }

    public static @interface CropDirection {
    }

    public static @interface ArcPosition {
    }
}

