/*
 * Decompiled with CFR 0.152.
 */
package com.github.florent37.shapeofview.shapes;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Path;
import android.graphics.RectF;
import android.util.AttributeSet;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.github.florent37.shapeofview.R;
import com.github.florent37.shapeofview.ShapeOfView;
import com.github.florent37.shapeofview.manager.ClipPathManager;

public class BubbleView
extends ShapeOfView {
    public static final int POSITION_BOTTOM = 1;
    public static final int POSITION_TOP = 2;
    public static final int POSITION_LEFT = 3;
    public static final int POSITION_RIGHT = 4;
    @Position
    private int position = 1;
    private float borderRadiusPx;
    private float arrowHeightPx;
    private float arrowWidthPx;

    public BubbleView(@NonNull Context context) {
        super(context);
        this.init(context, null);
    }

    public BubbleView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public BubbleView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        if (attrs != null) {
            TypedArray attributes = context.obtainStyledAttributes(attrs, R.styleable.BubbleView);
            this.borderRadiusPx = attributes.getDimensionPixelSize(R.styleable.BubbleView_shape_bubble_borderRadius, this.dpToPx(10.0f));
            this.position = attributes.getInteger(R.styleable.BubbleView_shape_bubble_arrowPosition, this.position);
            this.arrowHeightPx = attributes.getDimensionPixelSize(R.styleable.BubbleView_shape_bubble_arrowHeight, this.dpToPx(10.0f));
            this.arrowWidthPx = attributes.getDimensionPixelSize(R.styleable.BubbleView_shape_bubble_arrowWidth, this.dpToPx(10.0f));
            attributes.recycle();
        }
        super.setClipPathCreator(new ClipPathManager.ClipPathCreator(){

            @Override
            public Path createClipPath(int width, int height) {
                RectF myRect = new RectF(0.0f, 0.0f, (float)width, (float)height);
                return BubbleView.this.drawBubble(myRect, BubbleView.this.borderRadiusPx, BubbleView.this.borderRadiusPx, BubbleView.this.borderRadiusPx, BubbleView.this.borderRadiusPx);
            }

            @Override
            public boolean requiresBitmap() {
                return false;
            }
        });
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(@Position int position) {
        this.position = position;
        this.requiresShapeUpdate();
    }

    public float getBorderRadiusPx() {
        return this.borderRadiusPx;
    }

    public void setBorderRadiusPx(float borderRadiusPx) {
        this.borderRadiusPx = borderRadiusPx;
        this.requiresShapeUpdate();
    }

    public void setBorderRadiusDp(float borderRadiusDp) {
        this.borderRadiusPx = this.dpToPx(borderRadiusDp);
        this.requiresShapeUpdate();
    }

    public float getArrowHeightPx() {
        return this.arrowHeightPx;
    }

    public void setArrowHeightPx(float arrowHeight) {
        this.arrowHeightPx = arrowHeight;
        this.requiresShapeUpdate();
    }

    public void setArrowHeightDp(float arrowHeight) {
        this.setArrowHeightPx(this.dpToPx(arrowHeight));
    }

    public float getArrowWidthPx() {
        return this.arrowWidthPx;
    }

    public void setArrowWidthPx(float arrowWidth) {
        this.arrowWidthPx = arrowWidth;
        this.requiresShapeUpdate();
    }

    public void setArrowWidthDp(float arrowWidth) {
        this.setArrowWidthPx(this.dpToPx(arrowWidth));
    }

    private Path drawBubble(RectF myRect, float topLeftDiameter, float topRightDiameter, float bottomRightDiameter, float bottomLeftDiameter) {
        Path path = new Path();
        topLeftDiameter = topLeftDiameter < 0.0f ? 0.0f : topLeftDiameter;
        topRightDiameter = topRightDiameter < 0.0f ? 0.0f : topRightDiameter;
        bottomLeftDiameter = bottomLeftDiameter < 0.0f ? 0.0f : bottomLeftDiameter;
        bottomRightDiameter = bottomRightDiameter < 0.0f ? 0.0f : bottomRightDiameter;
        float spacingLeft = this.position == 3 ? this.arrowHeightPx : 0.0f;
        float spacingTop = this.position == 2 ? this.arrowHeightPx : 0.0f;
        float spacingRight = this.position == 4 ? this.arrowHeightPx : 0.0f;
        float spacingBottom = this.position == 1 ? this.arrowHeightPx : 0.0f;
        float left = spacingLeft + myRect.left;
        float top = spacingTop + myRect.top;
        float right = myRect.right - spacingRight;
        float bottom = myRect.bottom - spacingBottom;
        float centerX = myRect.centerX();
        path.moveTo(left + topLeftDiameter / 2.0f, top);
        if (this.position == 2) {
            path.lineTo(centerX - this.arrowWidthPx, top);
            path.lineTo(centerX, myRect.top);
            path.lineTo(centerX + this.arrowWidthPx, top);
        }
        path.lineTo(right - topRightDiameter / 2.0f, top);
        path.quadTo(right, top, right, top + topRightDiameter / 2.0f);
        if (this.position == 4) {
            path.lineTo(right, bottom / 2.0f - this.arrowWidthPx);
            path.lineTo(myRect.right, bottom / 2.0f);
            path.lineTo(right, bottom / 2.0f + this.arrowWidthPx);
        }
        path.lineTo(right, bottom - bottomRightDiameter / 2.0f);
        path.quadTo(right, bottom, right - bottomRightDiameter / 2.0f, bottom);
        if (this.position == 1) {
            path.lineTo(centerX + this.arrowWidthPx, bottom);
            path.lineTo(centerX, myRect.bottom);
            path.lineTo(centerX - this.arrowWidthPx, bottom);
        }
        path.lineTo(left + bottomLeftDiameter / 2.0f, bottom);
        path.quadTo(left, bottom, left, bottom - bottomLeftDiameter / 2.0f);
        if (this.position == 3) {
            path.lineTo(left, bottom / 2.0f + this.arrowWidthPx);
            path.lineTo(myRect.left, bottom / 2.0f);
            path.lineTo(left, bottom / 2.0f - this.arrowWidthPx);
        }
        path.lineTo(left, top + topLeftDiameter / 2.0f);
        path.quadTo(left, top, left + topLeftDiameter / 2.0f, top);
        path.close();
        return path;
    }

    public static @interface Position {
    }
}

