/*
 * Decompiled with CFR 0.152.
 */
package com.github.florent37.shapeofview.shapes;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Path;
import android.graphics.RectF;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import com.github.florent37.shapeofview.R;
import com.github.florent37.shapeofview.ShapeOfView;
import com.github.florent37.shapeofview.manager.ClipPathManager;

public class CutCornerView
extends ShapeOfView {
    private final RectF rectF = new RectF();
    private int topLeftCutSize;
    private int topRightCutSize;
    private int bottomRightCutSize;
    private int bottomLeftCutSize;

    public CutCornerView(@NonNull Context context) {
        super(context);
        this.init(context, null);
    }

    public CutCornerView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public CutCornerView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        if (attrs != null) {
            TypedArray attributes = context.obtainStyledAttributes(attrs, R.styleable.CutCornerView);
            this.topLeftCutSize = attributes.getDimensionPixelSize(R.styleable.CutCornerView_shape_cutCorner_topLeftSize, this.topLeftCutSize);
            this.topRightCutSize = attributes.getDimensionPixelSize(R.styleable.CutCornerView_shape_cutCorner_topRightSize, this.topRightCutSize);
            this.bottomLeftCutSize = attributes.getDimensionPixelSize(R.styleable.CutCornerView_shape_cutCorner_bottomLeftSize, this.bottomLeftCutSize);
            this.bottomRightCutSize = attributes.getDimensionPixelSize(R.styleable.CutCornerView_shape_cutCorner_bottomRightSize, this.bottomRightCutSize);
            attributes.recycle();
        }
        super.setClipPathCreator(new ClipPathManager.ClipPathCreator(){

            @Override
            public Path createClipPath(int width, int height) {
                CutCornerView.this.rectF.set(0.0f, 0.0f, (float)width, (float)height);
                return CutCornerView.this.generatePath(CutCornerView.this.rectF, CutCornerView.this.topLeftCutSize, CutCornerView.this.topRightCutSize, CutCornerView.this.bottomRightCutSize, CutCornerView.this.bottomLeftCutSize);
            }

            @Override
            public boolean requiresBitmap() {
                return false;
            }
        });
    }

    private Path generatePath(RectF rect, float topLeftDiameter, float topRightDiameter, float bottomRightDiameter, float bottomLeftDiameter) {
        Path path = new Path();
        topLeftDiameter = topLeftDiameter < 0.0f ? 0.0f : topLeftDiameter;
        topRightDiameter = topRightDiameter < 0.0f ? 0.0f : topRightDiameter;
        bottomLeftDiameter = bottomLeftDiameter < 0.0f ? 0.0f : bottomLeftDiameter;
        bottomRightDiameter = bottomRightDiameter < 0.0f ? 0.0f : bottomRightDiameter;
        path.moveTo(rect.left + topLeftDiameter, rect.top);
        path.lineTo(rect.right - topRightDiameter, rect.top);
        path.lineTo(rect.right, rect.top + topRightDiameter);
        path.lineTo(rect.right, rect.bottom - bottomRightDiameter);
        path.lineTo(rect.right - bottomRightDiameter, rect.bottom);
        path.lineTo(rect.left + bottomLeftDiameter, rect.bottom);
        path.lineTo(rect.left, rect.bottom - bottomLeftDiameter);
        path.lineTo(rect.left, rect.top + topLeftDiameter);
        path.lineTo(rect.left + topLeftDiameter, rect.top);
        path.close();
        return path;
    }

    public int getTopLeftCutSize() {
        return this.topLeftCutSize;
    }

    public void setTopLeftCutSize(int topLeftCutSize) {
        this.topLeftCutSize = topLeftCutSize;
        this.requiresShapeUpdate();
    }

    public int getTopRightCutSize() {
        return this.topRightCutSize;
    }

    public void setTopRightCutSize(int topRightCutSize) {
        this.topRightCutSize = topRightCutSize;
        this.requiresShapeUpdate();
    }

    public int getBottomRightCutSize() {
        return this.bottomRightCutSize;
    }

    public void setBottomRightCutSize(int bottomRightCutSize) {
        this.bottomRightCutSize = bottomRightCutSize;
        this.requiresShapeUpdate();
    }

    public int getBottomLeftCutSize() {
        return this.bottomLeftCutSize;
    }

    public void setBottomLeftCutSize(int bottomLeftCutSize) {
        this.bottomLeftCutSize = bottomLeftCutSize;
        this.requiresShapeUpdate();
    }
}

