/*
 * Decompiled with CFR 0.152.
 */
package com.github.florent37.runtimepermission;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.support.annotation.NonNull;
import java.util.ArrayList;
import java.util.List;

public class PermissionManifestFinder {
    @TargetApi(value=16)
    @NonNull
    public static List<String> findNeededPermissionsFromManifest(Context context) {
        PackageManager pm = context.getPackageManager();
        PackageInfo info = null;
        try {
            info = pm.getPackageInfo(context.getPackageName(), 4096);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        ArrayList<String> needed = new ArrayList<String>();
        if (info != null && info.requestedPermissions != null && info.requestedPermissionsFlags != null) {
            for (int i = 0; i < info.requestedPermissions.length; ++i) {
                int flags = info.requestedPermissionsFlags[i];
                String group = null;
                try {
                    group = pm.getPermissionInfo((String)info.requestedPermissions[i], (int)0).group;
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    // empty catch block
                }
                if ((flags & 2) != 0 || group == null) continue;
                needed.add(info.requestedPermissions[i]);
            }
        }
        return needed;
    }
}

