/*
 * Decompiled with CFR 0.152.
 */
package com.github.florent37.kotlin.pleaseanimate.core.position;

import android.view.View;
import com.github.florent37.kotlin.pleaseanimate.core.position.PositionAnimExpectation;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0004\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\u0017\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\fJ\u0017\u0010\r\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/github/florent37/kotlin/pleaseanimate/core/position/PositionAnimExpectationCenterBetweenViews;", "Lcom/github/florent37/kotlin/pleaseanimate/core/position/PositionAnimExpectation;", "view1", "Landroid/view/View;", "view2", "horizontal", "", "vertical", "(Landroid/view/View;Landroid/view/View;ZZ)V", "getCalculatedValueX", "", "viewToMove", "(Landroid/view/View;)Ljava/lang/Float;", "getCalculatedValueY", "kotlinpleaseanimate_release"})
public final class PositionAnimExpectationCenterBetweenViews
extends PositionAnimExpectation {
    private final View view1;
    private final View view2;
    private final boolean horizontal;
    private final boolean vertical;

    @Override
    @Nullable
    public Float getCalculatedValueX(@NotNull View viewToMove) {
        Intrinsics.checkParameterIsNotNull((Object)viewToMove, (String)"viewToMove");
        if (this.horizontal) {
            int centerXView1 = (int)((float)this.view1.getLeft() + (float)this.view1.getWidth() / 2.0f);
            int centerXView2 = (int)((float)this.view2.getLeft() + (float)this.view2.getWidth() / 2.0f);
            return Float.valueOf((float)(centerXView1 + centerXView2) / 2.0f - (float)viewToMove.getWidth() / 2.0f);
        }
        return null;
    }

    @Override
    @Nullable
    public Float getCalculatedValueY(@NotNull View viewToMove) {
        Intrinsics.checkParameterIsNotNull((Object)viewToMove, (String)"viewToMove");
        if (this.vertical) {
            int centerYView1 = (int)((float)this.view1.getTop() + (float)this.view1.getHeight() / 2.0f);
            int centerYView2 = (int)((float)this.view2.getTop() + (float)this.view2.getHeight() / 2.0f);
            return Float.valueOf((float)(centerYView1 + centerYView2) / 2.0f - (float)viewToMove.getHeight() / 2.0f);
        }
        return null;
    }

    public PositionAnimExpectationCenterBetweenViews(@NotNull View view1, @NotNull View view2, boolean horizontal, boolean vertical) {
        Intrinsics.checkParameterIsNotNull((Object)view1, (String)"view1");
        Intrinsics.checkParameterIsNotNull((Object)view2, (String)"view2");
        this.view1 = view1;
        this.view2 = view2;
        this.horizontal = horizontal;
        this.vertical = vertical;
        this.setForPositionY(true);
        this.setForPositionX(true);
        this.getViewsDependencies().add(this.view1);
        this.getViewsDependencies().add(this.view2);
    }
}

