/*
 * Decompiled with CFR 0.152.
 */
package com.github.florent37.kotlin.pleaseanimate;

import android.view.View;
import com.github.florent37.kotlin.pleaseanimate.ViewExpectation;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\bJ\u000e\u0010\r\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\bJ\u000e\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\bJ\u000e\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\bJ\u001a\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\b2\b\b\u0002\u0010\u0011\u001a\u00020\u0004H\u0007J\u000e\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\bJ\u001a\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\b2\b\b\u0002\u0010\u0011\u001a\u00020\u0004H\u0007J\u000e\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\bJ \u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u000bH\u0002J \u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u000bH\u0002J\u0016\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\tJ\u000e\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\tJ \u0010\u001c\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u000bH\u0002J \u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u000bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/github/florent37/kotlin/pleaseanimate/ViewCalculator;", "", "()V", "enableRotation", "", "enableScale", "expectationForView", "", "Landroid/view/View;", "Lcom/github/florent37/kotlin/pleaseanimate/ViewExpectation;", "finalCenterXOfView", "", "view", "finalCenterYOfView", "finalHeightOfView", "finalPositionBottomOfView", "finalPositionLeftOfView", "itsMe", "finalPositionRightOfView", "finalPositionTopOfView", "finalWidthOfView", "heightRotated", "viewExpectation", "height", "heightScaled", "setExpectationForView", "", "wasCalculated", "widthRotated", "width", "widthScaled", "kotlinpleaseanimate_release"})
public final class ViewCalculator {
    private final Map<View, ViewExpectation> expectationForView;
    private final boolean enableRotation = true;
    private final boolean enableScale = true;

    public final void setExpectationForView(@NotNull View view, @NotNull ViewExpectation viewExpectation) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        Intrinsics.checkParameterIsNotNull((Object)viewExpectation, (String)"viewExpectation");
        this.expectationForView.put(view, viewExpectation);
    }

    public final void wasCalculated(@NotNull ViewExpectation viewExpectation) {
        Intrinsics.checkParameterIsNotNull((Object)viewExpectation, (String)"viewExpectation");
    }

    @JvmOverloads
    public final float finalPositionLeftOfView(@NotNull View view, boolean itsMe) {
        Float futurPositionX;
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        Float finalX = null;
        ViewExpectation viewExpectation = this.expectationForView.get(view);
        if (viewExpectation != null && (futurPositionX = viewExpectation.getFuturPositionX$kotlinpleaseanimate_release()) != null) {
            finalX = futurPositionX;
        }
        if (finalX == null) {
            finalX = Float.valueOf(view.getX());
        }
        if (itsMe) {
            finalX = Float.valueOf(finalX.floatValue() - ((float)view.getWidth() - this.finalWidthOfView(view)) / 2.0f);
        }
        return finalX.floatValue();
    }

    @JvmOverloads
    public static /* bridge */ /* synthetic */ float finalPositionLeftOfView$default(ViewCalculator viewCalculator, View view, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return viewCalculator.finalPositionLeftOfView(view, bl);
    }

    @JvmOverloads
    public final float finalPositionLeftOfView(@NotNull View view) {
        return ViewCalculator.finalPositionLeftOfView$default(this, view, false, 2, null);
    }

    public final float finalPositionRightOfView(@NotNull View view) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        return ViewCalculator.finalPositionLeftOfView$default(this, view, false, 2, null) + this.finalWidthOfView(view);
    }

    @JvmOverloads
    public final float finalPositionTopOfView(@NotNull View view, boolean itsMe) {
        Float futurPositionY;
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        Float finalTop = null;
        ViewExpectation viewExpectation = this.expectationForView.get(view);
        if (viewExpectation != null && (futurPositionY = viewExpectation.getFuturPositionY$kotlinpleaseanimate_release()) != null) {
            finalTop = futurPositionY;
        }
        if (finalTop == null) {
            finalTop = Float.valueOf(1.0f * (float)view.getTop());
        }
        if (itsMe) {
            finalTop = Float.valueOf(finalTop.floatValue() - ((float)view.getHeight() - this.finalHeightOfView(view)) / 2.0f);
        }
        return finalTop.floatValue();
    }

    @JvmOverloads
    public static /* bridge */ /* synthetic */ float finalPositionTopOfView$default(ViewCalculator viewCalculator, View view, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return viewCalculator.finalPositionTopOfView(view, bl);
    }

    @JvmOverloads
    public final float finalPositionTopOfView(@NotNull View view) {
        return ViewCalculator.finalPositionTopOfView$default(this, view, false, 2, null);
    }

    public final float finalPositionBottomOfView(@NotNull View view) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        return ViewCalculator.finalPositionTopOfView$default(this, view, false, 2, null) + this.finalHeightOfView(view);
    }

    public final float finalCenterXOfView(@NotNull View view) {
        float f;
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        if (this.expectationForView.containsKey(view)) {
            ViewExpectation viewExpectation = this.expectationForView.get(view);
            if (viewExpectation == null) {
                Intrinsics.throwNpe();
            }
            Float f2 = viewExpectation.getFuturPositionX$kotlinpleaseanimate_release();
            if (f2 == null) {
                Intrinsics.throwNpe();
            }
            f = f2.floatValue() + this.finalWidthOfView(view) / 2.0f;
        } else {
            f = (float)view.getLeft() + (float)view.getWidth() / 2.0f;
        }
        return f;
    }

    public final float finalCenterYOfView(@NotNull View view) {
        float f;
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        if (this.expectationForView.containsKey(view)) {
            ViewExpectation viewExpectation = this.expectationForView.get(view);
            if (viewExpectation == null) {
                Intrinsics.throwNpe();
            }
            Float f2 = viewExpectation.getFuturPositionY$kotlinpleaseanimate_release();
            if (f2 == null) {
                Intrinsics.throwNpe();
            }
            f = f2.floatValue() + this.finalHeightOfView(view) / 2.0f;
        } else {
            f = (float)view.getTop() + (float)view.getHeight() / 2.0f;
        }
        return f;
    }

    public final float finalWidthOfView(@NotNull View view) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        float with = view.getWidth();
        if (this.expectationForView.containsKey(view)) {
            ViewExpectation viewExpectation;
            ViewExpectation viewExpectation2 = viewExpectation = this.expectationForView.get(view);
            if (viewExpectation2 == null) {
                Intrinsics.throwNpe();
            }
            with = this.widthScaled(viewExpectation2, view, with);
            if (this.enableRotation) {
                with = this.widthRotated(viewExpectation, view, with);
            }
        }
        return with;
    }

    private final float widthScaled(ViewExpectation viewExpectation, View view, float width) {
        float w = width;
        float scaleX = viewExpectation.getWillHasScaleX$kotlinpleaseanimate_release();
        if (scaleX != 1.0f) {
            w = scaleX * width;
        }
        return w;
    }

    private final float widthRotated(ViewExpectation viewExpectation, View view, float width) {
        float w = width;
        Float willHaveRotationX = viewExpectation.getWillHaveRotation$kotlinpleaseanimate_release();
        if (willHaveRotationX != null) {
            double radians = Math.toRadians(90.0f - willHaveRotationX.floatValue());
            w = (float)(Math.abs((double)width * Math.sin(radians)) + Math.abs((double)this.heightScaled(viewExpectation, view, view.getHeight()) * Math.cos(radians)));
        }
        return w;
    }

    public final float finalHeightOfView(@NotNull View view) {
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        float height = view.getHeight();
        if (this.expectationForView.containsKey(view)) {
            ViewExpectation viewExpectation;
            ViewExpectation viewExpectation2 = viewExpectation = this.expectationForView.get(view);
            if (viewExpectation2 == null) {
                Intrinsics.throwNpe();
            }
            height = this.heightScaled(viewExpectation2, view, height);
            if (this.enableRotation) {
                height = this.heightRotated(viewExpectation, view, height);
            }
        }
        return height;
    }

    private final float heightScaled(ViewExpectation viewExpectation, View view, float height) {
        float h = height;
        float scaleY = viewExpectation.getWillHasScaleY$kotlinpleaseanimate_release();
        if (scaleY != 1.0f) {
            h = scaleY * height;
        }
        return h;
    }

    private final float heightRotated(ViewExpectation viewExpectation, View view, float height) {
        float h = height;
        Float willHaveRotationX = viewExpectation.getWillHaveRotation$kotlinpleaseanimate_release();
        if (willHaveRotationX != null) {
            double radians = Math.toRadians(willHaveRotationX.floatValue());
            h = (float)(Math.abs((double)height * Math.cos(radians)) + Math.abs((double)this.widthScaled(viewExpectation, view, view.getWidth()) * Math.sin(radians)));
        }
        return h;
    }

    public ViewCalculator() {
        Map map;
        ViewCalculator viewCalculator = this;
        viewCalculator.expectationForView = map = (Map)new LinkedHashMap();
        this.enableRotation = true;
        this.enableScale = true;
    }
}

